goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$IElement$_to_dom$arity$1 == null))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto__.call(null,this$));
} else {
var m__4244__auto____$1 = (shadow.dom._to_dom["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto__.call(null,this$));
} else {
var m__4244__auto____$1 = (shadow.dom._to_svg["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__139396 = coll;
var G__139397 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__139396,G__139397) : shadow.dom.lazy_native_coll_seq.call(null,G__139396,G__139397));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__3949__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return not_found;
}
});

shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
});

shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
});

shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
});

shadow.dom.NativeColl.cljs$lang$type = true;

shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl";

shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"shadow.dom/NativeColl");
});

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode([cljs.core.str.cljs$core$IFn$_invoke$arity$1(el)].join(''));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__139407 = arguments.length;
switch (G__139407) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
});

shadow.dom.query_one.cljs$lang$maxFixedArity = 2;

shadow.dom.query = (function shadow$dom$query(var_args){
var G__139410 = arguments.length;
switch (G__139410) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
});

shadow.dom.query.cljs$lang$maxFixedArity = 2;

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__139413 = arguments.length;
switch (G__139413) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
});

shadow.dom.by_id.cljs$lang$maxFixedArity = 2;

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__139416 = arguments.length;
switch (G__139416) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
e.cancelBubble = true;

e.returnValue = false;
}

return e;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4;

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__139419 = arguments.length;
switch (G__139419) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__139420 = document;
var G__139421 = shadow.dom.dom_node(el);
return goog.dom.contains(G__139420,G__139421);
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
var G__139422 = shadow.dom.dom_node(parent);
var G__139423 = shadow.dom.dom_node(el);
return goog.dom.contains(G__139422,G__139423);
});

shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2;

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
var G__139425 = shadow.dom.dom_node(el);
var G__139426 = cls;
return goog.dom.classlist.add(G__139425,G__139426);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
var G__139427 = shadow.dom.dom_node(el);
var G__139428 = cls;
return goog.dom.classlist.remove(G__139427,G__139428);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__139430 = arguments.length;
switch (G__139430) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
var G__139431 = shadow.dom.dom_node(el);
var G__139432 = cls;
return goog.dom.classlist.toggle(G__139431,G__139432);
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
});

shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3;

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__3949__auto__ = !((typeof document !== 'undefined'));
if(or__3949__auto__){
return or__3949__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e139434){if((e139434 instanceof Object)){
var e = e139434;
return console.log("didnt support attachEvent",el,e);
} else {
throw e139434;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__3949__auto__ = !((typeof document !== 'undefined'));
if(or__3949__auto__){
return or__3949__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__139435 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__139436 = null;
var count__139437 = (0);
var i__139438 = (0);
while(true){
if((i__139438 < count__139437)){
var el = chunk__139436.cljs$core$IIndexed$_nth$arity$2(null,i__139438);
var handler_139445__$1 = ((function (seq__139435,chunk__139436,count__139437,i__139438,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__139435,chunk__139436,count__139437,i__139438,el))
;
var G__139439_139446 = el;
var G__139440_139447 = cljs.core.name(ev);
var G__139441_139448 = handler_139445__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__139439_139446,G__139440_139447,G__139441_139448) : shadow.dom.dom_listen.call(null,G__139439_139446,G__139440_139447,G__139441_139448));


var G__139449 = seq__139435;
var G__139450 = chunk__139436;
var G__139451 = count__139437;
var G__139452 = (i__139438 + (1));
seq__139435 = G__139449;
chunk__139436 = G__139450;
count__139437 = G__139451;
i__139438 = G__139452;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__139435);
if(temp__5457__auto__){
var seq__139435__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__139435__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__139435__$1);
var G__139453 = cljs.core.chunk_rest(seq__139435__$1);
var G__139454 = c__4351__auto__;
var G__139455 = cljs.core.count(c__4351__auto__);
var G__139456 = (0);
seq__139435 = G__139453;
chunk__139436 = G__139454;
count__139437 = G__139455;
i__139438 = G__139456;
continue;
} else {
var el = cljs.core.first(seq__139435__$1);
var handler_139457__$1 = ((function (seq__139435,chunk__139436,count__139437,i__139438,el,seq__139435__$1,temp__5457__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__139435,chunk__139436,count__139437,i__139438,el,seq__139435__$1,temp__5457__auto__))
;
var G__139442_139458 = el;
var G__139443_139459 = cljs.core.name(ev);
var G__139444_139460 = handler_139457__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__139442_139458,G__139443_139459,G__139444_139460) : shadow.dom.dom_listen.call(null,G__139442_139458,G__139443_139459,G__139444_139460));


var G__139461 = cljs.core.next(seq__139435__$1);
var G__139462 = null;
var G__139463 = (0);
var G__139464 = (0);
seq__139435 = G__139461;
chunk__139436 = G__139462;
count__139437 = G__139463;
i__139438 = G__139464;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__139466 = arguments.length;
switch (G__139466) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
var G__139467 = shadow.dom.dom_node(el);
var G__139468 = cljs.core.name(ev);
var G__139469 = handler__$1;
return (shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__139467,G__139468,G__139469) : shadow.dom.dom_listen.call(null,G__139467,G__139468,G__139469));
}
});

shadow.dom.on.cljs$lang$maxFixedArity = 4;

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
var G__139471 = shadow.dom.dom_node(el);
var G__139472 = cljs.core.name(ev);
var G__139473 = handler;
return (shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3(G__139471,G__139472,G__139473) : shadow.dom.dom_listen_remove.call(null,G__139471,G__139472,G__139473));
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__139474 = cljs.core.seq(events);
var chunk__139475 = null;
var count__139476 = (0);
var i__139477 = (0);
while(true){
if((i__139477 < count__139476)){
var vec__139478 = chunk__139475.cljs$core$IIndexed$_nth$arity$2(null,i__139477);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139478,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139478,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__139484 = seq__139474;
var G__139485 = chunk__139475;
var G__139486 = count__139476;
var G__139487 = (i__139477 + (1));
seq__139474 = G__139484;
chunk__139475 = G__139485;
count__139476 = G__139486;
i__139477 = G__139487;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__139474);
if(temp__5457__auto__){
var seq__139474__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__139474__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__139474__$1);
var G__139488 = cljs.core.chunk_rest(seq__139474__$1);
var G__139489 = c__4351__auto__;
var G__139490 = cljs.core.count(c__4351__auto__);
var G__139491 = (0);
seq__139474 = G__139488;
chunk__139475 = G__139489;
count__139476 = G__139490;
i__139477 = G__139491;
continue;
} else {
var vec__139481 = cljs.core.first(seq__139474__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139481,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139481,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__139492 = cljs.core.next(seq__139474__$1);
var G__139493 = null;
var G__139494 = (0);
var G__139495 = (0);
seq__139474 = G__139492;
chunk__139475 = G__139493;
count__139476 = G__139494;
i__139477 = G__139495;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__139496 = cljs.core.seq(styles);
var chunk__139497 = null;
var count__139498 = (0);
var i__139499 = (0);
while(true){
if((i__139499 < count__139498)){
var vec__139500 = chunk__139497.cljs$core$IIndexed$_nth$arity$2(null,i__139499);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139500,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139500,(1),null);
var G__139503_139512 = dom;
var G__139504_139513 = cljs.core.name(k);
var G__139505_139514 = (((v == null))?"":v);
goog.style.setStyle(G__139503_139512,G__139504_139513,G__139505_139514);


var G__139515 = seq__139496;
var G__139516 = chunk__139497;
var G__139517 = count__139498;
var G__139518 = (i__139499 + (1));
seq__139496 = G__139515;
chunk__139497 = G__139516;
count__139498 = G__139517;
i__139499 = G__139518;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__139496);
if(temp__5457__auto__){
var seq__139496__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__139496__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__139496__$1);
var G__139519 = cljs.core.chunk_rest(seq__139496__$1);
var G__139520 = c__4351__auto__;
var G__139521 = cljs.core.count(c__4351__auto__);
var G__139522 = (0);
seq__139496 = G__139519;
chunk__139497 = G__139520;
count__139498 = G__139521;
i__139499 = G__139522;
continue;
} else {
var vec__139506 = cljs.core.first(seq__139496__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139506,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139506,(1),null);
var G__139509_139523 = dom;
var G__139510_139524 = cljs.core.name(k);
var G__139511_139525 = (((v == null))?"":v);
goog.style.setStyle(G__139509_139523,G__139510_139524,G__139511_139525);


var G__139526 = cljs.core.next(seq__139496__$1);
var G__139527 = null;
var G__139528 = (0);
var G__139529 = (0);
seq__139496 = G__139526;
chunk__139497 = G__139527;
count__139498 = G__139528;
i__139499 = G__139529;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__139530_139531 = key;
var G__139530_139532__$1 = (((G__139530_139531 instanceof cljs.core.Keyword))?G__139530_139531.fqn:null);
switch (G__139530_139532__$1) {
case "id":
el.id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "class":
el.className = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "for":
el.htmlFor = value;

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_139534 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__3949__auto__ = goog.string.startsWith(ks_139534,"data-");
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return goog.string.startsWith(ks_139534,"aria-");
}
})())){
el.setAttribute(ks_139534,value);
} else {
(el[ks_139534] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
var G__139535 = shadow.dom.dom_node(el);
var G__139536 = cls;
return goog.dom.classlist.contains(G__139535,G__139536);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec__$1)].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__139537){
var map__139538 = p__139537;
var map__139538__$1 = ((((!((map__139538 == null)))?(((((map__139538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__139538.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__139538):map__139538);
var props = map__139538__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__139538__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__139540 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139540,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139540,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139540,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__139543 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__139543,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__139543;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__139545 = arguments.length;
switch (G__139545) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$lang$maxFixedArity = 2;

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__139547){
var vec__139548 = p__139547;
var seq__139549 = cljs.core.seq(vec__139548);
var first__139550 = cljs.core.first(seq__139549);
var seq__139549__$1 = cljs.core.next(seq__139549);
var nn = first__139550;
var first__139550__$1 = cljs.core.first(seq__139549__$1);
var seq__139549__$2 = cljs.core.next(seq__139549__$1);
var np = first__139550__$1;
var nc = seq__139549__$2;
var node = vec__139548;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__139551 = nn;
var G__139552 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__139551,G__139552) : create_fn.call(null,G__139551,G__139552));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__139553 = nn;
var G__139554 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__139553,G__139554) : create_fn.call(null,G__139553,G__139554));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__139555 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139555,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139555,(1),null);
var seq__139558_139574 = cljs.core.seq(node_children);
var chunk__139559_139575 = null;
var count__139560_139576 = (0);
var i__139561_139577 = (0);
while(true){
if((i__139561_139577 < count__139560_139576)){
var child_struct_139578 = chunk__139559_139575.cljs$core$IIndexed$_nth$arity$2(null,i__139561_139577);
var children_139579 = shadow.dom.dom_node(child_struct_139578);
if(cljs.core.seq_QMARK_(children_139579)){
var seq__139562_139580 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_139579));
var chunk__139564_139581 = null;
var count__139565_139582 = (0);
var i__139566_139583 = (0);
while(true){
if((i__139566_139583 < count__139565_139582)){
var child_139584 = chunk__139564_139581.cljs$core$IIndexed$_nth$arity$2(null,i__139566_139583);
if(cljs.core.truth_(child_139584)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_139584);


var G__139585 = seq__139562_139580;
var G__139586 = chunk__139564_139581;
var G__139587 = count__139565_139582;
var G__139588 = (i__139566_139583 + (1));
seq__139562_139580 = G__139585;
chunk__139564_139581 = G__139586;
count__139565_139582 = G__139587;
i__139566_139583 = G__139588;
continue;
} else {
var G__139589 = seq__139562_139580;
var G__139590 = chunk__139564_139581;
var G__139591 = count__139565_139582;
var G__139592 = (i__139566_139583 + (1));
seq__139562_139580 = G__139589;
chunk__139564_139581 = G__139590;
count__139565_139582 = G__139591;
i__139566_139583 = G__139592;
continue;
}
} else {
var temp__5457__auto___139593 = cljs.core.seq(seq__139562_139580);
if(temp__5457__auto___139593){
var seq__139562_139594__$1 = temp__5457__auto___139593;
if(cljs.core.chunked_seq_QMARK_(seq__139562_139594__$1)){
var c__4351__auto___139595 = cljs.core.chunk_first(seq__139562_139594__$1);
var G__139596 = cljs.core.chunk_rest(seq__139562_139594__$1);
var G__139597 = c__4351__auto___139595;
var G__139598 = cljs.core.count(c__4351__auto___139595);
var G__139599 = (0);
seq__139562_139580 = G__139596;
chunk__139564_139581 = G__139597;
count__139565_139582 = G__139598;
i__139566_139583 = G__139599;
continue;
} else {
var child_139600 = cljs.core.first(seq__139562_139594__$1);
if(cljs.core.truth_(child_139600)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_139600);


var G__139601 = cljs.core.next(seq__139562_139594__$1);
var G__139602 = null;
var G__139603 = (0);
var G__139604 = (0);
seq__139562_139580 = G__139601;
chunk__139564_139581 = G__139602;
count__139565_139582 = G__139603;
i__139566_139583 = G__139604;
continue;
} else {
var G__139605 = cljs.core.next(seq__139562_139594__$1);
var G__139606 = null;
var G__139607 = (0);
var G__139608 = (0);
seq__139562_139580 = G__139605;
chunk__139564_139581 = G__139606;
count__139565_139582 = G__139607;
i__139566_139583 = G__139608;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_139579);
}


var G__139609 = seq__139558_139574;
var G__139610 = chunk__139559_139575;
var G__139611 = count__139560_139576;
var G__139612 = (i__139561_139577 + (1));
seq__139558_139574 = G__139609;
chunk__139559_139575 = G__139610;
count__139560_139576 = G__139611;
i__139561_139577 = G__139612;
continue;
} else {
var temp__5457__auto___139613 = cljs.core.seq(seq__139558_139574);
if(temp__5457__auto___139613){
var seq__139558_139614__$1 = temp__5457__auto___139613;
if(cljs.core.chunked_seq_QMARK_(seq__139558_139614__$1)){
var c__4351__auto___139615 = cljs.core.chunk_first(seq__139558_139614__$1);
var G__139616 = cljs.core.chunk_rest(seq__139558_139614__$1);
var G__139617 = c__4351__auto___139615;
var G__139618 = cljs.core.count(c__4351__auto___139615);
var G__139619 = (0);
seq__139558_139574 = G__139616;
chunk__139559_139575 = G__139617;
count__139560_139576 = G__139618;
i__139561_139577 = G__139619;
continue;
} else {
var child_struct_139620 = cljs.core.first(seq__139558_139614__$1);
var children_139621 = shadow.dom.dom_node(child_struct_139620);
if(cljs.core.seq_QMARK_(children_139621)){
var seq__139568_139622 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_139621));
var chunk__139570_139623 = null;
var count__139571_139624 = (0);
var i__139572_139625 = (0);
while(true){
if((i__139572_139625 < count__139571_139624)){
var child_139626 = chunk__139570_139623.cljs$core$IIndexed$_nth$arity$2(null,i__139572_139625);
if(cljs.core.truth_(child_139626)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_139626);


var G__139627 = seq__139568_139622;
var G__139628 = chunk__139570_139623;
var G__139629 = count__139571_139624;
var G__139630 = (i__139572_139625 + (1));
seq__139568_139622 = G__139627;
chunk__139570_139623 = G__139628;
count__139571_139624 = G__139629;
i__139572_139625 = G__139630;
continue;
} else {
var G__139631 = seq__139568_139622;
var G__139632 = chunk__139570_139623;
var G__139633 = count__139571_139624;
var G__139634 = (i__139572_139625 + (1));
seq__139568_139622 = G__139631;
chunk__139570_139623 = G__139632;
count__139571_139624 = G__139633;
i__139572_139625 = G__139634;
continue;
}
} else {
var temp__5457__auto___139635__$1 = cljs.core.seq(seq__139568_139622);
if(temp__5457__auto___139635__$1){
var seq__139568_139636__$1 = temp__5457__auto___139635__$1;
if(cljs.core.chunked_seq_QMARK_(seq__139568_139636__$1)){
var c__4351__auto___139637 = cljs.core.chunk_first(seq__139568_139636__$1);
var G__139638 = cljs.core.chunk_rest(seq__139568_139636__$1);
var G__139639 = c__4351__auto___139637;
var G__139640 = cljs.core.count(c__4351__auto___139637);
var G__139641 = (0);
seq__139568_139622 = G__139638;
chunk__139570_139623 = G__139639;
count__139571_139624 = G__139640;
i__139572_139625 = G__139641;
continue;
} else {
var child_139642 = cljs.core.first(seq__139568_139636__$1);
if(cljs.core.truth_(child_139642)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_139642);


var G__139643 = cljs.core.next(seq__139568_139636__$1);
var G__139644 = null;
var G__139645 = (0);
var G__139646 = (0);
seq__139568_139622 = G__139643;
chunk__139570_139623 = G__139644;
count__139571_139624 = G__139645;
i__139572_139625 = G__139646;
continue;
} else {
var G__139647 = cljs.core.next(seq__139568_139636__$1);
var G__139648 = null;
var G__139649 = (0);
var G__139650 = (0);
seq__139568_139622 = G__139647;
chunk__139570_139623 = G__139648;
count__139571_139624 = G__139649;
i__139572_139625 = G__139650;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_139621);
}


var G__139651 = cljs.core.next(seq__139558_139614__$1);
var G__139652 = null;
var G__139653 = (0);
var G__139654 = (0);
seq__139558_139574 = G__139651;
chunk__139559_139575 = G__139652;
count__139560_139576 = G__139653;
i__139561_139577 = G__139654;
continue;
}
} else {
}
}
break;
}

return node;
});
cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
});

cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
});
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
var G__139655 = shadow.dom.dom_node(node);
return goog.dom.removeChildren(G__139655);
});
shadow.dom.remove = (function shadow$dom$remove(node){
if(((!((node == null)))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__139657 = cljs.core.seq(node);
var chunk__139658 = null;
var count__139659 = (0);
var i__139660 = (0);
while(true){
if((i__139660 < count__139659)){
var n = chunk__139658.cljs$core$IIndexed$_nth$arity$2(null,i__139660);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__139661 = seq__139657;
var G__139662 = chunk__139658;
var G__139663 = count__139659;
var G__139664 = (i__139660 + (1));
seq__139657 = G__139661;
chunk__139658 = G__139662;
count__139659 = G__139663;
i__139660 = G__139664;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__139657);
if(temp__5457__auto__){
var seq__139657__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__139657__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__139657__$1);
var G__139665 = cljs.core.chunk_rest(seq__139657__$1);
var G__139666 = c__4351__auto__;
var G__139667 = cljs.core.count(c__4351__auto__);
var G__139668 = (0);
seq__139657 = G__139665;
chunk__139658 = G__139666;
count__139659 = G__139667;
i__139660 = G__139668;
continue;
} else {
var n = cljs.core.first(seq__139657__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__139669 = cljs.core.next(seq__139657__$1);
var G__139670 = null;
var G__139671 = (0);
var G__139672 = (0);
seq__139657 = G__139669;
chunk__139658 = G__139670;
count__139659 = G__139671;
i__139660 = G__139672;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
var G__139673 = shadow.dom.dom_node(new$);
var G__139674 = shadow.dom.dom_node(old);
return goog.dom.replaceNode(G__139673,G__139674);
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__139676 = arguments.length;
switch (G__139676) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return shadow.dom.dom_node(el).innerText = new_text;
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
});

shadow.dom.text.cljs$lang$maxFixedArity = 2;

shadow.dom.check = (function shadow$dom$check(var_args){
var G__139679 = arguments.length;
switch (G__139679) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return shadow.dom.dom_node(el).checked = checked;
});

shadow.dom.check.cljs$lang$maxFixedArity = 2;

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__139682 = arguments.length;
switch (G__139682) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__3949__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return default$;
}
});

shadow.dom.attr.cljs$lang$maxFixedArity = 3;

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return shadow.dom.dom_node(node).innerHTML = text;
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4534__auto__ = [];
var len__4531__auto___139689 = arguments.length;
var i__4532__auto___139690 = (0);
while(true){
if((i__4532__auto___139690 < len__4531__auto___139689)){
args__4534__auto__.push((arguments[i__4532__auto___139690]));

var G__139691 = (i__4532__auto___139690 + (1));
i__4532__auto___139690 = G__139691;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__139685_139692 = cljs.core.seq(nodes);
var chunk__139686_139693 = null;
var count__139687_139694 = (0);
var i__139688_139695 = (0);
while(true){
if((i__139688_139695 < count__139687_139694)){
var node_139696 = chunk__139686_139693.cljs$core$IIndexed$_nth$arity$2(null,i__139688_139695);
fragment.appendChild(shadow.dom._to_dom(node_139696));


var G__139697 = seq__139685_139692;
var G__139698 = chunk__139686_139693;
var G__139699 = count__139687_139694;
var G__139700 = (i__139688_139695 + (1));
seq__139685_139692 = G__139697;
chunk__139686_139693 = G__139698;
count__139687_139694 = G__139699;
i__139688_139695 = G__139700;
continue;
} else {
var temp__5457__auto___139701 = cljs.core.seq(seq__139685_139692);
if(temp__5457__auto___139701){
var seq__139685_139702__$1 = temp__5457__auto___139701;
if(cljs.core.chunked_seq_QMARK_(seq__139685_139702__$1)){
var c__4351__auto___139703 = cljs.core.chunk_first(seq__139685_139702__$1);
var G__139704 = cljs.core.chunk_rest(seq__139685_139702__$1);
var G__139705 = c__4351__auto___139703;
var G__139706 = cljs.core.count(c__4351__auto___139703);
var G__139707 = (0);
seq__139685_139692 = G__139704;
chunk__139686_139693 = G__139705;
count__139687_139694 = G__139706;
i__139688_139695 = G__139707;
continue;
} else {
var node_139708 = cljs.core.first(seq__139685_139702__$1);
fragment.appendChild(shadow.dom._to_dom(node_139708));


var G__139709 = cljs.core.next(seq__139685_139702__$1);
var G__139710 = null;
var G__139711 = (0);
var G__139712 = (0);
seq__139685_139692 = G__139709;
chunk__139686_139693 = G__139710;
count__139687_139694 = G__139711;
i__139688_139695 = G__139712;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
});

shadow.dom.fragment.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.dom.fragment.cljs$lang$applyTo = (function (seq139684){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq139684));
});

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__139713_139727 = cljs.core.seq(scripts);
var chunk__139714_139728 = null;
var count__139715_139729 = (0);
var i__139716_139730 = (0);
while(true){
if((i__139716_139730 < count__139715_139729)){
var vec__139717_139731 = chunk__139714_139728.cljs$core$IIndexed$_nth$arity$2(null,i__139716_139730);
var script_tag_139732 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139717_139731,(0),null);
var script_body_139733 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139717_139731,(1),null);
eval(script_body_139733);


var G__139734 = seq__139713_139727;
var G__139735 = chunk__139714_139728;
var G__139736 = count__139715_139729;
var G__139737 = (i__139716_139730 + (1));
seq__139713_139727 = G__139734;
chunk__139714_139728 = G__139735;
count__139715_139729 = G__139736;
i__139716_139730 = G__139737;
continue;
} else {
var temp__5457__auto___139738 = cljs.core.seq(seq__139713_139727);
if(temp__5457__auto___139738){
var seq__139713_139739__$1 = temp__5457__auto___139738;
if(cljs.core.chunked_seq_QMARK_(seq__139713_139739__$1)){
var c__4351__auto___139740 = cljs.core.chunk_first(seq__139713_139739__$1);
var G__139741 = cljs.core.chunk_rest(seq__139713_139739__$1);
var G__139742 = c__4351__auto___139740;
var G__139743 = cljs.core.count(c__4351__auto___139740);
var G__139744 = (0);
seq__139713_139727 = G__139741;
chunk__139714_139728 = G__139742;
count__139715_139729 = G__139743;
i__139716_139730 = G__139744;
continue;
} else {
var vec__139720_139745 = cljs.core.first(seq__139713_139739__$1);
var script_tag_139746 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139720_139745,(0),null);
var script_body_139747 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139720_139745,(1),null);
eval(script_body_139747);


var G__139748 = cljs.core.next(seq__139713_139739__$1);
var G__139749 = null;
var G__139750 = (0);
var G__139751 = (0);
seq__139713_139727 = G__139748;
chunk__139714_139728 = G__139749;
count__139715_139729 = G__139750;
i__139716_139730 = G__139751;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (scripts){
return (function (s__$1,p__139723){
var vec__139724 = p__139723;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139724,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139724,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
});})(scripts))
,s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
el.innerHTML = s;

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
var G__139752 = shadow.dom.dom_node(el);
var G__139753 = cls;
return goog.dom.getAncestorByClass(G__139752,G__139753);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__139755 = arguments.length;
switch (G__139755) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
var G__139756 = shadow.dom.dom_node(el);
var G__139757 = cljs.core.name(tag);
return goog.dom.getAncestorByTagNameAndClass(G__139756,G__139757);
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
var G__139758 = shadow.dom.dom_node(el);
var G__139759 = cljs.core.name(tag);
var G__139760 = cljs.core.name(cls);
return goog.dom.getAncestorByTagNameAndClass(G__139758,G__139759,G__139760);
});

shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3;

shadow.dom.get_value = (function shadow$dom$get_value(dom){
var G__139762 = shadow.dom.dom_node(dom);
return goog.dom.forms.getValue(G__139762);
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
var G__139763 = shadow.dom.dom_node(dom);
var G__139764 = value;
return goog.dom.forms.setValue(G__139763,G__139764);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__139765 = cljs.core.seq(style_keys);
var chunk__139766 = null;
var count__139767 = (0);
var i__139768 = (0);
while(true){
if((i__139768 < count__139767)){
var it = chunk__139766.cljs$core$IIndexed$_nth$arity$2(null,i__139768);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__139769 = seq__139765;
var G__139770 = chunk__139766;
var G__139771 = count__139767;
var G__139772 = (i__139768 + (1));
seq__139765 = G__139769;
chunk__139766 = G__139770;
count__139767 = G__139771;
i__139768 = G__139772;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__139765);
if(temp__5457__auto__){
var seq__139765__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__139765__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__139765__$1);
var G__139773 = cljs.core.chunk_rest(seq__139765__$1);
var G__139774 = c__4351__auto__;
var G__139775 = cljs.core.count(c__4351__auto__);
var G__139776 = (0);
seq__139765 = G__139773;
chunk__139766 = G__139774;
count__139767 = G__139775;
i__139768 = G__139776;
continue;
} else {
var it = cljs.core.first(seq__139765__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__139777 = cljs.core.next(seq__139765__$1);
var G__139778 = null;
var G__139779 = (0);
var G__139780 = (0);
seq__139765 = G__139777;
chunk__139766 = G__139778;
count__139767 = G__139779;
i__139768 = G__139780;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k139782,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__139786 = k139782;
var G__139786__$1 = (((G__139786 instanceof cljs.core.Keyword))?G__139786.fqn:null);
switch (G__139786__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k139782,else__4206__auto__);

}
});

shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer(writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4218__auto__,pr_pair__4220__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4219__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__139781){
var self__ = this;
var G__139781__$1 = this;
return (new cljs.core.RecordIter((0),G__139781__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = (function (){var fexpr__139787 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
;
return fexpr__139787(this__4199__auto____$1);
})();
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this139783,other139784){
var self__ = this;
var this139783__$1 = this;
return ((!((other139784 == null))) && ((this139783__$1.constructor === other139784.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this139783__$1.x,other139784.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this139783__$1.y,other139784.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this139783__$1.__extmap,other139784.__extmap)));
});

shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4213__auto__)),null));
}
});

shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__139781){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__139788 = cljs.core.keyword_identical_QMARK_;
var expr__139789 = k__4211__auto__;
if(cljs.core.truth_((function (){var G__139791 = new cljs.core.Keyword(null,"x","x",2099068185);
var G__139792 = expr__139789;
return (pred__139788.cljs$core$IFn$_invoke$arity$2 ? pred__139788.cljs$core$IFn$_invoke$arity$2(G__139791,G__139792) : pred__139788.call(null,G__139791,G__139792));
})())){
return (new shadow.dom.Coordinate(G__139781,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__139793 = new cljs.core.Keyword(null,"y","y",-1757859776);
var G__139794 = expr__139789;
return (pred__139788.cljs$core$IFn$_invoke$arity$2 ? pred__139788.cljs$core$IFn$_invoke$arity$2(G__139793,G__139794) : pred__139788.call(null,G__139793,G__139794));
})())){
return (new shadow.dom.Coordinate(self__.x,G__139781,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4211__auto__,G__139781),null));
}
}
});

shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__139781){
var self__ = this;
var this__4202__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__139781,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
});

shadow.dom.Coordinate.cljs$lang$type = true;

shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
});

shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write(writer__4241__auto__,"shadow.dom/Coordinate");
});

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__139785){
var extmap__4236__auto__ = (function (){var G__139795 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__139785,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__139785)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__139795);
} else {
return G__139795;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__139785),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__139785),null,cljs.core.not_empty(extmap__4236__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = (function (){var G__139797 = shadow.dom.dom_node(el);
return goog.style.getPosition(G__139797);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = (function (){var G__139798 = shadow.dom.dom_node(el);
return goog.style.getClientPosition(G__139798);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = (function (){var G__139799 = shadow.dom.dom_node(el);
return goog.style.getPageOffset(G__139799);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k139801,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__139805 = k139801;
var G__139805__$1 = (((G__139805 instanceof cljs.core.Keyword))?G__139805.fqn:null);
switch (G__139805__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k139801,else__4206__auto__);

}
});

shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer(writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4218__auto__,pr_pair__4220__auto__,"#shadow.dom.Size{",", ","}",opts__4219__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__139800){
var self__ = this;
var G__139800__$1 = this;
return (new cljs.core.RecordIter((0),G__139800__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = (function (){var fexpr__139806 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
;
return fexpr__139806(this__4199__auto____$1);
})();
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this139802,other139803){
var self__ = this;
var this139802__$1 = this;
return ((!((other139803 == null))) && ((this139802__$1.constructor === other139803.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this139802__$1.w,other139803.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this139802__$1.h,other139803.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this139802__$1.__extmap,other139803.__extmap)));
});

shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4213__auto__)),null));
}
});

shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__139800){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__139807 = cljs.core.keyword_identical_QMARK_;
var expr__139808 = k__4211__auto__;
if(cljs.core.truth_((function (){var G__139810 = new cljs.core.Keyword(null,"w","w",354169001);
var G__139811 = expr__139808;
return (pred__139807.cljs$core$IFn$_invoke$arity$2 ? pred__139807.cljs$core$IFn$_invoke$arity$2(G__139810,G__139811) : pred__139807.call(null,G__139810,G__139811));
})())){
return (new shadow.dom.Size(G__139800,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__139812 = new cljs.core.Keyword(null,"h","h",1109658740);
var G__139813 = expr__139808;
return (pred__139807.cljs$core$IFn$_invoke$arity$2 ? pred__139807.cljs$core$IFn$_invoke$arity$2(G__139812,G__139813) : pred__139807.call(null,G__139812,G__139813));
})())){
return (new shadow.dom.Size(self__.w,G__139800,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4211__auto__,G__139800),null));
}
}
});

shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__139800){
var self__ = this;
var this__4202__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__139800,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
});

shadow.dom.Size.cljs$lang$type = true;

shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
});

shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write(writer__4241__auto__,"shadow.dom/Size");
});

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__139804){
var extmap__4236__auto__ = (function (){var G__139814 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__139804,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__139804)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__139814);
} else {
return G__139814;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__139804),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__139804),null,cljs.core.not_empty(extmap__4236__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj((function (){var G__139816 = shadow.dom.dom_node(el);
return goog.style.getSize(G__139816);
})());
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(shadow.dom.get_size(el));
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4405__auto__ = opts;
var l__4406__auto__ = a__4405__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4406__auto__)){
var G__139817 = (i + (1));
var G__139818 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__139817;
ret = G__139818;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__139819){
var vec__139820 = p__139819;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139820,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139820,(1),null);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(k)),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent([cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
}),query_params)))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__139824 = arguments.length;
switch (G__139824) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
});

shadow.dom.redirect.cljs$lang$maxFixedArity = 2;

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return document.location.href = document.location.href;
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__139826_139828 = new_node;
var G__139827_139829 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingAfter(G__139826_139828,G__139827_139829);

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__139830_139832 = new_node;
var G__139831_139833 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingBefore(G__139830_139832,G__139831_139833);

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5455__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5455__auto__)){
var child = temp__5455__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__139834 = ps;
var G__139835 = (i + (1));
el__$1 = G__139834;
i = G__139835;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
var G__139836 = shadow.dom.dom_node(el);
return goog.dom.getParentElement(G__139836);
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,((function (parent){
return (function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
});})(parent))
,null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
var G__139837 = shadow.dom.dom_node(el);
return goog.dom.getNextElementSibling(G__139837);
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
var G__139838 = shadow.dom.dom_node(el);
return goog.dom.getPreviousElementSibling(G__139838);
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__139839 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139839,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139839,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139839,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__139842_139852 = cljs.core.seq(props);
var chunk__139843_139853 = null;
var count__139844_139854 = (0);
var i__139845_139855 = (0);
while(true){
if((i__139845_139855 < count__139844_139854)){
var vec__139846_139856 = chunk__139843_139853.cljs$core$IIndexed$_nth$arity$2(null,i__139845_139855);
var k_139857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139846_139856,(0),null);
var v_139858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139846_139856,(1),null);
el.setAttributeNS((function (){var temp__5457__auto__ = cljs.core.namespace(k_139857);
if(cljs.core.truth_(temp__5457__auto__)){
var ns = temp__5457__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_139857),v_139858);


var G__139859 = seq__139842_139852;
var G__139860 = chunk__139843_139853;
var G__139861 = count__139844_139854;
var G__139862 = (i__139845_139855 + (1));
seq__139842_139852 = G__139859;
chunk__139843_139853 = G__139860;
count__139844_139854 = G__139861;
i__139845_139855 = G__139862;
continue;
} else {
var temp__5457__auto___139863 = cljs.core.seq(seq__139842_139852);
if(temp__5457__auto___139863){
var seq__139842_139864__$1 = temp__5457__auto___139863;
if(cljs.core.chunked_seq_QMARK_(seq__139842_139864__$1)){
var c__4351__auto___139865 = cljs.core.chunk_first(seq__139842_139864__$1);
var G__139866 = cljs.core.chunk_rest(seq__139842_139864__$1);
var G__139867 = c__4351__auto___139865;
var G__139868 = cljs.core.count(c__4351__auto___139865);
var G__139869 = (0);
seq__139842_139852 = G__139866;
chunk__139843_139853 = G__139867;
count__139844_139854 = G__139868;
i__139845_139855 = G__139869;
continue;
} else {
var vec__139849_139870 = cljs.core.first(seq__139842_139864__$1);
var k_139871 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139849_139870,(0),null);
var v_139872 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139849_139870,(1),null);
el.setAttributeNS((function (){var temp__5457__auto____$1 = cljs.core.namespace(k_139871);
if(cljs.core.truth_(temp__5457__auto____$1)){
var ns = temp__5457__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_139871),v_139872);


var G__139873 = cljs.core.next(seq__139842_139864__$1);
var G__139874 = null;
var G__139875 = (0);
var G__139876 = (0);
seq__139842_139852 = G__139873;
chunk__139843_139853 = G__139874;
count__139844_139854 = G__139875;
i__139845_139855 = G__139876;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__139878 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139878,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__139878,(1),null);
var seq__139881_139899 = cljs.core.seq(node_children);
var chunk__139883_139900 = null;
var count__139884_139901 = (0);
var i__139885_139902 = (0);
while(true){
if((i__139885_139902 < count__139884_139901)){
var child_struct_139903 = chunk__139883_139900.cljs$core$IIndexed$_nth$arity$2(null,i__139885_139902);
if(!((child_struct_139903 == null))){
if(typeof child_struct_139903 === 'string'){
var text_139904 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_139904),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_139903)].join(''));
} else {
var children_139905 = shadow.dom.svg_node(child_struct_139903);
if(cljs.core.seq_QMARK_(children_139905)){
var seq__139887_139906 = cljs.core.seq(children_139905);
var chunk__139889_139907 = null;
var count__139890_139908 = (0);
var i__139891_139909 = (0);
while(true){
if((i__139891_139909 < count__139890_139908)){
var child_139910 = chunk__139889_139907.cljs$core$IIndexed$_nth$arity$2(null,i__139891_139909);
if(cljs.core.truth_(child_139910)){
node.appendChild(child_139910);


var G__139911 = seq__139887_139906;
var G__139912 = chunk__139889_139907;
var G__139913 = count__139890_139908;
var G__139914 = (i__139891_139909 + (1));
seq__139887_139906 = G__139911;
chunk__139889_139907 = G__139912;
count__139890_139908 = G__139913;
i__139891_139909 = G__139914;
continue;
} else {
var G__139915 = seq__139887_139906;
var G__139916 = chunk__139889_139907;
var G__139917 = count__139890_139908;
var G__139918 = (i__139891_139909 + (1));
seq__139887_139906 = G__139915;
chunk__139889_139907 = G__139916;
count__139890_139908 = G__139917;
i__139891_139909 = G__139918;
continue;
}
} else {
var temp__5457__auto___139919 = cljs.core.seq(seq__139887_139906);
if(temp__5457__auto___139919){
var seq__139887_139920__$1 = temp__5457__auto___139919;
if(cljs.core.chunked_seq_QMARK_(seq__139887_139920__$1)){
var c__4351__auto___139921 = cljs.core.chunk_first(seq__139887_139920__$1);
var G__139922 = cljs.core.chunk_rest(seq__139887_139920__$1);
var G__139923 = c__4351__auto___139921;
var G__139924 = cljs.core.count(c__4351__auto___139921);
var G__139925 = (0);
seq__139887_139906 = G__139922;
chunk__139889_139907 = G__139923;
count__139890_139908 = G__139924;
i__139891_139909 = G__139925;
continue;
} else {
var child_139926 = cljs.core.first(seq__139887_139920__$1);
if(cljs.core.truth_(child_139926)){
node.appendChild(child_139926);


var G__139927 = cljs.core.next(seq__139887_139920__$1);
var G__139928 = null;
var G__139929 = (0);
var G__139930 = (0);
seq__139887_139906 = G__139927;
chunk__139889_139907 = G__139928;
count__139890_139908 = G__139929;
i__139891_139909 = G__139930;
continue;
} else {
var G__139931 = cljs.core.next(seq__139887_139920__$1);
var G__139932 = null;
var G__139933 = (0);
var G__139934 = (0);
seq__139887_139906 = G__139931;
chunk__139889_139907 = G__139932;
count__139890_139908 = G__139933;
i__139891_139909 = G__139934;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_139905);
}
}


var G__139935 = seq__139881_139899;
var G__139936 = chunk__139883_139900;
var G__139937 = count__139884_139901;
var G__139938 = (i__139885_139902 + (1));
seq__139881_139899 = G__139935;
chunk__139883_139900 = G__139936;
count__139884_139901 = G__139937;
i__139885_139902 = G__139938;
continue;
} else {
var G__139939 = seq__139881_139899;
var G__139940 = chunk__139883_139900;
var G__139941 = count__139884_139901;
var G__139942 = (i__139885_139902 + (1));
seq__139881_139899 = G__139939;
chunk__139883_139900 = G__139940;
count__139884_139901 = G__139941;
i__139885_139902 = G__139942;
continue;
}
} else {
var temp__5457__auto___139943 = cljs.core.seq(seq__139881_139899);
if(temp__5457__auto___139943){
var seq__139881_139944__$1 = temp__5457__auto___139943;
if(cljs.core.chunked_seq_QMARK_(seq__139881_139944__$1)){
var c__4351__auto___139945 = cljs.core.chunk_first(seq__139881_139944__$1);
var G__139946 = cljs.core.chunk_rest(seq__139881_139944__$1);
var G__139947 = c__4351__auto___139945;
var G__139948 = cljs.core.count(c__4351__auto___139945);
var G__139949 = (0);
seq__139881_139899 = G__139946;
chunk__139883_139900 = G__139947;
count__139884_139901 = G__139948;
i__139885_139902 = G__139949;
continue;
} else {
var child_struct_139950 = cljs.core.first(seq__139881_139944__$1);
if(!((child_struct_139950 == null))){
if(typeof child_struct_139950 === 'string'){
var text_139951 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_139951),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_139950)].join(''));
} else {
var children_139952 = shadow.dom.svg_node(child_struct_139950);
if(cljs.core.seq_QMARK_(children_139952)){
var seq__139893_139953 = cljs.core.seq(children_139952);
var chunk__139895_139954 = null;
var count__139896_139955 = (0);
var i__139897_139956 = (0);
while(true){
if((i__139897_139956 < count__139896_139955)){
var child_139957 = chunk__139895_139954.cljs$core$IIndexed$_nth$arity$2(null,i__139897_139956);
if(cljs.core.truth_(child_139957)){
node.appendChild(child_139957);


var G__139958 = seq__139893_139953;
var G__139959 = chunk__139895_139954;
var G__139960 = count__139896_139955;
var G__139961 = (i__139897_139956 + (1));
seq__139893_139953 = G__139958;
chunk__139895_139954 = G__139959;
count__139896_139955 = G__139960;
i__139897_139956 = G__139961;
continue;
} else {
var G__139962 = seq__139893_139953;
var G__139963 = chunk__139895_139954;
var G__139964 = count__139896_139955;
var G__139965 = (i__139897_139956 + (1));
seq__139893_139953 = G__139962;
chunk__139895_139954 = G__139963;
count__139896_139955 = G__139964;
i__139897_139956 = G__139965;
continue;
}
} else {
var temp__5457__auto___139966__$1 = cljs.core.seq(seq__139893_139953);
if(temp__5457__auto___139966__$1){
var seq__139893_139967__$1 = temp__5457__auto___139966__$1;
if(cljs.core.chunked_seq_QMARK_(seq__139893_139967__$1)){
var c__4351__auto___139968 = cljs.core.chunk_first(seq__139893_139967__$1);
var G__139969 = cljs.core.chunk_rest(seq__139893_139967__$1);
var G__139970 = c__4351__auto___139968;
var G__139971 = cljs.core.count(c__4351__auto___139968);
var G__139972 = (0);
seq__139893_139953 = G__139969;
chunk__139895_139954 = G__139970;
count__139896_139955 = G__139971;
i__139897_139956 = G__139972;
continue;
} else {
var child_139973 = cljs.core.first(seq__139893_139967__$1);
if(cljs.core.truth_(child_139973)){
node.appendChild(child_139973);


var G__139974 = cljs.core.next(seq__139893_139967__$1);
var G__139975 = null;
var G__139976 = (0);
var G__139977 = (0);
seq__139893_139953 = G__139974;
chunk__139895_139954 = G__139975;
count__139896_139955 = G__139976;
i__139897_139956 = G__139977;
continue;
} else {
var G__139978 = cljs.core.next(seq__139893_139967__$1);
var G__139979 = null;
var G__139980 = (0);
var G__139981 = (0);
seq__139893_139953 = G__139978;
chunk__139895_139954 = G__139979;
count__139896_139955 = G__139980;
i__139897_139956 = G__139981;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_139952);
}
}


var G__139982 = cljs.core.next(seq__139881_139944__$1);
var G__139983 = null;
var G__139984 = (0);
var G__139985 = (0);
seq__139881_139899 = G__139982;
chunk__139883_139900 = G__139983;
count__139884_139901 = G__139984;
i__139885_139902 = G__139985;
continue;
} else {
var G__139986 = cljs.core.next(seq__139881_139944__$1);
var G__139987 = null;
var G__139988 = (0);
var G__139989 = (0);
seq__139881_139899 = G__139986;
chunk__139883_139900 = G__139987;
count__139884_139901 = G__139988;
i__139885_139902 = G__139989;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

var G__139990_139996 = shadow.dom._to_svg;
var G__139991_139997 = "string";
var G__139992_139998 = ((function (G__139990_139996,G__139991_139997){
return (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
});})(G__139990_139996,G__139991_139997))
;
goog.object.set(G__139990_139996,G__139991_139997,G__139992_139998);

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
});

goog.object.set(shadow.dom.SVGElement,"null",true);

var G__139993_139999 = shadow.dom._to_svg;
var G__139994_140000 = "null";
var G__139995_140001 = ((function (G__139993_139999,G__139994_140000){
return (function (_){
return null;
});})(G__139993_139999,G__139994_140000))
;
goog.object.set(G__139993_139999,G__139994_140000,G__139995_140001);
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4534__auto__ = [];
var len__4531__auto___140004 = arguments.length;
var i__4532__auto___140005 = (0);
while(true){
if((i__4532__auto___140005 < len__4531__auto___140004)){
args__4534__auto__.push((arguments[i__4532__auto___140005]));

var G__140006 = (i__4532__auto___140005 + (1));
i__4532__auto___140005 = G__140006;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
});

shadow.dom.svg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.dom.svg.cljs$lang$applyTo = (function (seq140002){
var G__140003 = cljs.core.first(seq140002);
var seq140002__$1 = cljs.core.next(seq140002);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__140003,seq140002__$1);
});

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__140008 = arguments.length;
switch (G__140008) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = ((function (buf,chan){
return (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});})(buf,chan))
;
var G__140009_140024 = shadow.dom.dom_node(el);
var G__140010_140025 = cljs.core.name(event);
var G__140011_140026 = event_fn;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__140009_140024,G__140010_140025,G__140011_140026) : shadow.dom.dom_listen.call(null,G__140009_140024,G__140010_140025,G__140011_140026));

if(cljs.core.truth_((function (){var and__3938__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__3938__auto__)){
return !(once_or_cleanup === true);
} else {
return and__3938__auto__;
}
})())){
var c__33263__auto___140027 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__33263__auto___140027,buf,chan,event_fn){
return (function (){
var f__33264__auto__ = (function (){var switch__33031__auto__ = ((function (c__33263__auto___140027,buf,chan,event_fn){
return (function (state_140016){
var state_val_140017 = (state_140016[(1)]);
if((state_val_140017 === (1))){
var state_140016__$1 = state_140016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_140016__$1,(2),once_or_cleanup);
} else {
if((state_val_140017 === (2))){
var inst_140013 = (state_140016[(2)]);
var inst_140014 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_140016__$1 = (function (){var statearr_140018 = state_140016;
(statearr_140018[(7)] = inst_140013);

return statearr_140018;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_140016__$1,inst_140014);
} else {
return null;
}
}
});})(c__33263__auto___140027,buf,chan,event_fn))
;
return ((function (switch__33031__auto__,c__33263__auto___140027,buf,chan,event_fn){
return (function() {
var shadow$dom$state_machine__33032__auto__ = null;
var shadow$dom$state_machine__33032__auto____0 = (function (){
var statearr_140019 = [null,null,null,null,null,null,null,null];
(statearr_140019[(0)] = shadow$dom$state_machine__33032__auto__);

(statearr_140019[(1)] = (1));

return statearr_140019;
});
var shadow$dom$state_machine__33032__auto____1 = (function (state_140016){
while(true){
var ret_value__33033__auto__ = (function (){try{while(true){
var result__33034__auto__ = switch__33031__auto__(state_140016);
if(cljs.core.keyword_identical_QMARK_(result__33034__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33034__auto__;
}
break;
}
}catch (e140020){if((e140020 instanceof Object)){
var ex__33035__auto__ = e140020;
var statearr_140021_140028 = state_140016;
(statearr_140021_140028[(5)] = ex__33035__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_140016);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e140020;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__33033__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__140029 = state_140016;
state_140016 = G__140029;
continue;
} else {
return ret_value__33033__auto__;
}
break;
}
});
shadow$dom$state_machine__33032__auto__ = function(state_140016){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__33032__auto____0.call(this);
case 1:
return shadow$dom$state_machine__33032__auto____1.call(this,state_140016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__33032__auto____0;
shadow$dom$state_machine__33032__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__33032__auto____1;
return shadow$dom$state_machine__33032__auto__;
})()
;})(switch__33031__auto__,c__33263__auto___140027,buf,chan,event_fn))
})();
var state__33265__auto__ = (function (){var statearr_140022 = (f__33264__auto__.cljs$core$IFn$_invoke$arity$0 ? f__33264__auto__.cljs$core$IFn$_invoke$arity$0() : f__33264__auto__.call(null));
(statearr_140022[(6)] = c__33263__auto___140027);

return statearr_140022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__33265__auto__);
});})(c__33263__auto___140027,buf,chan,event_fn))
);

} else {
}

return chan;
});

shadow.dom.event_chan.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=shadow.dom.js.map
