goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$IElement$_to_dom$arity$1 == null))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto__.call(null,this$));
} else {
var m__4244__auto____$1 = (shadow.dom._to_dom["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto__.call(null,this$));
} else {
var m__4244__auto____$1 = (shadow.dom._to_svg["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__59623 = coll;
var G__59624 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__59623,G__59624) : shadow.dom.lazy_native_coll_seq.call(null,G__59623,G__59624));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__3949__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return not_found;
}
});

shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
});

shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
});

shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
});

shadow.dom.NativeColl.cljs$lang$type = true;

shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl";

shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"shadow.dom/NativeColl");
});

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode([cljs.core.str.cljs$core$IFn$_invoke$arity$1(el)].join(''));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__59631 = arguments.length;
switch (G__59631) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
});

shadow.dom.query_one.cljs$lang$maxFixedArity = 2;

shadow.dom.query = (function shadow$dom$query(var_args){
var G__59634 = arguments.length;
switch (G__59634) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
});

shadow.dom.query.cljs$lang$maxFixedArity = 2;

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__59642 = arguments.length;
switch (G__59642) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
});

shadow.dom.by_id.cljs$lang$maxFixedArity = 2;

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__59647 = arguments.length;
switch (G__59647) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
e.cancelBubble = true;

e.returnValue = false;
}

return e;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4;

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__59650 = arguments.length;
switch (G__59650) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__59651 = document;
var G__59652 = shadow.dom.dom_node(el);
return goog.dom.contains(G__59651,G__59652);
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
var G__59653 = shadow.dom.dom_node(parent);
var G__59654 = shadow.dom.dom_node(el);
return goog.dom.contains(G__59653,G__59654);
});

shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2;

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
var G__59656 = shadow.dom.dom_node(el);
var G__59657 = cls;
return goog.dom.classlist.add(G__59656,G__59657);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
var G__59658 = shadow.dom.dom_node(el);
var G__59659 = cls;
return goog.dom.classlist.remove(G__59658,G__59659);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__59661 = arguments.length;
switch (G__59661) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
var G__59662 = shadow.dom.dom_node(el);
var G__59663 = cls;
return goog.dom.classlist.toggle(G__59662,G__59663);
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
});

shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3;

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__3949__auto__ = !((typeof document !== 'undefined'));
if(or__3949__auto__){
return or__3949__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e59665){if((e59665 instanceof Object)){
var e = e59665;
return console.log("didnt support attachEvent",el,e);
} else {
throw e59665;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__3949__auto__ = !((typeof document !== 'undefined'));
if(or__3949__auto__){
return or__3949__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__59666 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__59667 = null;
var count__59668 = (0);
var i__59669 = (0);
while(true){
if((i__59669 < count__59668)){
var el = chunk__59667.cljs$core$IIndexed$_nth$arity$2(null,i__59669);
var handler_59676__$1 = ((function (seq__59666,chunk__59667,count__59668,i__59669,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__59666,chunk__59667,count__59668,i__59669,el))
;
var G__59670_59677 = el;
var G__59671_59678 = cljs.core.name(ev);
var G__59672_59679 = handler_59676__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__59670_59677,G__59671_59678,G__59672_59679) : shadow.dom.dom_listen.call(null,G__59670_59677,G__59671_59678,G__59672_59679));


var G__59680 = seq__59666;
var G__59681 = chunk__59667;
var G__59682 = count__59668;
var G__59683 = (i__59669 + (1));
seq__59666 = G__59680;
chunk__59667 = G__59681;
count__59668 = G__59682;
i__59669 = G__59683;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__59666);
if(temp__5457__auto__){
var seq__59666__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__59666__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__59666__$1);
var G__59684 = cljs.core.chunk_rest(seq__59666__$1);
var G__59685 = c__4351__auto__;
var G__59686 = cljs.core.count(c__4351__auto__);
var G__59687 = (0);
seq__59666 = G__59684;
chunk__59667 = G__59685;
count__59668 = G__59686;
i__59669 = G__59687;
continue;
} else {
var el = cljs.core.first(seq__59666__$1);
var handler_59688__$1 = ((function (seq__59666,chunk__59667,count__59668,i__59669,el,seq__59666__$1,temp__5457__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__59666,chunk__59667,count__59668,i__59669,el,seq__59666__$1,temp__5457__auto__))
;
var G__59673_59689 = el;
var G__59674_59690 = cljs.core.name(ev);
var G__59675_59691 = handler_59688__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__59673_59689,G__59674_59690,G__59675_59691) : shadow.dom.dom_listen.call(null,G__59673_59689,G__59674_59690,G__59675_59691));


var G__59692 = cljs.core.next(seq__59666__$1);
var G__59693 = null;
var G__59694 = (0);
var G__59695 = (0);
seq__59666 = G__59692;
chunk__59667 = G__59693;
count__59668 = G__59694;
i__59669 = G__59695;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__59697 = arguments.length;
switch (G__59697) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
var G__59698 = shadow.dom.dom_node(el);
var G__59699 = cljs.core.name(ev);
var G__59700 = handler__$1;
return (shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__59698,G__59699,G__59700) : shadow.dom.dom_listen.call(null,G__59698,G__59699,G__59700));
}
});

shadow.dom.on.cljs$lang$maxFixedArity = 4;

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
var G__59702 = shadow.dom.dom_node(el);
var G__59703 = cljs.core.name(ev);
var G__59704 = handler;
return (shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3(G__59702,G__59703,G__59704) : shadow.dom.dom_listen_remove.call(null,G__59702,G__59703,G__59704));
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__59705 = cljs.core.seq(events);
var chunk__59706 = null;
var count__59707 = (0);
var i__59708 = (0);
while(true){
if((i__59708 < count__59707)){
var vec__59709 = chunk__59706.cljs$core$IIndexed$_nth$arity$2(null,i__59708);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59709,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59709,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__59715 = seq__59705;
var G__59716 = chunk__59706;
var G__59717 = count__59707;
var G__59718 = (i__59708 + (1));
seq__59705 = G__59715;
chunk__59706 = G__59716;
count__59707 = G__59717;
i__59708 = G__59718;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__59705);
if(temp__5457__auto__){
var seq__59705__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__59705__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__59705__$1);
var G__59719 = cljs.core.chunk_rest(seq__59705__$1);
var G__59720 = c__4351__auto__;
var G__59721 = cljs.core.count(c__4351__auto__);
var G__59722 = (0);
seq__59705 = G__59719;
chunk__59706 = G__59720;
count__59707 = G__59721;
i__59708 = G__59722;
continue;
} else {
var vec__59712 = cljs.core.first(seq__59705__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59712,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59712,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__59723 = cljs.core.next(seq__59705__$1);
var G__59724 = null;
var G__59725 = (0);
var G__59726 = (0);
seq__59705 = G__59723;
chunk__59706 = G__59724;
count__59707 = G__59725;
i__59708 = G__59726;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__59727 = cljs.core.seq(styles);
var chunk__59728 = null;
var count__59729 = (0);
var i__59730 = (0);
while(true){
if((i__59730 < count__59729)){
var vec__59731 = chunk__59728.cljs$core$IIndexed$_nth$arity$2(null,i__59730);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59731,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59731,(1),null);
var G__59734_59743 = dom;
var G__59735_59744 = cljs.core.name(k);
var G__59736_59745 = (((v == null))?"":v);
goog.style.setStyle(G__59734_59743,G__59735_59744,G__59736_59745);


var G__59746 = seq__59727;
var G__59747 = chunk__59728;
var G__59748 = count__59729;
var G__59749 = (i__59730 + (1));
seq__59727 = G__59746;
chunk__59728 = G__59747;
count__59729 = G__59748;
i__59730 = G__59749;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__59727);
if(temp__5457__auto__){
var seq__59727__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__59727__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__59727__$1);
var G__59750 = cljs.core.chunk_rest(seq__59727__$1);
var G__59751 = c__4351__auto__;
var G__59752 = cljs.core.count(c__4351__auto__);
var G__59753 = (0);
seq__59727 = G__59750;
chunk__59728 = G__59751;
count__59729 = G__59752;
i__59730 = G__59753;
continue;
} else {
var vec__59737 = cljs.core.first(seq__59727__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59737,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59737,(1),null);
var G__59740_59754 = dom;
var G__59741_59755 = cljs.core.name(k);
var G__59742_59756 = (((v == null))?"":v);
goog.style.setStyle(G__59740_59754,G__59741_59755,G__59742_59756);


var G__59757 = cljs.core.next(seq__59727__$1);
var G__59758 = null;
var G__59759 = (0);
var G__59760 = (0);
seq__59727 = G__59757;
chunk__59728 = G__59758;
count__59729 = G__59759;
i__59730 = G__59760;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__59761_59762 = key;
var G__59761_59763__$1 = (((G__59761_59762 instanceof cljs.core.Keyword))?G__59761_59762.fqn:null);
switch (G__59761_59763__$1) {
case "id":
el.id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "class":
el.className = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "for":
el.htmlFor = value;

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_59765 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__3949__auto__ = goog.string.startsWith(ks_59765,"data-");
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return goog.string.startsWith(ks_59765,"aria-");
}
})())){
el.setAttribute(ks_59765,value);
} else {
(el[ks_59765] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
var G__59766 = shadow.dom.dom_node(el);
var G__59767 = cls;
return goog.dom.classlist.contains(G__59766,G__59767);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec__$1)].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__59768){
var map__59769 = p__59768;
var map__59769__$1 = ((((!((map__59769 == null)))?(((((map__59769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__59769.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__59769):map__59769);
var props = map__59769__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59769__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__59771 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59771,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59771,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59771,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__59774 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__59774,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__59774;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__59776 = arguments.length;
switch (G__59776) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$lang$maxFixedArity = 2;

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__59778){
var vec__59779 = p__59778;
var seq__59780 = cljs.core.seq(vec__59779);
var first__59781 = cljs.core.first(seq__59780);
var seq__59780__$1 = cljs.core.next(seq__59780);
var nn = first__59781;
var first__59781__$1 = cljs.core.first(seq__59780__$1);
var seq__59780__$2 = cljs.core.next(seq__59780__$1);
var np = first__59781__$1;
var nc = seq__59780__$2;
var node = vec__59779;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__59782 = nn;
var G__59783 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__59782,G__59783) : create_fn.call(null,G__59782,G__59783));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__59784 = nn;
var G__59785 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__59784,G__59785) : create_fn.call(null,G__59784,G__59785));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__59786 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59786,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59786,(1),null);
var seq__59789_59805 = cljs.core.seq(node_children);
var chunk__59790_59806 = null;
var count__59791_59807 = (0);
var i__59792_59808 = (0);
while(true){
if((i__59792_59808 < count__59791_59807)){
var child_struct_59809 = chunk__59790_59806.cljs$core$IIndexed$_nth$arity$2(null,i__59792_59808);
var children_59810 = shadow.dom.dom_node(child_struct_59809);
if(cljs.core.seq_QMARK_(children_59810)){
var seq__59793_59811 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_59810));
var chunk__59795_59812 = null;
var count__59796_59813 = (0);
var i__59797_59814 = (0);
while(true){
if((i__59797_59814 < count__59796_59813)){
var child_59815 = chunk__59795_59812.cljs$core$IIndexed$_nth$arity$2(null,i__59797_59814);
if(cljs.core.truth_(child_59815)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_59815);


var G__59816 = seq__59793_59811;
var G__59817 = chunk__59795_59812;
var G__59818 = count__59796_59813;
var G__59819 = (i__59797_59814 + (1));
seq__59793_59811 = G__59816;
chunk__59795_59812 = G__59817;
count__59796_59813 = G__59818;
i__59797_59814 = G__59819;
continue;
} else {
var G__59820 = seq__59793_59811;
var G__59821 = chunk__59795_59812;
var G__59822 = count__59796_59813;
var G__59823 = (i__59797_59814 + (1));
seq__59793_59811 = G__59820;
chunk__59795_59812 = G__59821;
count__59796_59813 = G__59822;
i__59797_59814 = G__59823;
continue;
}
} else {
var temp__5457__auto___59824 = cljs.core.seq(seq__59793_59811);
if(temp__5457__auto___59824){
var seq__59793_59825__$1 = temp__5457__auto___59824;
if(cljs.core.chunked_seq_QMARK_(seq__59793_59825__$1)){
var c__4351__auto___59826 = cljs.core.chunk_first(seq__59793_59825__$1);
var G__59827 = cljs.core.chunk_rest(seq__59793_59825__$1);
var G__59828 = c__4351__auto___59826;
var G__59829 = cljs.core.count(c__4351__auto___59826);
var G__59830 = (0);
seq__59793_59811 = G__59827;
chunk__59795_59812 = G__59828;
count__59796_59813 = G__59829;
i__59797_59814 = G__59830;
continue;
} else {
var child_59831 = cljs.core.first(seq__59793_59825__$1);
if(cljs.core.truth_(child_59831)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_59831);


var G__59832 = cljs.core.next(seq__59793_59825__$1);
var G__59833 = null;
var G__59834 = (0);
var G__59835 = (0);
seq__59793_59811 = G__59832;
chunk__59795_59812 = G__59833;
count__59796_59813 = G__59834;
i__59797_59814 = G__59835;
continue;
} else {
var G__59836 = cljs.core.next(seq__59793_59825__$1);
var G__59837 = null;
var G__59838 = (0);
var G__59839 = (0);
seq__59793_59811 = G__59836;
chunk__59795_59812 = G__59837;
count__59796_59813 = G__59838;
i__59797_59814 = G__59839;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_59810);
}


var G__59840 = seq__59789_59805;
var G__59841 = chunk__59790_59806;
var G__59842 = count__59791_59807;
var G__59843 = (i__59792_59808 + (1));
seq__59789_59805 = G__59840;
chunk__59790_59806 = G__59841;
count__59791_59807 = G__59842;
i__59792_59808 = G__59843;
continue;
} else {
var temp__5457__auto___59844 = cljs.core.seq(seq__59789_59805);
if(temp__5457__auto___59844){
var seq__59789_59845__$1 = temp__5457__auto___59844;
if(cljs.core.chunked_seq_QMARK_(seq__59789_59845__$1)){
var c__4351__auto___59846 = cljs.core.chunk_first(seq__59789_59845__$1);
var G__59847 = cljs.core.chunk_rest(seq__59789_59845__$1);
var G__59848 = c__4351__auto___59846;
var G__59849 = cljs.core.count(c__4351__auto___59846);
var G__59850 = (0);
seq__59789_59805 = G__59847;
chunk__59790_59806 = G__59848;
count__59791_59807 = G__59849;
i__59792_59808 = G__59850;
continue;
} else {
var child_struct_59851 = cljs.core.first(seq__59789_59845__$1);
var children_59852 = shadow.dom.dom_node(child_struct_59851);
if(cljs.core.seq_QMARK_(children_59852)){
var seq__59799_59853 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_59852));
var chunk__59801_59854 = null;
var count__59802_59855 = (0);
var i__59803_59856 = (0);
while(true){
if((i__59803_59856 < count__59802_59855)){
var child_59857 = chunk__59801_59854.cljs$core$IIndexed$_nth$arity$2(null,i__59803_59856);
if(cljs.core.truth_(child_59857)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_59857);


var G__59858 = seq__59799_59853;
var G__59859 = chunk__59801_59854;
var G__59860 = count__59802_59855;
var G__59861 = (i__59803_59856 + (1));
seq__59799_59853 = G__59858;
chunk__59801_59854 = G__59859;
count__59802_59855 = G__59860;
i__59803_59856 = G__59861;
continue;
} else {
var G__59862 = seq__59799_59853;
var G__59863 = chunk__59801_59854;
var G__59864 = count__59802_59855;
var G__59865 = (i__59803_59856 + (1));
seq__59799_59853 = G__59862;
chunk__59801_59854 = G__59863;
count__59802_59855 = G__59864;
i__59803_59856 = G__59865;
continue;
}
} else {
var temp__5457__auto___59866__$1 = cljs.core.seq(seq__59799_59853);
if(temp__5457__auto___59866__$1){
var seq__59799_59867__$1 = temp__5457__auto___59866__$1;
if(cljs.core.chunked_seq_QMARK_(seq__59799_59867__$1)){
var c__4351__auto___59868 = cljs.core.chunk_first(seq__59799_59867__$1);
var G__59869 = cljs.core.chunk_rest(seq__59799_59867__$1);
var G__59870 = c__4351__auto___59868;
var G__59871 = cljs.core.count(c__4351__auto___59868);
var G__59872 = (0);
seq__59799_59853 = G__59869;
chunk__59801_59854 = G__59870;
count__59802_59855 = G__59871;
i__59803_59856 = G__59872;
continue;
} else {
var child_59873 = cljs.core.first(seq__59799_59867__$1);
if(cljs.core.truth_(child_59873)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_59873);


var G__59874 = cljs.core.next(seq__59799_59867__$1);
var G__59875 = null;
var G__59876 = (0);
var G__59877 = (0);
seq__59799_59853 = G__59874;
chunk__59801_59854 = G__59875;
count__59802_59855 = G__59876;
i__59803_59856 = G__59877;
continue;
} else {
var G__59878 = cljs.core.next(seq__59799_59867__$1);
var G__59879 = null;
var G__59880 = (0);
var G__59881 = (0);
seq__59799_59853 = G__59878;
chunk__59801_59854 = G__59879;
count__59802_59855 = G__59880;
i__59803_59856 = G__59881;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_59852);
}


var G__59882 = cljs.core.next(seq__59789_59845__$1);
var G__59883 = null;
var G__59884 = (0);
var G__59885 = (0);
seq__59789_59805 = G__59882;
chunk__59790_59806 = G__59883;
count__59791_59807 = G__59884;
i__59792_59808 = G__59885;
continue;
}
} else {
}
}
break;
}

return node;
});
cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
});

cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
});
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
var G__59886 = shadow.dom.dom_node(node);
return goog.dom.removeChildren(G__59886);
});
shadow.dom.remove = (function shadow$dom$remove(node){
if(((!((node == null)))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__59888 = cljs.core.seq(node);
var chunk__59889 = null;
var count__59890 = (0);
var i__59891 = (0);
while(true){
if((i__59891 < count__59890)){
var n = chunk__59889.cljs$core$IIndexed$_nth$arity$2(null,i__59891);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__59892 = seq__59888;
var G__59893 = chunk__59889;
var G__59894 = count__59890;
var G__59895 = (i__59891 + (1));
seq__59888 = G__59892;
chunk__59889 = G__59893;
count__59890 = G__59894;
i__59891 = G__59895;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__59888);
if(temp__5457__auto__){
var seq__59888__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__59888__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__59888__$1);
var G__59896 = cljs.core.chunk_rest(seq__59888__$1);
var G__59897 = c__4351__auto__;
var G__59898 = cljs.core.count(c__4351__auto__);
var G__59899 = (0);
seq__59888 = G__59896;
chunk__59889 = G__59897;
count__59890 = G__59898;
i__59891 = G__59899;
continue;
} else {
var n = cljs.core.first(seq__59888__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__59900 = cljs.core.next(seq__59888__$1);
var G__59901 = null;
var G__59902 = (0);
var G__59903 = (0);
seq__59888 = G__59900;
chunk__59889 = G__59901;
count__59890 = G__59902;
i__59891 = G__59903;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
var G__59904 = shadow.dom.dom_node(new$);
var G__59905 = shadow.dom.dom_node(old);
return goog.dom.replaceNode(G__59904,G__59905);
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__59907 = arguments.length;
switch (G__59907) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return shadow.dom.dom_node(el).innerText = new_text;
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
});

shadow.dom.text.cljs$lang$maxFixedArity = 2;

shadow.dom.check = (function shadow$dom$check(var_args){
var G__59910 = arguments.length;
switch (G__59910) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return shadow.dom.dom_node(el).checked = checked;
});

shadow.dom.check.cljs$lang$maxFixedArity = 2;

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__59913 = arguments.length;
switch (G__59913) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__3949__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return default$;
}
});

shadow.dom.attr.cljs$lang$maxFixedArity = 3;

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return shadow.dom.dom_node(node).innerHTML = text;
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4534__auto__ = [];
var len__4531__auto___59920 = arguments.length;
var i__4532__auto___59921 = (0);
while(true){
if((i__4532__auto___59921 < len__4531__auto___59920)){
args__4534__auto__.push((arguments[i__4532__auto___59921]));

var G__59922 = (i__4532__auto___59921 + (1));
i__4532__auto___59921 = G__59922;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__59916_59923 = cljs.core.seq(nodes);
var chunk__59917_59924 = null;
var count__59918_59925 = (0);
var i__59919_59926 = (0);
while(true){
if((i__59919_59926 < count__59918_59925)){
var node_59927 = chunk__59917_59924.cljs$core$IIndexed$_nth$arity$2(null,i__59919_59926);
fragment.appendChild(shadow.dom._to_dom(node_59927));


var G__59928 = seq__59916_59923;
var G__59929 = chunk__59917_59924;
var G__59930 = count__59918_59925;
var G__59931 = (i__59919_59926 + (1));
seq__59916_59923 = G__59928;
chunk__59917_59924 = G__59929;
count__59918_59925 = G__59930;
i__59919_59926 = G__59931;
continue;
} else {
var temp__5457__auto___59932 = cljs.core.seq(seq__59916_59923);
if(temp__5457__auto___59932){
var seq__59916_59933__$1 = temp__5457__auto___59932;
if(cljs.core.chunked_seq_QMARK_(seq__59916_59933__$1)){
var c__4351__auto___59934 = cljs.core.chunk_first(seq__59916_59933__$1);
var G__59935 = cljs.core.chunk_rest(seq__59916_59933__$1);
var G__59936 = c__4351__auto___59934;
var G__59937 = cljs.core.count(c__4351__auto___59934);
var G__59938 = (0);
seq__59916_59923 = G__59935;
chunk__59917_59924 = G__59936;
count__59918_59925 = G__59937;
i__59919_59926 = G__59938;
continue;
} else {
var node_59939 = cljs.core.first(seq__59916_59933__$1);
fragment.appendChild(shadow.dom._to_dom(node_59939));


var G__59940 = cljs.core.next(seq__59916_59933__$1);
var G__59941 = null;
var G__59942 = (0);
var G__59943 = (0);
seq__59916_59923 = G__59940;
chunk__59917_59924 = G__59941;
count__59918_59925 = G__59942;
i__59919_59926 = G__59943;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
});

shadow.dom.fragment.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.dom.fragment.cljs$lang$applyTo = (function (seq59915){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq59915));
});

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__59944_59958 = cljs.core.seq(scripts);
var chunk__59945_59959 = null;
var count__59946_59960 = (0);
var i__59947_59961 = (0);
while(true){
if((i__59947_59961 < count__59946_59960)){
var vec__59948_59962 = chunk__59945_59959.cljs$core$IIndexed$_nth$arity$2(null,i__59947_59961);
var script_tag_59963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59948_59962,(0),null);
var script_body_59964 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59948_59962,(1),null);
eval(script_body_59964);


var G__59965 = seq__59944_59958;
var G__59966 = chunk__59945_59959;
var G__59967 = count__59946_59960;
var G__59968 = (i__59947_59961 + (1));
seq__59944_59958 = G__59965;
chunk__59945_59959 = G__59966;
count__59946_59960 = G__59967;
i__59947_59961 = G__59968;
continue;
} else {
var temp__5457__auto___59969 = cljs.core.seq(seq__59944_59958);
if(temp__5457__auto___59969){
var seq__59944_59970__$1 = temp__5457__auto___59969;
if(cljs.core.chunked_seq_QMARK_(seq__59944_59970__$1)){
var c__4351__auto___59971 = cljs.core.chunk_first(seq__59944_59970__$1);
var G__59972 = cljs.core.chunk_rest(seq__59944_59970__$1);
var G__59973 = c__4351__auto___59971;
var G__59974 = cljs.core.count(c__4351__auto___59971);
var G__59975 = (0);
seq__59944_59958 = G__59972;
chunk__59945_59959 = G__59973;
count__59946_59960 = G__59974;
i__59947_59961 = G__59975;
continue;
} else {
var vec__59951_59976 = cljs.core.first(seq__59944_59970__$1);
var script_tag_59977 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59951_59976,(0),null);
var script_body_59978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59951_59976,(1),null);
eval(script_body_59978);


var G__59979 = cljs.core.next(seq__59944_59970__$1);
var G__59980 = null;
var G__59981 = (0);
var G__59982 = (0);
seq__59944_59958 = G__59979;
chunk__59945_59959 = G__59980;
count__59946_59960 = G__59981;
i__59947_59961 = G__59982;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (scripts){
return (function (s__$1,p__59954){
var vec__59955 = p__59954;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59955,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59955,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
});})(scripts))
,s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
el.innerHTML = s;

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
var G__59983 = shadow.dom.dom_node(el);
var G__59984 = cls;
return goog.dom.getAncestorByClass(G__59983,G__59984);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__59986 = arguments.length;
switch (G__59986) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
var G__59987 = shadow.dom.dom_node(el);
var G__59988 = cljs.core.name(tag);
return goog.dom.getAncestorByTagNameAndClass(G__59987,G__59988);
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
var G__59989 = shadow.dom.dom_node(el);
var G__59990 = cljs.core.name(tag);
var G__59991 = cljs.core.name(cls);
return goog.dom.getAncestorByTagNameAndClass(G__59989,G__59990,G__59991);
});

shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3;

shadow.dom.get_value = (function shadow$dom$get_value(dom){
var G__59993 = shadow.dom.dom_node(dom);
return goog.dom.forms.getValue(G__59993);
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
var G__59994 = shadow.dom.dom_node(dom);
var G__59995 = value;
return goog.dom.forms.setValue(G__59994,G__59995);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__59996 = cljs.core.seq(style_keys);
var chunk__59997 = null;
var count__59998 = (0);
var i__59999 = (0);
while(true){
if((i__59999 < count__59998)){
var it = chunk__59997.cljs$core$IIndexed$_nth$arity$2(null,i__59999);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__60000 = seq__59996;
var G__60001 = chunk__59997;
var G__60002 = count__59998;
var G__60003 = (i__59999 + (1));
seq__59996 = G__60000;
chunk__59997 = G__60001;
count__59998 = G__60002;
i__59999 = G__60003;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__59996);
if(temp__5457__auto__){
var seq__59996__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__59996__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__59996__$1);
var G__60004 = cljs.core.chunk_rest(seq__59996__$1);
var G__60005 = c__4351__auto__;
var G__60006 = cljs.core.count(c__4351__auto__);
var G__60007 = (0);
seq__59996 = G__60004;
chunk__59997 = G__60005;
count__59998 = G__60006;
i__59999 = G__60007;
continue;
} else {
var it = cljs.core.first(seq__59996__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__60008 = cljs.core.next(seq__59996__$1);
var G__60009 = null;
var G__60010 = (0);
var G__60011 = (0);
seq__59996 = G__60008;
chunk__59997 = G__60009;
count__59998 = G__60010;
i__59999 = G__60011;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k60013,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__60017 = k60013;
var G__60017__$1 = (((G__60017 instanceof cljs.core.Keyword))?G__60017.fqn:null);
switch (G__60017__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k60013,else__4206__auto__);

}
});

shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer(writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4218__auto__,pr_pair__4220__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4219__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__60012){
var self__ = this;
var G__60012__$1 = this;
return (new cljs.core.RecordIter((0),G__60012__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = (function (){var fexpr__60018 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
;
return fexpr__60018(this__4199__auto____$1);
})();
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this60014,other60015){
var self__ = this;
var this60014__$1 = this;
return ((!((other60015 == null))) && ((this60014__$1.constructor === other60015.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this60014__$1.x,other60015.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this60014__$1.y,other60015.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this60014__$1.__extmap,other60015.__extmap)));
});

shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4213__auto__)),null));
}
});

shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__60012){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__60019 = cljs.core.keyword_identical_QMARK_;
var expr__60020 = k__4211__auto__;
if(cljs.core.truth_((function (){var G__60022 = new cljs.core.Keyword(null,"x","x",2099068185);
var G__60023 = expr__60020;
return (pred__60019.cljs$core$IFn$_invoke$arity$2 ? pred__60019.cljs$core$IFn$_invoke$arity$2(G__60022,G__60023) : pred__60019.call(null,G__60022,G__60023));
})())){
return (new shadow.dom.Coordinate(G__60012,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__60024 = new cljs.core.Keyword(null,"y","y",-1757859776);
var G__60025 = expr__60020;
return (pred__60019.cljs$core$IFn$_invoke$arity$2 ? pred__60019.cljs$core$IFn$_invoke$arity$2(G__60024,G__60025) : pred__60019.call(null,G__60024,G__60025));
})())){
return (new shadow.dom.Coordinate(self__.x,G__60012,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4211__auto__,G__60012),null));
}
}
});

shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__60012){
var self__ = this;
var this__4202__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__60012,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
});

shadow.dom.Coordinate.cljs$lang$type = true;

shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
});

shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write(writer__4241__auto__,"shadow.dom/Coordinate");
});

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__60016){
var extmap__4236__auto__ = (function (){var G__60026 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__60016,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__60016)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__60026);
} else {
return G__60026;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__60016),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__60016),null,cljs.core.not_empty(extmap__4236__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = (function (){var G__60028 = shadow.dom.dom_node(el);
return goog.style.getPosition(G__60028);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = (function (){var G__60029 = shadow.dom.dom_node(el);
return goog.style.getClientPosition(G__60029);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = (function (){var G__60030 = shadow.dom.dom_node(el);
return goog.style.getPageOffset(G__60030);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k60032,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__60036 = k60032;
var G__60036__$1 = (((G__60036 instanceof cljs.core.Keyword))?G__60036.fqn:null);
switch (G__60036__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k60032,else__4206__auto__);

}
});

shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer(writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4218__auto__,pr_pair__4220__auto__,"#shadow.dom.Size{",", ","}",opts__4219__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__60031){
var self__ = this;
var G__60031__$1 = this;
return (new cljs.core.RecordIter((0),G__60031__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = (function (){var fexpr__60037 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
;
return fexpr__60037(this__4199__auto____$1);
})();
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this60033,other60034){
var self__ = this;
var this60033__$1 = this;
return ((!((other60034 == null))) && ((this60033__$1.constructor === other60034.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this60033__$1.w,other60034.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this60033__$1.h,other60034.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this60033__$1.__extmap,other60034.__extmap)));
});

shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4213__auto__)),null));
}
});

shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__60031){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__60038 = cljs.core.keyword_identical_QMARK_;
var expr__60039 = k__4211__auto__;
if(cljs.core.truth_((function (){var G__60041 = new cljs.core.Keyword(null,"w","w",354169001);
var G__60042 = expr__60039;
return (pred__60038.cljs$core$IFn$_invoke$arity$2 ? pred__60038.cljs$core$IFn$_invoke$arity$2(G__60041,G__60042) : pred__60038.call(null,G__60041,G__60042));
})())){
return (new shadow.dom.Size(G__60031,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__60043 = new cljs.core.Keyword(null,"h","h",1109658740);
var G__60044 = expr__60039;
return (pred__60038.cljs$core$IFn$_invoke$arity$2 ? pred__60038.cljs$core$IFn$_invoke$arity$2(G__60043,G__60044) : pred__60038.call(null,G__60043,G__60044));
})())){
return (new shadow.dom.Size(self__.w,G__60031,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4211__auto__,G__60031),null));
}
}
});

shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__60031){
var self__ = this;
var this__4202__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__60031,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
});

shadow.dom.Size.cljs$lang$type = true;

shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
});

shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write(writer__4241__auto__,"shadow.dom/Size");
});

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__60035){
var extmap__4236__auto__ = (function (){var G__60045 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__60035,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__60035)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__60045);
} else {
return G__60045;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__60035),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__60035),null,cljs.core.not_empty(extmap__4236__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj((function (){var G__60047 = shadow.dom.dom_node(el);
return goog.style.getSize(G__60047);
})());
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(shadow.dom.get_size(el));
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4405__auto__ = opts;
var l__4406__auto__ = a__4405__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4406__auto__)){
var G__60048 = (i + (1));
var G__60049 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__60048;
ret = G__60049;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__60050){
var vec__60051 = p__60050;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60051,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60051,(1),null);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(k)),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent([cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
}),query_params)))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__60055 = arguments.length;
switch (G__60055) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
});

shadow.dom.redirect.cljs$lang$maxFixedArity = 2;

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return document.location.href = document.location.href;
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__60057_60059 = new_node;
var G__60058_60060 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingAfter(G__60057_60059,G__60058_60060);

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__60061_60063 = new_node;
var G__60062_60064 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingBefore(G__60061_60063,G__60062_60064);

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5455__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5455__auto__)){
var child = temp__5455__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__60065 = ps;
var G__60066 = (i + (1));
el__$1 = G__60065;
i = G__60066;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
var G__60067 = shadow.dom.dom_node(el);
return goog.dom.getParentElement(G__60067);
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,((function (parent){
return (function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
});})(parent))
,null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
var G__60068 = shadow.dom.dom_node(el);
return goog.dom.getNextElementSibling(G__60068);
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
var G__60069 = shadow.dom.dom_node(el);
return goog.dom.getPreviousElementSibling(G__60069);
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__60070 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60070,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60070,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60070,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__60073_60083 = cljs.core.seq(props);
var chunk__60074_60084 = null;
var count__60075_60085 = (0);
var i__60076_60086 = (0);
while(true){
if((i__60076_60086 < count__60075_60085)){
var vec__60077_60087 = chunk__60074_60084.cljs$core$IIndexed$_nth$arity$2(null,i__60076_60086);
var k_60088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60077_60087,(0),null);
var v_60089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60077_60087,(1),null);
el.setAttributeNS((function (){var temp__5457__auto__ = cljs.core.namespace(k_60088);
if(cljs.core.truth_(temp__5457__auto__)){
var ns = temp__5457__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_60088),v_60089);


var G__60090 = seq__60073_60083;
var G__60091 = chunk__60074_60084;
var G__60092 = count__60075_60085;
var G__60093 = (i__60076_60086 + (1));
seq__60073_60083 = G__60090;
chunk__60074_60084 = G__60091;
count__60075_60085 = G__60092;
i__60076_60086 = G__60093;
continue;
} else {
var temp__5457__auto___60094 = cljs.core.seq(seq__60073_60083);
if(temp__5457__auto___60094){
var seq__60073_60095__$1 = temp__5457__auto___60094;
if(cljs.core.chunked_seq_QMARK_(seq__60073_60095__$1)){
var c__4351__auto___60096 = cljs.core.chunk_first(seq__60073_60095__$1);
var G__60097 = cljs.core.chunk_rest(seq__60073_60095__$1);
var G__60098 = c__4351__auto___60096;
var G__60099 = cljs.core.count(c__4351__auto___60096);
var G__60100 = (0);
seq__60073_60083 = G__60097;
chunk__60074_60084 = G__60098;
count__60075_60085 = G__60099;
i__60076_60086 = G__60100;
continue;
} else {
var vec__60080_60101 = cljs.core.first(seq__60073_60095__$1);
var k_60102 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60080_60101,(0),null);
var v_60103 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60080_60101,(1),null);
el.setAttributeNS((function (){var temp__5457__auto____$1 = cljs.core.namespace(k_60102);
if(cljs.core.truth_(temp__5457__auto____$1)){
var ns = temp__5457__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_60102),v_60103);


var G__60104 = cljs.core.next(seq__60073_60095__$1);
var G__60105 = null;
var G__60106 = (0);
var G__60107 = (0);
seq__60073_60083 = G__60104;
chunk__60074_60084 = G__60105;
count__60075_60085 = G__60106;
i__60076_60086 = G__60107;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__60109 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60109,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60109,(1),null);
var seq__60112_60130 = cljs.core.seq(node_children);
var chunk__60114_60131 = null;
var count__60115_60132 = (0);
var i__60116_60133 = (0);
while(true){
if((i__60116_60133 < count__60115_60132)){
var child_struct_60134 = chunk__60114_60131.cljs$core$IIndexed$_nth$arity$2(null,i__60116_60133);
if(!((child_struct_60134 == null))){
if(typeof child_struct_60134 === 'string'){
var text_60135 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_60135),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_60134)].join(''));
} else {
var children_60136 = shadow.dom.svg_node(child_struct_60134);
if(cljs.core.seq_QMARK_(children_60136)){
var seq__60118_60137 = cljs.core.seq(children_60136);
var chunk__60120_60138 = null;
var count__60121_60139 = (0);
var i__60122_60140 = (0);
while(true){
if((i__60122_60140 < count__60121_60139)){
var child_60141 = chunk__60120_60138.cljs$core$IIndexed$_nth$arity$2(null,i__60122_60140);
if(cljs.core.truth_(child_60141)){
node.appendChild(child_60141);


var G__60142 = seq__60118_60137;
var G__60143 = chunk__60120_60138;
var G__60144 = count__60121_60139;
var G__60145 = (i__60122_60140 + (1));
seq__60118_60137 = G__60142;
chunk__60120_60138 = G__60143;
count__60121_60139 = G__60144;
i__60122_60140 = G__60145;
continue;
} else {
var G__60146 = seq__60118_60137;
var G__60147 = chunk__60120_60138;
var G__60148 = count__60121_60139;
var G__60149 = (i__60122_60140 + (1));
seq__60118_60137 = G__60146;
chunk__60120_60138 = G__60147;
count__60121_60139 = G__60148;
i__60122_60140 = G__60149;
continue;
}
} else {
var temp__5457__auto___60150 = cljs.core.seq(seq__60118_60137);
if(temp__5457__auto___60150){
var seq__60118_60151__$1 = temp__5457__auto___60150;
if(cljs.core.chunked_seq_QMARK_(seq__60118_60151__$1)){
var c__4351__auto___60152 = cljs.core.chunk_first(seq__60118_60151__$1);
var G__60153 = cljs.core.chunk_rest(seq__60118_60151__$1);
var G__60154 = c__4351__auto___60152;
var G__60155 = cljs.core.count(c__4351__auto___60152);
var G__60156 = (0);
seq__60118_60137 = G__60153;
chunk__60120_60138 = G__60154;
count__60121_60139 = G__60155;
i__60122_60140 = G__60156;
continue;
} else {
var child_60157 = cljs.core.first(seq__60118_60151__$1);
if(cljs.core.truth_(child_60157)){
node.appendChild(child_60157);


var G__60158 = cljs.core.next(seq__60118_60151__$1);
var G__60159 = null;
var G__60160 = (0);
var G__60161 = (0);
seq__60118_60137 = G__60158;
chunk__60120_60138 = G__60159;
count__60121_60139 = G__60160;
i__60122_60140 = G__60161;
continue;
} else {
var G__60162 = cljs.core.next(seq__60118_60151__$1);
var G__60163 = null;
var G__60164 = (0);
var G__60165 = (0);
seq__60118_60137 = G__60162;
chunk__60120_60138 = G__60163;
count__60121_60139 = G__60164;
i__60122_60140 = G__60165;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_60136);
}
}


var G__60166 = seq__60112_60130;
var G__60167 = chunk__60114_60131;
var G__60168 = count__60115_60132;
var G__60169 = (i__60116_60133 + (1));
seq__60112_60130 = G__60166;
chunk__60114_60131 = G__60167;
count__60115_60132 = G__60168;
i__60116_60133 = G__60169;
continue;
} else {
var G__60170 = seq__60112_60130;
var G__60171 = chunk__60114_60131;
var G__60172 = count__60115_60132;
var G__60173 = (i__60116_60133 + (1));
seq__60112_60130 = G__60170;
chunk__60114_60131 = G__60171;
count__60115_60132 = G__60172;
i__60116_60133 = G__60173;
continue;
}
} else {
var temp__5457__auto___60174 = cljs.core.seq(seq__60112_60130);
if(temp__5457__auto___60174){
var seq__60112_60175__$1 = temp__5457__auto___60174;
if(cljs.core.chunked_seq_QMARK_(seq__60112_60175__$1)){
var c__4351__auto___60176 = cljs.core.chunk_first(seq__60112_60175__$1);
var G__60177 = cljs.core.chunk_rest(seq__60112_60175__$1);
var G__60178 = c__4351__auto___60176;
var G__60179 = cljs.core.count(c__4351__auto___60176);
var G__60180 = (0);
seq__60112_60130 = G__60177;
chunk__60114_60131 = G__60178;
count__60115_60132 = G__60179;
i__60116_60133 = G__60180;
continue;
} else {
var child_struct_60181 = cljs.core.first(seq__60112_60175__$1);
if(!((child_struct_60181 == null))){
if(typeof child_struct_60181 === 'string'){
var text_60182 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_60182),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_60181)].join(''));
} else {
var children_60183 = shadow.dom.svg_node(child_struct_60181);
if(cljs.core.seq_QMARK_(children_60183)){
var seq__60124_60184 = cljs.core.seq(children_60183);
var chunk__60126_60185 = null;
var count__60127_60186 = (0);
var i__60128_60187 = (0);
while(true){
if((i__60128_60187 < count__60127_60186)){
var child_60188 = chunk__60126_60185.cljs$core$IIndexed$_nth$arity$2(null,i__60128_60187);
if(cljs.core.truth_(child_60188)){
node.appendChild(child_60188);


var G__60189 = seq__60124_60184;
var G__60190 = chunk__60126_60185;
var G__60191 = count__60127_60186;
var G__60192 = (i__60128_60187 + (1));
seq__60124_60184 = G__60189;
chunk__60126_60185 = G__60190;
count__60127_60186 = G__60191;
i__60128_60187 = G__60192;
continue;
} else {
var G__60193 = seq__60124_60184;
var G__60194 = chunk__60126_60185;
var G__60195 = count__60127_60186;
var G__60196 = (i__60128_60187 + (1));
seq__60124_60184 = G__60193;
chunk__60126_60185 = G__60194;
count__60127_60186 = G__60195;
i__60128_60187 = G__60196;
continue;
}
} else {
var temp__5457__auto___60197__$1 = cljs.core.seq(seq__60124_60184);
if(temp__5457__auto___60197__$1){
var seq__60124_60198__$1 = temp__5457__auto___60197__$1;
if(cljs.core.chunked_seq_QMARK_(seq__60124_60198__$1)){
var c__4351__auto___60199 = cljs.core.chunk_first(seq__60124_60198__$1);
var G__60200 = cljs.core.chunk_rest(seq__60124_60198__$1);
var G__60201 = c__4351__auto___60199;
var G__60202 = cljs.core.count(c__4351__auto___60199);
var G__60203 = (0);
seq__60124_60184 = G__60200;
chunk__60126_60185 = G__60201;
count__60127_60186 = G__60202;
i__60128_60187 = G__60203;
continue;
} else {
var child_60204 = cljs.core.first(seq__60124_60198__$1);
if(cljs.core.truth_(child_60204)){
node.appendChild(child_60204);


var G__60205 = cljs.core.next(seq__60124_60198__$1);
var G__60206 = null;
var G__60207 = (0);
var G__60208 = (0);
seq__60124_60184 = G__60205;
chunk__60126_60185 = G__60206;
count__60127_60186 = G__60207;
i__60128_60187 = G__60208;
continue;
} else {
var G__60209 = cljs.core.next(seq__60124_60198__$1);
var G__60210 = null;
var G__60211 = (0);
var G__60212 = (0);
seq__60124_60184 = G__60209;
chunk__60126_60185 = G__60210;
count__60127_60186 = G__60211;
i__60128_60187 = G__60212;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_60183);
}
}


var G__60213 = cljs.core.next(seq__60112_60175__$1);
var G__60214 = null;
var G__60215 = (0);
var G__60216 = (0);
seq__60112_60130 = G__60213;
chunk__60114_60131 = G__60214;
count__60115_60132 = G__60215;
i__60116_60133 = G__60216;
continue;
} else {
var G__60217 = cljs.core.next(seq__60112_60175__$1);
var G__60218 = null;
var G__60219 = (0);
var G__60220 = (0);
seq__60112_60130 = G__60217;
chunk__60114_60131 = G__60218;
count__60115_60132 = G__60219;
i__60116_60133 = G__60220;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

var G__60221_60227 = shadow.dom._to_svg;
var G__60222_60228 = "string";
var G__60223_60229 = ((function (G__60221_60227,G__60222_60228){
return (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
});})(G__60221_60227,G__60222_60228))
;
goog.object.set(G__60221_60227,G__60222_60228,G__60223_60229);

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
});

goog.object.set(shadow.dom.SVGElement,"null",true);

var G__60224_60230 = shadow.dom._to_svg;
var G__60225_60231 = "null";
var G__60226_60232 = ((function (G__60224_60230,G__60225_60231){
return (function (_){
return null;
});})(G__60224_60230,G__60225_60231))
;
goog.object.set(G__60224_60230,G__60225_60231,G__60226_60232);
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4534__auto__ = [];
var len__4531__auto___60235 = arguments.length;
var i__4532__auto___60236 = (0);
while(true){
if((i__4532__auto___60236 < len__4531__auto___60235)){
args__4534__auto__.push((arguments[i__4532__auto___60236]));

var G__60237 = (i__4532__auto___60236 + (1));
i__4532__auto___60236 = G__60237;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
});

shadow.dom.svg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.dom.svg.cljs$lang$applyTo = (function (seq60233){
var G__60234 = cljs.core.first(seq60233);
var seq60233__$1 = cljs.core.next(seq60233);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60234,seq60233__$1);
});

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__60239 = arguments.length;
switch (G__60239) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = ((function (buf,chan){
return (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});})(buf,chan))
;
var G__60240_60255 = shadow.dom.dom_node(el);
var G__60241_60256 = cljs.core.name(event);
var G__60242_60257 = event_fn;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__60240_60255,G__60241_60256,G__60242_60257) : shadow.dom.dom_listen.call(null,G__60240_60255,G__60241_60256,G__60242_60257));

if(cljs.core.truth_((function (){var and__3938__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__3938__auto__)){
return !(once_or_cleanup === true);
} else {
return and__3938__auto__;
}
})())){
var c__32222__auto___60258 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___60258,buf,chan,event_fn){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___60258,buf,chan,event_fn){
return (function (state_60247){
var state_val_60248 = (state_60247[(1)]);
if((state_val_60248 === (1))){
var state_60247__$1 = state_60247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60247__$1,(2),once_or_cleanup);
} else {
if((state_val_60248 === (2))){
var inst_60244 = (state_60247[(2)]);
var inst_60245 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_60247__$1 = (function (){var statearr_60249 = state_60247;
(statearr_60249[(7)] = inst_60244);

return statearr_60249;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_60247__$1,inst_60245);
} else {
return null;
}
}
});})(c__32222__auto___60258,buf,chan,event_fn))
;
return ((function (switch__31990__auto__,c__32222__auto___60258,buf,chan,event_fn){
return (function() {
var shadow$dom$state_machine__31991__auto__ = null;
var shadow$dom$state_machine__31991__auto____0 = (function (){
var statearr_60250 = [null,null,null,null,null,null,null,null];
(statearr_60250[(0)] = shadow$dom$state_machine__31991__auto__);

(statearr_60250[(1)] = (1));

return statearr_60250;
});
var shadow$dom$state_machine__31991__auto____1 = (function (state_60247){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_60247);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e60251){if((e60251 instanceof Object)){
var ex__31994__auto__ = e60251;
var statearr_60252_60259 = state_60247;
(statearr_60252_60259[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_60247);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60251;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60260 = state_60247;
state_60247 = G__60260;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
shadow$dom$state_machine__31991__auto__ = function(state_60247){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__31991__auto____0.call(this);
case 1:
return shadow$dom$state_machine__31991__auto____1.call(this,state_60247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__31991__auto____0;
shadow$dom$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__31991__auto____1;
return shadow$dom$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___60258,buf,chan,event_fn))
})();
var state__32224__auto__ = (function (){var statearr_60253 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_60253[(6)] = c__32222__auto___60258);

return statearr_60253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___60258,buf,chan,event_fn))
);

} else {
}

return chan;
});

shadow.dom.event_chan.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=shadow.dom.js.map
