goog.provide('shadow.cljs.build_report.ui');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('shadow.api');
goog.require('shadow.dom');
goog.require('goog.format');
goog.require('shadow.markup.react');
var module$node_modules$react_dom$index=shadow.js.require("module$node_modules$react_dom$index", {});
var module$node_modules$react_table$lib$index=shadow.js.require("module$node_modules$react_table$lib$index", {});
goog.require('goog.string.format');
goog.require('goog.string');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.build_report !== 'undefined') && (typeof shadow.cljs.build_report.ui !== 'undefined') && (typeof shadow.cljs.build_report.ui.state_ref !== 'undefined')){
} else {
shadow.cljs.build_report.ui.state_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.build_report !== 'undefined') && (typeof shadow.cljs.build_report.ui !== 'undefined') && (typeof shadow.cljs.build_report.ui.root !== 'undefined')){
} else {
shadow.cljs.build_report.ui.root = shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1("root");
}
shadow.cljs.build_report.ui.filesize = (function shadow$cljs$build_report$ui$filesize(size){
return goog.format.numBytesToString(size,(2),true,true);
});
shadow.cljs.build_report.ui.main_table_container = shadow.markup.css.element_STAR_("div","shadow-cljs-build-report-ui--main-table-container",(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-width","max-width",-1939924051),(800)], null);
}));
shadow.cljs.build_report.ui.sub_table_container = shadow.markup.css.element_STAR_("div","shadow-cljs-build-report-ui--sub-table-container",(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(5),(70),(20),(40)], null)], null);
}));
shadow.cljs.build_report.ui.sub_table_header = shadow.markup.css.element_STAR_("div","shadow-cljs-build-report-ui--sub-table-header",(function (_){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1.3em",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold",new cljs.core.Keyword(null,"margin-bottom","margin-bottom",388334941),(10)], null);
}));
shadow.cljs.build_report.ui.rt_columns = cljs.core.clj__GT_js(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),"group-name",new cljs.core.Keyword(null,"Header","Header",1255420133),"Name",new cljs.core.Keyword(null,"Cell","Cell",53644787),(function (row_obj){
var map__60880 = row_obj.original;
var map__60880__$1 = ((((!((map__60880 == null)))?(((((map__60880.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60880.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60880):map__60880);
var row = map__60880__$1;
var group_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60880__$1,new cljs.core.Keyword(null,"group-id","group-id",-1316082778));
var group_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60880__$1,new cljs.core.Keyword(null,"group-name","group-name",-232140110));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"prj","prj",1120246589),group_id)){
return shadow.markup.react.impl.interop.create_element("b",[group_name]);
} else {
return group_name;
}
})], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"id","id",-1388402092),"optimized-size",new cljs.core.Keyword(null,"Header","Header",1255420133),"Optimized",new cljs.core.Keyword(null,"headerClassName","headerClassName",-143432465),"numeric",new cljs.core.Keyword(null,"className","className",-1983287057),"numeric",new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),(120),new cljs.core.Keyword(null,"Cell","Cell",53644787),(function (row_obj){
return shadow.cljs.build_report.ui.filesize(row_obj.value);
}),new cljs.core.Keyword(null,"accessor","accessor",-25476721),(function (p1__60878_SHARP_){
return new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725).cljs$core$IFn$_invoke$arity$1(p1__60878_SHARP_);
})], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"id","id",-1388402092),"group-ptc",new cljs.core.Keyword(null,"Header","Header",1255420133),"%",new cljs.core.Keyword(null,"headerClassName","headerClassName",-143432465),"numeric",new cljs.core.Keyword(null,"className","className",-1983287057),"numeric",new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),(70),new cljs.core.Keyword(null,"Cell","Cell",53644787),(function (row_obj){
var G__60882 = "%.1f %%";
var G__60883 = row_obj.value;
return goog.string.format(G__60882,G__60883);
}),new cljs.core.Keyword(null,"accessor","accessor",-25476721),(function (p1__60879_SHARP_){
return new cljs.core.Keyword(null,"group-pct","group-pct",-1926071629).cljs$core$IFn$_invoke$arity$1(p1__60879_SHARP_);
})], null)], null));
shadow.cljs.build_report.ui.rt_sub_columns = cljs.core.clj__GT_js(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),"resource-name",new cljs.core.Keyword(null,"Header","Header",1255420133),"Name",new cljs.core.Keyword(null,"accessor","accessor",-25476721),(function (p1__60884_SHARP_){
return new cljs.core.Keyword(null,"resource-name","resource-name",2001617100).cljs$core$IFn$_invoke$arity$1(p1__60884_SHARP_);
})], null),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"id","id",-1388402092),"optimized-size",new cljs.core.Keyword(null,"Header","Header",1255420133),"Optimized",new cljs.core.Keyword(null,"headerClassName","headerClassName",-143432465),"numeric",new cljs.core.Keyword(null,"className","className",-1983287057),"numeric",new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),(120),new cljs.core.Keyword(null,"Cell","Cell",53644787),(function (row_obj){
return shadow.cljs.build_report.ui.filesize(row_obj.value);
}),new cljs.core.Keyword(null,"accessor","accessor",-25476721),(function (p1__60885_SHARP_){
return new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725).cljs$core$IFn$_invoke$arity$1(p1__60885_SHARP_);
})], null)], null));
shadow.cljs.build_report.ui.overview = (function shadow$cljs$build_report$ui$overview(){
var sources_by_name = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),cljs.core.identity),new cljs.core.Keyword(null,"build-sources","build-sources",-1750353374).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(shadow.cljs.build_report.ui.state_ref))));
var map__60886 = cljs.core.deref(shadow.cljs.build_report.ui.state_ref);
var map__60886__$1 = ((((!((map__60886 == null)))?(((((map__60886.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60886.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60886):map__60886);
var build_sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60886__$1,new cljs.core.Keyword(null,"build-sources","build-sources",-1750353374));
var build_modules = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60886__$1,new cljs.core.Keyword(null,"build-modules","build-modules",-1146364107));
var display_modules = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (sources_by_name,map__60886,map__60886__$1,build_sources,build_modules){
return (function (p__60888){
var map__60889 = p__60888;
var map__60889__$1 = ((((!((map__60889 == null)))?(((((map__60889.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60889.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60889):map__60889);
var mod = map__60889__$1;
var source_bytes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60889__$1,new cljs.core.Keyword(null,"source-bytes","source-bytes",2043726942));
var total = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),cljs.core.vals(source_bytes));
var rows = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725),cljs.core._GT_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (total,map__60889,map__60889__$1,mod,source_bytes,sources_by_name,map__60886,map__60886__$1,build_sources,build_modules){
return (function (p__60891){
var vec__60892 = p__60891;
var group = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60892,(0),null);
var vec__60895 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60892,(1),null);
var item = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60895,(0),null);
var items = vec__60895;
var vec__60898 = group;
var group_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60898,(0),null);
var group_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60898,(1),null);
var group_size = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725),items));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(item,new cljs.core.Keyword(null,"group-id","group-id",-1316082778),group_id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"group-name","group-name",-232140110),group_name,new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725),group_size,new cljs.core.Keyword(null,"group-pct","group-pct",-1926071629),((100) * (group_size / total)),new cljs.core.Keyword(null,"item-count","item-count",8658772),cljs.core.count(items),new cljs.core.Keyword(null,"items","items",1031954938),items], 0));
});})(total,map__60889,map__60889__$1,mod,source_bytes,sources_by_name,map__60886,map__60886__$1,build_sources,build_modules))
,cljs.core.group_by(new cljs.core.Keyword(null,"group","group",582596132),cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725),cljs.core._GT_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (total,map__60889,map__60889__$1,mod,source_bytes,sources_by_name,map__60886,map__60886__$1,build_sources,build_modules){
return (function (p__60901){
var vec__60902 = p__60901;
var resource_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60902,(0),null);
var optimized_size = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60902,(1),null);
var map__60905 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(sources_by_name,resource_name);
var map__60905__$1 = ((((!((map__60905 == null)))?(((((map__60905.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60905.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60905):map__60905);
var src_info = map__60905__$1;
var npm_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60905__$1,new cljs.core.Keyword(null,"npm-info","npm-info",295306408));
var pom_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60905__$1,new cljs.core.Keyword(null,"pom-info","pom-info",-2111983790));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src_info,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name,new cljs.core.Keyword(null,"group","group",582596132),(function (){var or__3949__auto__ = (function (){var and__3938__auto__ = npm_info;
if(cljs.core.truth_(and__3938__auto__)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"npm","npm",785664792),new cljs.core.Keyword(null,"package-name","package-name",350612733).cljs$core$IFn$_invoke$arity$1(npm_info)], null);
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = (function (){var and__3938__auto__ = pom_info;
if(cljs.core.truth_(and__3938__auto__)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"jar","jar",-1059959581),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(pom_info))].join('')], null);
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"prj","prj",1120246589),"Project Files"], null);
}
}
})(),new cljs.core.Keyword(null,"optimized-size","optimized-size",-2020963725),optimized_size], null)], 0));
});})(total,map__60889,map__60889__$1,mod,source_bytes,sources_by_name,map__60886,map__60886__$1,build_sources,build_modules))
,source_bytes))))));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(mod,new cljs.core.Keyword(null,"rows","rows",850049680),rows);
});})(sources_by_name,map__60886,map__60886__$1,build_sources,build_modules))
,build_modules);
var sub_row = ((function (sources_by_name,map__60886,map__60886__$1,build_sources,build_modules,display_modules){
return (function shadow$cljs$build_report$ui$overview_$_sub_row(row){
var map__60907 = row.original;
var map__60907__$1 = ((((!((map__60907 == null)))?(((((map__60907.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60907.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60907):map__60907);
var row__$1 = map__60907__$1;
var npm_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60907__$1,new cljs.core.Keyword(null,"npm-info","npm-info",295306408));
var pom_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60907__$1,new cljs.core.Keyword(null,"pom-info","pom-info",-2111983790));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60907__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var item_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60907__$1,new cljs.core.Keyword(null,"item-count","item-count",8658772));
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60907__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var G__60909 = cljs.core.PersistentArrayMap.EMPTY;
var G__60910 = (cljs.core.truth_(pom_info)?(function (){var G__60913 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"coordinate","coordinate",-112811209).cljs$core$IFn$_invoke$arity$1(pom_info)], 0));
return (shadow.cljs.build_report.ui.sub_table_header.cljs$core$IFn$_invoke$arity$1 ? shadow.cljs.build_report.ui.sub_table_header.cljs$core$IFn$_invoke$arity$1(G__60913) : shadow.cljs.build_report.ui.sub_table_header.call(null,G__60913));
})():null);
var G__60911 = (cljs.core.truth_(npm_info)?(function (){var G__60914 = ["npm: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"package-name","package-name",350612733).cljs$core$IFn$_invoke$arity$1(npm_info)),"@",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(npm_info))].join('');
return (shadow.cljs.build_report.ui.sub_table_header.cljs$core$IFn$_invoke$arity$1 ? shadow.cljs.build_report.ui.sub_table_header.cljs$core$IFn$_invoke$arity$1(G__60914) : shadow.cljs.build_report.ui.sub_table_header.call(null,G__60914));
})():null);
var G__60912 = shadow.markup.react.$.cljs$core$IFn$_invoke$arity$variadic(module$node_modules$react_table$lib$index["default"],cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([({"data": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(items), "columns": shadow.cljs.build_report.ui.rt_sub_columns, "showPagination": false, "defaultPageSize": (250), "minRows": item_count, "className": "-sriped -highlight"})], 0));
return (shadow.cljs.build_report.ui.sub_table_container.cljs$core$IFn$_invoke$arity$4 ? shadow.cljs.build_report.ui.sub_table_container.cljs$core$IFn$_invoke$arity$4(G__60909,G__60910,G__60911,G__60912) : shadow.cljs.build_report.ui.sub_table_container.call(null,G__60909,G__60910,G__60911,G__60912));
});})(sources_by_name,map__60886,map__60886__$1,build_sources,build_modules,display_modules))
;
return shadow.markup.react.impl.interop.create_element("div",[(function (){var iter__4324__auto__ = ((function (sources_by_name,map__60886,map__60886__$1,build_sources,build_modules,display_modules,sub_row){
return (function shadow$cljs$build_report$ui$overview_$_iter__60915(s__60916){
return (new cljs.core.LazySeq(null,((function (sources_by_name,map__60886,map__60886__$1,build_sources,build_modules,display_modules,sub_row){
return (function (){
var s__60916__$1 = s__60916;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__60916__$1);
if(temp__5457__auto__){
var s__60916__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__60916__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__60916__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__60918 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__60917 = (0);
while(true){
if((i__60917 < size__4323__auto__)){
var map__60919 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__60917);
var map__60919__$1 = ((((!((map__60919 == null)))?(((((map__60919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60919.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60919):map__60919);
var mod = map__60919__$1;
var module_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60919__$1,new cljs.core.Keyword(null,"module-id","module-id",376972113));
var js_size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60919__$1,new cljs.core.Keyword(null,"js-size","js-size",-582454603));
var gzip_size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60919__$1,new cljs.core.Keyword(null,"gzip-size","gzip-size",1012129871));
var rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60919__$1,new cljs.core.Keyword(null,"rows","rows",850049680));
cljs.core.chunk_append(b__60918,(function (){var G__60921 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.name(module_id)], null);
var G__60922 = shadow.markup.react.impl.interop.create_element("h3",[["Module: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([module_id], 0)))," [JS: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.build_report.ui.filesize(js_size)),"] [GZIP: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.build_report.ui.filesize(gzip_size)),"]"].join('')]);
var G__60923 = shadow.markup.react.$.cljs$core$IFn$_invoke$arity$variadic(module$node_modules$react_table$lib$index["default"],cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([({"data": rows, "columns": shadow.cljs.build_report.ui.rt_columns, "showPagination": false, "defaultPageSize": (250), "minRows": cljs.core.count(rows), "expanderDefaults": ({"width": (40)}), "className": "-sriped -highlight", "SubComponent": sub_row})], 0));
return (shadow.cljs.build_report.ui.main_table_container.cljs$core$IFn$_invoke$arity$3 ? shadow.cljs.build_report.ui.main_table_container.cljs$core$IFn$_invoke$arity$3(G__60921,G__60922,G__60923) : shadow.cljs.build_report.ui.main_table_container.call(null,G__60921,G__60922,G__60923));
})());

var G__60929 = (i__60917 + (1));
i__60917 = G__60929;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__60918),shadow$cljs$build_report$ui$overview_$_iter__60915(cljs.core.chunk_rest(s__60916__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__60918),null);
}
} else {
var map__60924 = cljs.core.first(s__60916__$2);
var map__60924__$1 = ((((!((map__60924 == null)))?(((((map__60924.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60924.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60924):map__60924);
var mod = map__60924__$1;
var module_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60924__$1,new cljs.core.Keyword(null,"module-id","module-id",376972113));
var js_size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60924__$1,new cljs.core.Keyword(null,"js-size","js-size",-582454603));
var gzip_size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60924__$1,new cljs.core.Keyword(null,"gzip-size","gzip-size",1012129871));
var rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60924__$1,new cljs.core.Keyword(null,"rows","rows",850049680));
return cljs.core.cons((function (){var G__60926 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.name(module_id)], null);
var G__60927 = shadow.markup.react.impl.interop.create_element("h3",[["Module: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([module_id], 0)))," [JS: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.build_report.ui.filesize(js_size)),"] [GZIP: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.build_report.ui.filesize(gzip_size)),"]"].join('')]);
var G__60928 = shadow.markup.react.$.cljs$core$IFn$_invoke$arity$variadic(module$node_modules$react_table$lib$index["default"],cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([({"data": rows, "columns": shadow.cljs.build_report.ui.rt_columns, "showPagination": false, "defaultPageSize": (250), "minRows": cljs.core.count(rows), "expanderDefaults": ({"width": (40)}), "className": "-sriped -highlight", "SubComponent": sub_row})], 0));
return (shadow.cljs.build_report.ui.main_table_container.cljs$core$IFn$_invoke$arity$3 ? shadow.cljs.build_report.ui.main_table_container.cljs$core$IFn$_invoke$arity$3(G__60926,G__60927,G__60928) : shadow.cljs.build_report.ui.main_table_container.call(null,G__60926,G__60927,G__60928));
})(),shadow$cljs$build_report$ui$overview_$_iter__60915(cljs.core.rest(s__60916__$2)));
}
} else {
return null;
}
break;
}
});})(sources_by_name,map__60886,map__60886__$1,build_sources,build_modules,display_modules,sub_row))
,null,null));
});})(sources_by_name,map__60886,map__60886__$1,build_sources,build_modules,display_modules,sub_row))
;
return iter__4324__auto__(display_modules);
})()]);
});
shadow.cljs.build_report.ui.start = (function shadow$cljs$build_report$ui$start(){
console.log("start");

var G__60930 = shadow.cljs.build_report.ui.overview();
var G__60931 = shadow.cljs.build_report.ui.root;
return module$node_modules$react_dom$index.render(G__60930,G__60931);
});
shadow.cljs.build_report.ui.stop = (function shadow$cljs$build_report$ui$stop(){
module$node_modules$react_dom$index.unmountComponentAtNode(shadow.cljs.build_report.ui.root);

return console.log("stop");
});
shadow.cljs.build_report.ui.init = (function shadow$cljs$build_report$ui$init(bundle_data){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(shadow.cljs.build_report.ui.state_ref,cljs.core.merge,bundle_data);

return shadow.cljs.build_report.ui.start();
});
goog.exportSymbol('shadow.cljs.build_report.ui.init', shadow.cljs.build_report.ui.init);
var G__60932_60934 = "shadow.cljs.build-report.ui";
var G__60933_60935 = cljs.core.PersistentArrayMap.EMPTY;
shadow.api.ns_ready_STAR_(G__60932_60934,G__60933_60935);

//# sourceMappingURL=shadow.cljs.build_report.ui.js.map
