/*
 * Decompiled with CFR 0.152.
 */
package com.idvision.androididcardlib;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import java.nio.ByteBuffer;

public class iCardUsbReader
implements Runnable {
    private static final String TAG = "AndroidIdCardLib";
    public static final byte CCID_ICC_PRESENT_ACTIVE = 0;
    public static final byte CCID_ICC_PRESENT_INACTIVE = 1;
    public static final byte CCID_ICC_ABSENT = 2;
    public static final byte CCID_ICC_STATUS_MASK = 3;
    private UsbManager mUsbManager;
    private UsbDevice mDevice;
    private UsbDeviceConnection mConnection;
    private UsbEndpoint mEndpointIntr;
    private UsbEndpoint mEndpointIn;
    private UsbEndpoint mEndpointOut;
    private int lastError;

    private void setDevice(UsbDevice device) {
        if (device == null) {
            this.mConnection = null;
            return;
        }
        switch (device.getDeviceClass()) {
            default: 
        }
        this.mDevice = device;
        if (device != null) {
            UsbDeviceConnection connection = this.mUsbManager.openDevice(device);
            if (connection != null) {
                Log.d((String)TAG, (String)"open SUCCESS");
                this.mConnection = connection;
                UsbInterface ui = device.getInterface(0);
                int j = 0;
                while (j < ui.getEndpointCount()) {
                    UsbEndpoint endPoint = ui.getEndpoint(j);
                    switch (endPoint.getType()) {
                        case 2: {
                            if (endPoint.getDirection() == 128) {
                                this.mEndpointIn = endPoint;
                                break;
                            }
                            this.mEndpointOut = endPoint;
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case 3: {
                            this.mEndpointIntr = endPoint;
                            connection.claimInterface(ui, true);
                            break;
                        }
                    }
                    ++j;
                }
            } else {
                Log.d((String)TAG, (String)"open FAIL");
                this.close();
            }
        }
    }

    private UsbInterface getUsbInterface(UsbEndpoint endPoinst) {
        int i = 0;
        while (i < this.mDevice.getInterfaceCount()) {
            UsbInterface usbInterface = this.mDevice.getInterface(i);
            int j = 0;
            while (j < usbInterface.getEndpointCount()) {
                if (usbInterface.getEndpoint(j) == endPoinst) {
                    return usbInterface;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receiveData(byte[] buffer) {
        if (this.mDevice != null && this.mEndpointIn != null && this.mConnection != null) {
            iCardUsbReader iCardUsbReader2 = this;
            synchronized (iCardUsbReader2) {
                int size;
                if (this.mConnection.claimInterface(this.getUsbInterface(this.mEndpointIn), true) && (size = this.mConnection.bulkTransfer(this.mEndpointIn, buffer, buffer.length, 500)) > 0) {
                    buffer.clone();
                    return size;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCmd(byte[] buffer) {
        if (this.mConnection != null && this.mEndpointOut != null) {
            iCardUsbReader iCardUsbReader2 = this;
            synchronized (iCardUsbReader2) {
                if (this.mConnection.claimInterface(this.getUsbInterface(this.mEndpointOut), true)) {
                    this.mConnection.bulkTransfer(this.mEndpointOut, buffer, buffer.length, 0);
                }
            }
        }
    }

    public boolean init(UsbManager manager, UsbDevice device) {
        this.mUsbManager = manager;
        this.setDevice(device);
        this.lastError = 0;
        return true;
    }

    public void close() {
        if (this.mConnection != null) {
            this.mConnection.close();
            this.mConnection = null;
        }
    }

    public int getLastError() {
        return this.lastError;
    }

    public boolean getReaderStatus() {
        return this.mConnection != null;
    }

    public boolean getCardStatus() {
        byte[] byArray = new byte[10];
        byArray[0] = 101;
        byte[] cmdGetSlot = byArray;
        byte[] buffer = new byte[this.mEndpointIn.getMaxPacketSize()];
        this.sendCmd(cmdGetSlot);
        this.receiveData(buffer);
        if ((buffer[7] & 3) == 0) {
            return true;
        }
        if ((buffer[7] & 3) == 1) {
            return true;
        }
        if ((buffer[7] & 3) == 2) {
            return false;
        }
        return false;
    }

    public int cardConnect(byte[] atr) {
        int reslen = 0;
        byte[] byArray = new byte[10];
        byArray[0] = 98;
        byte[] cmd = byArray;
        byte[] buffer = new byte[this.mEndpointIn.getMaxPacketSize()];
        this.sendCmd(cmd);
        this.receiveData(buffer);
        if (buffer[0] == -128) {
            reslen = buffer[1];
            int i = 0;
            while (i < reslen) {
                atr[i] = buffer[i + 10];
                ++i;
            }
        }
        return reslen;
    }

    public void cardDisconnect() {
        byte[] byArray = new byte[10];
        byArray[0] = 99;
        byte[] cmdGetSlot = byArray;
        byte[] buffer = new byte[this.mEndpointIn.getMaxPacketSize()];
        this.sendCmd(cmdGetSlot);
        this.receiveData(buffer);
    }

    public int exchangeAPDU(byte[] apdu, int length, byte[] response) {
        byte[] cmd = new byte[10 + length];
        cmd[0] = 111;
        cmd[1] = (byte)(length & 0xFF);
        cmd[2] = (byte)(length >>> 8 & 0xFF);
        cmd[3] = (byte)(length >>> 16 & 0xFF);
        cmd[4] = (byte)(length >>> 24 & 0xFF);
        cmd[5] = 0;
        cmd[6] = 0;
        cmd[7] = 0;
        cmd[8] = 0;
        cmd[9] = 0;
        System.arraycopy(apdu, 0, cmd, 10, length);
        this.sendCmd(cmd);
        int reslen = 0;
        byte[] buffer = new byte[512];
        this.receiveData(buffer);
        if (buffer[0] == -128) {
            reslen = buffer[1] & 0xFF;
            int i = 0;
            while (i < reslen) {
                response[i] = buffer[i + 10];
                ++i;
            }
        }
        return reslen;
    }

    public void run() {
        UsbRequest request = new UsbRequest();
        request.initialize(this.mConnection, this.mEndpointIntr);
        byte status = -1;
        ByteBuffer buffer = ByteBuffer.allocate(this.mEndpointIntr.getMaxPacketSize());
        while (true) {
            request.queue(buffer, this.mEndpointIntr.getMaxPacketSize());
            if (this.mConnection != null) {
                if (this.mConnection.requestWait() != request) continue;
                byte newStatus = buffer.get(1);
                request.getClientData();
                if (newStatus == status) continue;
                Log.d((String)TAG, (String)("got status " + newStatus));
                status = newStatus;
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

