/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget.listadapter;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import java.security.InvalidParameterException;
import java.util.List;

public class IntentBaseAdapter
extends BaseAdapter {
    Context mContext;
    Intent mIntent;
    PackageManager pm;
    List<ResolveInfo> IntentList;
    boolean[] mDisable;
    int iTemLayout;
    int ImageId;
    int TextId;
    private boolean showIcon = true;
    private boolean showLable = true;

    public IntentBaseAdapter(Context context, Intent intent, int itemLayout, int ImageId, int TextId) {
        this.mContext = context;
        this.mIntent = intent;
        this.pm = this.mContext.getPackageManager();
        this.IntentList = this.pm.queryIntentActivities(this.mIntent, 0);
        if (this.IntentList.size() == 0) {
            throw new InvalidParameterException("Not Found any Activity match with parameter Intent.");
        }
        this.mDisable = new boolean[this.IntentList.size()];
        this.iTemLayout = itemLayout;
        this.ImageId = ImageId;
        this.TextId = TextId;
    }

    public void setShowIcon(boolean icon) {
        this.showIcon = icon;
    }

    public void setShowIcon(boolean icon, int iconId) {
        this.showIcon = icon;
        this.ImageId = iconId;
    }

    public void setShowLable(boolean lable) {
        this.showLable = lable;
    }

    public void setShowLable(boolean lable, int lableId) {
        this.showLable = lable;
        this.TextId = lableId;
    }

    public void setIntent(Intent intent) {
        this.IntentList = this.pm.queryIntentActivities(this.mIntent, 0);
        if (this.IntentList.size() == 0) {
            throw new InvalidParameterException("Not Found any Activity match with parameter Intent.");
        }
    }

    public int getCount() {
        return this.IntentList.size();
    }

    public Object getItem(int position) {
        return this.IntentList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void setDisable(int position) {
        this.mDisable[position] = true;
        this.notifyDataSetChanged();
    }

    public void setDisable(int ... position) {
        for (int pos : position) {
            this.mDisable[pos] = true;
        }
        this.notifyDataSetChanged();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View view = convertView;
        if (view == null) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            view = inflater.inflate(this.iTemLayout, null);
            ViewHolder holder = new ViewHolder();
            holder.image = (ImageView)view.findViewById(this.ImageId);
            holder.title = (TextView)view.findViewById(this.TextId);
            view.setTag((Object)holder);
        }
        ViewHolder holder = (ViewHolder)view.getTag();
        ResolveInfo info = this.IntentList.get(position);
        if (this.showIcon) {
            holder.image.setImageDrawable(info.loadIcon(this.pm));
        }
        if (this.showLable) {
            holder.title.setText(info.loadLabel(this.pm));
        }
        if (this.mDisable[position]) {
            view.setVisibility(8);
        }
        return view;
    }

    public void close() {
        this.mContext = null;
        this.mIntent = null;
        this.pm = null;
        this.IntentList = null;
    }

    public AdapterView.OnItemClickListener getOnItemClickListener(OnItemClickListener listener) {
        DefaultOnItemClick click = new DefaultOnItemClick(this.mContext, this.IntentList);
        if (listener != null) {
            click.setListener(listener);
        }
        return click;
    }

    public AdapterView.OnItemClickListener getOnItemClickListener() {
        return this.getOnItemClickListener(null);
    }

    public static interface OnItemClickListener {
        public void onItemClick(AdapterView<?> var1, View var2, int var3, long var4, String var6, String var7);
    }

    private static class DefaultOnItemClick
    implements AdapterView.OnItemClickListener {
        Context mContext;
        List<ResolveInfo> mIntentList;
        OnItemClickListener mCustomListener;

        public DefaultOnItemClick(Context context, List<ResolveInfo> intentList) {
            this.mContext = context;
            this.mIntentList = intentList;
        }

        public void setListener(OnItemClickListener listener) {
            this.mCustomListener = listener;
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            ResolveInfo info = this.mIntentList.get(position);
            String name = info.activityInfo.name;
            String packageName = info.activityInfo.packageName;
            if (this.mCustomListener != null) {
                this.mCustomListener.onItemClick(parent, view, position, id2, name, packageName);
            } else {
                Intent intent = new Intent();
                intent.setComponent(new ComponentName(packageName, name));
                this.mContext.startActivity(intent);
            }
        }
    }

    public class ViewHolder {
        ImageView image;
        TextView title;
    }
}

