/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget.address;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.LoaderManager;
import android.content.Context;
import android.content.CursorLoader;
import android.content.DialogInterface;
import android.content.Loader;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.Toast;
import th.or.nectec.android.library.R;
import th.or.nectec.android.library.widget.address.AddressAdapter;

public class AddressDialog
extends DialogFragment
implements LoaderManager.LoaderCallbacks<Cursor> {
    AutoCompleteTextView searchAddr;
    EditText subdistrictEdit;
    EditText districtEdit;
    EditText provinceEdit;
    String mSearchWord;
    String addressCode;
    String subdistrict;
    String district;
    String province;
    AddressAdapter adapter;
    public static final int LOAD_ADDRESS = 1;
    private onAddressListener mListener;
    Uri mAddressUri;

    public static AddressDialog newInstance(Uri uri) {
        AddressDialog f = new AddressDialog();
        Bundle args = new Bundle();
        args.putString("uri", uri.toString());
        f.setArguments(args);
        return f;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        this.mAddressUri = Uri.parse((String)args.getString("uri"));
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        View view = inflater.inflate(R.layout.address_dialog, null);
        this.searchAddr = (AutoCompleteTextView)view.findViewById(R.id.search_address);
        this.subdistrictEdit = (EditText)view.findViewById(R.id.subdistrictText);
        this.districtEdit = (EditText)view.findViewById(R.id.districtText);
        this.provinceEdit = (EditText)view.findViewById(R.id.provinceText);
        this.subdistrictEdit.setText((CharSequence)this.subdistrict);
        this.districtEdit.setText((CharSequence)this.district);
        this.provinceEdit.setText((CharSequence)this.province);
        this.adapter = new AddressAdapter((Context)this.getActivity(), null, true);
        this.searchAddr.setAdapter((ListAdapter)this.adapter);
        this.searchAddr.setOnTouchListener(new View.OnTouchListener(){
            Drawable ClearIcon;
            {
                this.ClearIcon = AddressDialog.this.searchAddr.getCompoundDrawables()[2];
            }

            public boolean onTouch(View v, MotionEvent event) {
                if (this.ClearIcon != null) {
                    boolean tappedX;
                    boolean bl = tappedX = event.getX() > (float)(AddressDialog.this.searchAddr.getWidth() - AddressDialog.this.searchAddr.getPaddingRight() - this.ClearIcon.getIntrinsicWidth());
                    if (tappedX) {
                        if (event.getAction() == 1) {
                            AddressDialog.this.searchAddr.setText((CharSequence)"");
                            AddressDialog.this.subdistrictEdit.setText((CharSequence)"");
                            AddressDialog.this.districtEdit.setText((CharSequence)"");
                            AddressDialog.this.provinceEdit.setText((CharSequence)"");
                        }
                        return true;
                    }
                }
                return false;
            }
        });
        this.searchAddr.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> listView, View view, int position, long id2) {
                Cursor locale = (Cursor)listView.getAdapter().getItem(position);
                if (locale != null) {
                    AddressDialog.this.addressCode = locale.getString(0);
                    AddressDialog.this.subdistrict = locale.getString(1);
                    AddressDialog.this.district = locale.getString(2);
                    AddressDialog.this.province = locale.getString(3);
                }
                AddressDialog.this.searchAddr.setText((CharSequence)"");
                AddressDialog.this.subdistrictEdit.setText((CharSequence)AddressDialog.this.subdistrict);
                AddressDialog.this.districtEdit.setText((CharSequence)AddressDialog.this.district);
                AddressDialog.this.provinceEdit.setText((CharSequence)AddressDialog.this.province);
            }
        });
        this.searchAddr.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                AddressDialog.this.mSearchWord = AddressDialog.this.searchAddr.getText().toString();
                AddressDialog.this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)AddressDialog.this);
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
            }
        });
        return new AlertDialog.Builder((Context)this.getActivity()).setTitle((CharSequence)this.getResources().getString(R.string.address_dialog_title)).setView(view).setCancelable(true).setPositiveButton(R.string.save, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (AddressDialog.this.subdistrictEdit.getText().toString().isEmpty()) {
                    Toast.makeText((Context)AddressDialog.this.getActivity(), (CharSequence)"\u0e42\u0e1b\u0e23\u0e14\u0e23\u0e30\u0e1a\u0e38\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25\u0e01\u0e48\u0e2d\u0e19\u0e17\u0e35\u0e48\u0e08\u0e30\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25", (int)0).show();
                } else {
                    AddressDialog.this.mListener.onAddressSelect(AddressDialog.this.addressCode, AddressDialog.this.subdistrict, AddressDialog.this.district, AddressDialog.this.province);
                }
                AddressDialog.this.dismiss();
            }
        }).setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AddressDialog.this.dismiss();
            }
        }).create();
    }

    public void setAddress(String s, String d, String p) {
        this.subdistrict = s;
        this.district = d;
        this.province = p;
    }

    public void setOnAddressSelectListener(onAddressListener listener) {
        this.mListener = listener;
    }

    public static String setLocale(String subdistrict, String district, String province) {
        String locale = province.equals("\u0e01\u0e23\u0e38\u0e07\u0e40\u0e17\u0e1e\u0e21\u0e2b\u0e32\u0e19\u0e04\u0e23") ? "\u0e41\u0e02\u0e27\u0e07" + subdistrict + " \u0e40\u0e02\u0e15" + district + " " + province : "\u0e15." + subdistrict + " \u0e2d." + district + " \u0e08." + province;
        return locale;
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        switch (id2) {
            case 1: {
                String[] refProjection = new String[]{"address_code as _id", "subdistrict", "district", "province"};
                String selection = "subdistrict like '" + this.mSearchWord + "%' or district like '" + this.mSearchWord + "%' or province like '" + this.mSearchWord + "%'";
                CursorLoader cl = new CursorLoader((Context)this.getActivity(), this.mAddressUri, refProjection, selection, null, null);
                return cl;
            }
        }
        return null;
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor c) {
        switch (loader.getId()) {
            case 1: {
                this.adapter.swapCursor(c, this.mSearchWord);
                this.adapter.notifyDataSetChanged();
            }
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        switch (loader.getId()) {
            case 1: {
                this.adapter.swapCursor(null);
            }
        }
    }

    public static interface onAddressListener {
        public void onAddressSelect(String var1, String var2, String var3, String var4);
    }
}

