/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget.address;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.TextView;
import java.util.Locale;
import th.or.nectec.android.library.R;
import th.or.nectec.android.library.widget.TextViewHighLighter;

class AddressAdapter
extends CursorAdapter {
    Cursor mCursor;
    String mHighLight;

    public AddressAdapter(Context context, Cursor c, boolean autoRequery) {
        super(context, c, autoRequery);
        this.mCursor = c;
    }

    public Cursor swapCursor(Cursor newCursor, String hl) {
        this.mHighLight = hl;
        this.mCursor = newCursor;
        if (!TextUtils.isEmpty((CharSequence)this.mHighLight)) {
            this.mHighLight = this.mHighLight.toLowerCase(Locale.US);
        }
        return super.swapCursor(newCursor);
    }

    public Cursor swapCursor(Cursor newCursor) {
        this.mHighLight = null;
        this.mCursor = newCursor;
        return super.swapCursor(newCursor);
    }

    public Object getItem(int position) {
        return this.mCursor.moveToPosition(position) ? this.mCursor : null;
    }

    public void bindView(View view, Context context, Cursor cursor) {
        ViewHolder holder = (ViewHolder)view.getTag();
        int mColor = Color.parseColor((String)"#FF9900");
        if (cursor.getString(3).equals("\u0e01\u0e23\u0e38\u0e07\u0e40\u0e17\u0e1e\u0e21\u0e2b\u0e32\u0e19\u0e04\u0e23")) {
            TextViewHighLighter.highLight(holder.subdistrict, "\u0e41\u0e02\u0e27\u0e07" + cursor.getString(1), this.mHighLight, mColor);
            TextViewHighLighter.highLight(holder.district, "\u0e40\u0e02\u0e15" + cursor.getString(2), this.mHighLight, mColor);
            TextViewHighLighter.highLight(holder.province, cursor.getString(3), this.mHighLight, mColor);
        } else {
            TextViewHighLighter.highLight(holder.subdistrict, "\u0e15\u0e33\u0e1a\u0e25" + cursor.getString(1), this.mHighLight, mColor);
            TextViewHighLighter.highLight(holder.district, "\u0e2d\u0e33\u0e40\u0e20\u0e2d" + cursor.getString(2), this.mHighLight, mColor);
            TextViewHighLighter.highLight(holder.province, "\u0e08\u0e31\u0e07\u0e2b\u0e27\u0e31\u0e14" + cursor.getString(3), this.mHighLight, mColor);
        }
    }

    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        LayoutInflater vi = (LayoutInflater)context.getSystemService("layout_inflater");
        View v = vi.inflate(R.layout.address_dialog_item, null);
        ViewHolder holder = new ViewHolder();
        holder.subdistrict = (TextView)v.findViewById(R.id.subdistrictText);
        holder.district = (TextView)v.findViewById(R.id.districtText);
        holder.province = (TextView)v.findViewById(R.id.provinceText);
        v.setTag((Object)holder);
        return v;
    }

    private class ViewHolder {
        TextView subdistrict;
        TextView district;
        TextView province;

        private ViewHolder() {
        }
    }
}

