/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import java.util.Locale;
import th.or.nectec.android.library.util.DateTime;

public class ThaiDatePicker
extends LinearLayout {
    Spinner mSpnYear;
    Spinner mSpnMonth;
    Spinner mSpnDay;
    Context mContext;
    public static final int START_YEAR = 2400;
    public static final int YEAR_LENGHT = 300;
    private static final int[] mDayOfMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final String[] mThaiMonthArray = new String[]{"\u0e21\u0e01\u0e23\u0e32\u0e04\u0e21", "\u0e01\u0e38\u0e21\u0e20\u0e32\u0e1e\u0e31\u0e19\u0e18\u0e4c", "\u0e21\u0e35\u0e19\u0e32\u0e04\u0e21", "\u0e40\u0e21\u0e29\u0e32\u0e22\u0e19", "\u0e1e\u0e24\u0e29\u0e20\u0e32\u0e04\u0e21", "\u0e21\u0e34\u0e16\u0e38\u0e19\u0e32\u0e22\u0e19", "\u0e01\u0e23\u0e01\u0e0e\u0e32\u0e04\u0e21", "\u0e2a\u0e34\u0e07\u0e2b\u0e32\u0e04\u0e21", "\u0e01\u0e31\u0e19\u0e22\u0e32\u0e22\u0e19", "\u0e15\u0e38\u0e25\u0e32\u0e04\u0e21", "\u0e1e\u0e24\u0e28\u0e08\u0e34\u0e01\u0e32\u0e22\u0e19", "\u0e18\u0e31\u0e19\u0e27\u0e32\u0e04\u0e21"};
    private static final String[] mEngMonthArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static Integer[] mThaiYearArray;
    private static Integer[] mEngYearArray;
    public static final int LOCALE_ENGLISH = 0;
    public static final int LOCALE_THAI = 1;
    AdapterView.OnItemSelectedListener mYearMonthSelectedListener = new AdapterView.OnItemSelectedListener(){

        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            int month = ThaiDatePicker.this.mSpnMonth.getSelectedItemPosition();
            int th_year = ThaiDatePicker.this.mSpnYear.getSelectedItemPosition() + 2400;
            int en_year = th_year - 543;
            ThaiDatePicker.this.updateDaySpinner(en_year, month);
        }

        public void onNothingSelected(AdapterView<?> arg0) {
        }
    };
    private OnDateUpdateListener mDateUpdateListener;

    public ThaiDatePicker(Context context) {
        super(context);
        this.addSpinner(context, null);
    }

    public ThaiDatePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.addSpinner(context, null);
    }

    private void addSpinner(Context context, Locale locale) {
        this.mContext = context;
        this.mSpnYear = new Spinner(context);
        this.mSpnMonth = new Spinner(context);
        this.mSpnDay = new Spinner(context);
        Object[] monthArray = mThaiMonthArray;
        Object[] yearArray = mThaiYearArray;
        if (locale == null) {
            locale = context.getResources().getConfiguration().locale;
        }
        if (locale.toString().contains(Locale.ENGLISH.toString())) {
            monthArray = mEngMonthArray;
            yearArray = mEngYearArray;
        }
        if (this.isInEditMode()) {
            ArrayAdapter dayAdapter = new ArrayAdapter(context, 17367048, (Object[])new String[]{"31"});
            this.mSpnDay.setAdapter((SpinnerAdapter)dayAdapter);
        }
        LinearLayout.LayoutParams IntegerParam = new LinearLayout.LayoutParams(-2, -1);
        this.addView((View)this.mSpnDay, (ViewGroup.LayoutParams)IntegerParam);
        ArrayAdapter monthAdapter = new ArrayAdapter(context, 17367048, monthArray);
        monthAdapter.setDropDownViewResource(0x1090009);
        this.mSpnMonth.setAdapter((SpinnerAdapter)monthAdapter);
        this.addView((View)this.mSpnMonth, (ViewGroup.LayoutParams)IntegerParam);
        if (!locale.toString().contains(Locale.ENGLISH.toString())) {
            TextView textview = new TextView(this.mContext);
            textview.setText((CharSequence)"\u0e1e.\u0e28.");
            this.addView((View)textview, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        }
        ArrayAdapter yearAdapter = new ArrayAdapter(context, 17367048, yearArray);
        yearAdapter.setDropDownViewResource(0x1090009);
        this.mSpnYear.setAdapter((SpinnerAdapter)yearAdapter);
        this.addView((View)this.mSpnYear, (ViewGroup.LayoutParams)IntegerParam);
        this.mSpnMonth.setOnItemSelectedListener(this.mYearMonthSelectedListener);
        this.mSpnYear.setOnItemSelectedListener(this.mYearMonthSelectedListener);
    }

    public void setLocale(int i) {
        this.removeAllViews();
        switch (i) {
            case 0: {
                this.addSpinner(this.mContext, Locale.ENGLISH);
                break;
            }
            case 1: {
                this.addSpinner(this.mContext, new Locale("th"));
            }
        }
    }

    private synchronized int updateDaySpinner(int year, int month) {
        int lenght = month == 1 ? LeapDay.february(year) : mDayOfMonth[month];
        Object[] day = new Integer[lenght];
        for (int i = 0; i < lenght; ++i) {
            day[i] = i + 1;
        }
        ArrayAdapter dayAdapter = new ArrayAdapter(this.mContext, 17367048, day);
        dayAdapter.setDropDownViewResource(0x1090009);
        int lastPosition = this.mSpnDay.getSelectedItemPosition();
        this.mSpnDay.setAdapter((SpinnerAdapter)dayAdapter);
        if (lastPosition > day.length - 1) {
            lastPosition = day.length - 1;
        }
        this.mSpnDay.setSelection(lastPosition);
        if (this.mDateUpdateListener != null) {
            this.mDateUpdateListener.onDateUpdate(this.getDate());
        }
        return day.length;
    }

    public void setOnDateUpdateListner(OnDateUpdateListener listener) {
        this.mDateUpdateListener = listener;
    }

    private synchronized void updateDaySpinner(int year, int month, int dayOfMonth) {
        int maxday = this.updateDaySpinner(year, month);
        if (dayOfMonth > maxday) {
            this.mSpnDay.setSelection(maxday - 1);
        } else if (dayOfMonth <= 0) {
            this.mSpnDay.setSelection(0);
        } else {
            this.mSpnDay.setSelection(dayOfMonth - 1);
        }
    }

    public void updateDate(int year, int month, int dayOfMonth) {
        int yearIndex = year + 543 - 2400;
        yearIndex = yearIndex > 300 ? 300 : yearIndex;
        yearIndex = yearIndex < 0 ? 0 : yearIndex;
        this.mSpnYear.setSelection(yearIndex);
        if (month > 11) {
            month = 11;
        }
        if (month < 0) {
            month = 0;
        }
        this.mSpnMonth.setSelection(month);
        this.updateDaySpinner(year, month, dayOfMonth);
    }

    public void updateDate(DateTime date) {
        this.updateDate(date.year, date.month - 1, date.day);
    }

    public void updateDate() {
        DateTime now = DateTime.newInstance();
        this.updateDate(now.year, now.month - 1, now.day);
    }

    public int getYear() {
        return this.mSpnYear.getSelectedItemPosition() + 2400 - 543;
    }

    public int getThaiYear() {
        return this.mSpnYear.getSelectedItemPosition() + 2400;
    }

    public int getMonth() {
        return this.mSpnMonth.getSelectedItemPosition() + 1;
    }

    public int getDayOfMonth() {
        return this.mSpnDay.getSelectedItemPosition() + 1;
    }

    public void setEnabled(boolean enabled) {
        this.mSpnDay.setEnabled(enabled);
        this.mSpnMonth.setEnabled(enabled);
        this.mSpnYear.setEnabled(enabled);
    }

    public DateTime getDate() {
        DateTime date = new DateTime(this.getYear(), this.getMonth(), this.getDayOfMonth());
        return date;
    }

    public String toString() {
        return this.getYear() + "-" + this.getMonth() + "-" + this.getDayOfMonth();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.day = this.getDayOfMonth();
        ss.month = this.getMonth();
        ss.year = this.getYear();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.updateDate(ss.year, ss.month - 1, ss.day);
    }

    static {
        int lenght = 300;
        int startYear = 2400;
        int engStartYear = 1857;
        mThaiYearArray = new Integer[lenght + 1];
        mEngYearArray = new Integer[lenght + 1];
        for (int i = 0; i <= lenght; ++i) {
            ThaiDatePicker.mThaiYearArray[i] = startYear + i;
            ThaiDatePicker.mEngYearArray[i] = engStartYear + i;
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int day;
        int month;
        int year;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.day = in.readInt();
            this.month = in.readInt();
            this.year = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.day);
            out.writeInt(this.month);
            out.writeInt(this.year);
        }
    }

    public static class LeapDay {
        public static int february(int year) {
            return LeapDay.isLeapYear(year) ? 29 : 28;
        }

        public static boolean isLeapYear(int year) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
    }

    public static interface OnDateUpdateListener {
        public void onDateUpdate(DateTime var1);
    }
}

