/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.app.DialogFragment;
import android.app.LoaderManager;
import android.content.Loader;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import th.or.nectec.android.library.R;
import th.or.nectec.android.library.widget.CursorStringIdAdapter;
import th.or.nectec.android.library.widget.HighLightCursorAdapter;

public abstract class SearchListDialog
extends DialogFragment
implements TextWatcher,
LoaderManager.LoaderCallbacks<Cursor>,
AdapterView.OnItemClickListener {
    public static final String EXTRA_NOT_SEARCHABLE = "not_searchable";
    public static final String EXTRA_APPEND_WHERE = "append";
    public static final String EXTRA_DEFAULT_WHERE = "default";
    private ListView mListView;
    private LinearLayout mProgessLayout;
    private ImageButton mClose;
    private EditText mEditText;
    private HighLightCursorAdapter mAdapter;
    private CursorStringIdAdapter mBadapter;
    private ItemClickListener mListener;
    private Cursor mCursor;
    private String mFilter;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973941);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.default_searchable_list, container, false);
        this.mListView = (ListView)view.findViewById(16908298);
        this.mAdapter = this.getCursorAdapter();
        if (this.mAdapter != null) {
            this.mListView.setAdapter((ListAdapter)this.mAdapter);
        } else {
            this.mBadapter = this.getBaseAdapter();
            if (this.mBadapter != null) {
                this.mListView.setAdapter((ListAdapter)this.mBadapter);
            } else {
                throw new IllegalArgumentException("not found any adapter for listView");
            }
        }
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mEditText = (EditText)view.findViewById(R.id.search);
        this.mEditText.addTextChangedListener((TextWatcher)this);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mEditText.setVisibility(args.getBoolean(EXTRA_NOT_SEARCHABLE) ? 8 : 0);
        }
        this.mProgessLayout = (LinearLayout)view.findViewById(16908301);
        this.mClose = (ImageButton)view.findViewById(R.id.deleted);
        this.mClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchListDialog.this.mEditText.setText(null);
            }
        });
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this);
        return view;
    }

    protected String appendWhere(String selection) {
        if (this.getArguments() != null) {
            String extra = this.getArguments().getString(EXTRA_APPEND_WHERE);
            if (TextUtils.isEmpty((CharSequence)extra)) {
                return selection;
            }
            String append = " (" + extra + ") ";
            selection = !TextUtils.isEmpty((CharSequence)selection) ? " (" + selection + ") AND " + append : append;
        }
        return selection;
    }

    protected String appendDefaultWhere(String selection) {
        if (!TextUtils.isEmpty((CharSequence)this.mFilter)) {
            return selection;
        }
        if (this.getArguments() != null) {
            String extra = this.getArguments().getString(EXTRA_DEFAULT_WHERE);
            if (TextUtils.isEmpty((CharSequence)extra)) {
                return selection;
            }
            String append = " (" + extra + ") ";
            selection = !TextUtils.isEmpty((CharSequence)selection) ? " (" + selection + ") AND " + append : append;
        }
        return selection;
    }

    public void setAdapter(HighLightCursorAdapter adapter) {
        this.mAdapter = adapter;
    }

    public void setAdapter(CursorStringIdAdapter adapter) {
        this.mBadapter = adapter;
    }

    protected void setShowEditText(boolean show) {
        this.mEditText.setVisibility(show ? 0 : 8);
    }

    public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
        if (this.mListener != null) {
            if (this.mAdapter != null) {
                this.mListener.onItemClick(this.mAdapter, arg3, arg2);
            } else if (this.mBadapter != null) {
                int name_col = this.mCursor.getColumnIndex("name");
                this.mCursor.moveToPosition(arg2);
                this.mListener.onItemClick(this.mBadapter, (String)this.mBadapter.getItem(arg2), name_col > -1 ? this.mCursor.getString(name_col) : null);
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.getLoaderManager().destroyLoader(0);
        this.mListView = null;
        this.mListener = null;
        this.mEditText = null;
        this.mAdapter = null;
        this.mBadapter = null;
        if (this.mCursor != null) {
            this.mCursor.close();
        }
        this.mCursor = null;
        this.mProgessLayout = null;
        this.mFilter = null;
    }

    public abstract HighLightCursorAdapter getCursorAdapter();

    public abstract CursorStringIdAdapter getBaseAdapter();

    public void setItemClickListener(ItemClickListener listener) {
        this.mListener = listener;
    }

    protected void showProgess(boolean show) {
        if (this.mProgessLayout != null) {
            if (show) {
                this.mProgessLayout.setVisibility(0);
            } else {
                this.mProgessLayout.setVisibility(8);
            }
        }
    }

    public void afterTextChanged(Editable s) {
        this.mFilter = s.toString();
        this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public Loader<Cursor> onCreateLoader(int arg0, Bundle arg1) {
        this.showProgess(true);
        return this.onLoadCursor(this.mFilter);
    }

    public abstract Loader<Cursor> onLoadCursor(String var1);

    public void onLoaderReset(Loader<Cursor> arg0) {
        if (this.mAdapter != null) {
            this.mAdapter.swapCursor(null);
        }
        if (this.mBadapter != null) {
            this.mBadapter.swapCursor(null);
        }
    }

    public void onLoadFinished(Loader<Cursor> arg0, Cursor arg1) {
        this.mCursor = arg1;
        if (this.mAdapter != null) {
            this.mAdapter.swapCursor(arg1, this.mFilter);
            this.showProgess(false);
        }
        if (this.mBadapter != null) {
            this.mBadapter.swapCursor(arg1, this.mFilter);
            this.showProgess(false);
        }
    }

    public abstract Uri getContentUri();

    public abstract String[] getProjection();

    public abstract String[] getFrom();

    public abstract int[] getTo();

    public abstract int getLayout();

    public static abstract class BaseAdapter
    extends SearchListDialog {
        @Override
        public final HighLightCursorAdapter getCursorAdapter() {
            return null;
        }

        @Override
        public final String[] getProjection() {
            return null;
        }

        @Override
        public final String[] getFrom() {
            return null;
        }

        @Override
        public final int[] getTo() {
            return null;
        }

        @Override
        public final int getLayout() {
            return 0;
        }
    }

    public static interface ItemClickListener {
        public void onItemClick(HighLightCursorAdapter var1, long var2, int var4);

        public void onItemClick(CursorStringIdAdapter var1, String var2, String var3);
    }
}

