/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;

public class NestedExpandableListView
extends ExpandableListView
implements View.OnTouchListener,
AbsListView.OnScrollListener {
    private int listViewTouchAction = -1;
    private static final int MAXIMUM_LIST_ITEMS_VIEWABLE = 99;

    public NestedExpandableListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOnScrollListener(this);
        this.setOnTouchListener(this);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.getExpandableListAdapter() != null && this.getExpandableListAdapter().getGroupCount() > 99 && this.listViewTouchAction == 2) {
            this.scrollBy(0, -1);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int newHeight = 0;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (heightMode != 0x40000000) {
            ExpandableListAdapter expandListAdapter = this.getExpandableListAdapter();
            if (expandListAdapter != null && !expandListAdapter.isEmpty()) {
                int groupPosition = 0;
                int groupCount = this.getExpandableListAdapter().getGroupCount();
                for (groupPosition = 0; groupPosition < groupCount; ++groupPosition) {
                    boolean isExpand = this.isGroupExpanded(groupPosition);
                    View grouplistItem = expandListAdapter.getGroupView(groupPosition, isExpand, null, (ViewGroup)this);
                    if (grouplistItem instanceof ViewGroup) {
                        grouplistItem.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-2, -2));
                    }
                    int allChildHeight = 0;
                    if (isExpand) {
                        int childCount = this.getExpandableListAdapter().getChildrenCount(groupPosition);
                        int childPosition = 0;
                        for (childPosition = 0; childPosition < childCount; ++childPosition) {
                            boolean isLastChild = childPosition >= childCount;
                            View childListItem = expandListAdapter.getChildView(groupPosition, childPosition, isLastChild, null, (ViewGroup)this);
                            if (childListItem instanceof ViewGroup) {
                                childListItem.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-2, -2));
                            }
                            childListItem.measure(widthMeasureSpec, heightMeasureSpec);
                            allChildHeight += childListItem.getMeasuredHeight();
                        }
                    }
                    grouplistItem.measure(widthMeasureSpec, heightMeasureSpec);
                    newHeight += grouplistItem.getMeasuredHeight() + allChildHeight;
                }
                newHeight += this.getDividerHeight() * groupPosition + this.getPaddingTop() + this.getPaddingBottom();
            }
            if (heightMode == Integer.MIN_VALUE && newHeight > heightSize && newHeight > heightSize) {
                newHeight = heightSize;
            }
        } else {
            newHeight = this.getMeasuredHeight();
        }
        this.setMeasuredDimension(this.getMeasuredWidth(), newHeight);
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.getExpandableListAdapter() != null && this.getAdapter().getCount() > 99) {
            Log.d((String)"adapter count touch", (String)(this.getExpandableListAdapter().getGroupCount() + ""));
            if (this.listViewTouchAction == 2) {
                this.scrollBy(0, 1);
            }
        }
        return false;
    }
}

