/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import th.or.nectec.android.library.R;

public class ClearableEditText
extends EditText
implements View.OnTouchListener,
View.OnFocusChangeListener,
TextWatcher {
    boolean mClearIconVisible = false;
    private Drawable xD;
    private Drawable xDI;
    private OnClearListener listener;
    private View.OnTouchListener l;
    private View.OnFocusChangeListener f;

    public ClearableEditText(Context context) {
        super(context);
        this.init();
    }

    public ClearableEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.xD = this.getCompoundDrawables()[2];
        if (this.xD == null) {
            this.xD = this.getResources().getDrawable(this.getDefaultClearIconId());
        }
        this.xD.setBounds(0, 0, this.xD.getMinimumWidth(), this.xD.getMinimumHeight());
        this.xDI = this.getResources().getDrawable(R.drawable.ic_clear_invisible);
        this.xDI.setBounds(0, 0, this.xDI.getMinimumWidth(), this.xDI.getMinimumHeight());
        if (!this.isInEditMode()) {
            this.init();
        } else {
            this.setClearIconVisible(true);
        }
    }

    public ClearableEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            this.init();
        }
    }

    public void setOnClearListener(OnClearListener listener) {
        this.listener = listener;
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.l = l;
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener f) {
        this.f = f;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.getCompoundDrawables()[2] != null) {
            boolean tappedX;
            boolean bl = tappedX = event.getX() > (float)(this.getWidth() - this.getPaddingRight() - this.xD.getIntrinsicWidth());
            if (tappedX) {
                if (event.getAction() == 1) {
                    this.setText("");
                    if (this.listener != null) {
                        this.listener.onClear();
                    }
                }
                return true;
            }
        }
        if (this.l != null) {
            return this.l.onTouch(v, event);
        }
        return false;
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            boolean isVisible = !TextUtils.isEmpty((CharSequence)this.getText().toString());
            this.setClearIconVisible(isVisible);
        } else {
            this.setClearIconVisible(false);
        }
        if (this.f != null) {
            this.f.onFocusChange(v, hasFocus);
        }
    }

    private void init() {
        this.setClearIconVisible(false);
        super.setOnTouchListener((View.OnTouchListener)this);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.addTextChangedListener(this);
    }

    private int getDefaultClearIconId() {
        int id2 = R.drawable.ic_action_clear;
        return id2;
    }

    protected void setClearIconVisible(boolean visible) {
        if (this.mClearIconVisible == visible) {
            return;
        }
        this.mClearIconVisible = visible;
        Drawable x = visible ? this.xD : this.xDI;
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], x, this.getCompoundDrawables()[3]);
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
    }

    public void afterTextChanged(Editable editable) {
    }

    public void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        if (this.isFocused()) {
            boolean visible = false;
            if (text != null && text.length() > 0) {
                visible = true;
            }
            this.setClearIconVisible(visible);
        }
    }

    public static interface OnClearListener {
        public void onClear();
    }
}

