/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CheckBoxesGroup
extends LinearLayout {
    private String[] previewArray = new String[]{"1:CheckBoxesGroup Item 1", "2:CheckBoxesGroup Item 2", "3:CheckBoxesGroup Item 3"};
    public static final int SINGLE_CHOICE = 1;
    public static final int MULTI_CHOICE = 2;
    private Context mContext;
    private int mMode = 2;
    private final CompoundButton.OnCheckedChangeListener mSingleChoiceListerner = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (CheckBoxesGroup.this.mMode == 1 && isChecked) {
                CheckBoxesGroup.this.setChecked(false);
                buttonView.setChecked(true);
            }
            if (CheckBoxesGroup.this.mChkChangeListener != null) {
                CheckBoxesGroup.this.mChkChangeListener.onCheckedChange((String)buttonView.getTag(), isChecked);
            }
        }
    };
    String[] mArray;
    HashMap<String, CheckBox> mItem;
    OnCheckedItemChangeListener mChkChangeListener;

    public CheckBoxesGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.setOrientation(1);
        if (this.isInEditMode()) {
            this.setArray(this.previewArray);
        }
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: {
                this.mMode = mode;
                break;
            }
            default: {
                throw new InvalidParameterException("Mode not support");
            }
        }
    }

    public void setArray(int stringArrayId) {
        this.setArray(this.getResources().getStringArray(stringArrayId));
    }

    public void setArray(String[] array) {
        this.mArray = array;
        this.mItem = new HashMap();
        this.removeAllViews();
        for (String item : this.mArray) {
            if (!item.matches(".*:.{1,}")) {
                throw new InvalidParameterException("Array Item invalid format");
            }
            String key = item.substring(0, item.indexOf(":"));
            String label = item.substring(item.indexOf(":") + 1);
            CheckBox cb = new CheckBox(this.mContext);
            cb.setText((CharSequence)label);
            cb.setTag((Object)key);
            if (this.mMode == 1) {
                cb.setOnCheckedChangeListener(this.mSingleChoiceListerner);
            }
            this.addView((View)cb);
            this.mItem.put(key, cb);
        }
    }

    public String[] getKey() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, CheckBox> entry : this.mItem.entrySet()) {
            keys.add(entry.getKey());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public void setEnabled(boolean enabled) {
        for (Map.Entry<String, CheckBox> entry : this.mItem.entrySet()) {
            entry.getValue().setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public void setEnabled(boolean enabled, String ... keys) {
        for (String key : keys) {
            this.mItem.get(key).setEnabled(enabled);
        }
    }

    public boolean isChecked() {
        for (Map.Entry<String, CheckBox> entry : this.mItem.entrySet()) {
            if (!entry.getValue().isChecked()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> getCheckedItem() {
        ArrayList<String> chklst = new ArrayList<String>();
        for (Map.Entry<String, CheckBox> entry : this.mItem.entrySet()) {
            if (!entry.getValue().isChecked()) continue;
            chklst.add(entry.getKey());
        }
        return chklst;
    }

    public void setChecked(boolean checked) {
        for (Map.Entry<String, CheckBox> entry : this.mItem.entrySet()) {
            entry.getValue().setChecked(checked);
        }
    }

    public void setChecked(boolean checked, String ... keys) {
        for (String key : keys) {
            this.mItem.get(key).setChecked(checked);
        }
    }

    public void setOnCheckedItemChangeListener(OnCheckedItemChangeListener listener) {
        this.mChkChangeListener = listener;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.arry = this.mArray;
        ArrayList<String> chkItem = this.getCheckedItem();
        ss.checked = chkItem.toArray(new String[chkItem.size()]);
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setArray(ss.arry);
        this.setChecked(true, ss.checked);
    }

    static class SavedState
    extends View.BaseSavedState {
        protected String[] arry;
        protected String[] checked;
        private int arrySize;
        private int chkSize;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.arrySize = in.readInt();
            this.arry = new String[this.arrySize];
            in.readStringArray(this.arry);
            this.chkSize = in.readInt();
            this.checked = new String[this.chkSize];
            in.readStringArray(this.checked);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.arry.length);
            out.writeStringArray(this.arry);
            out.writeInt(this.checked.length);
            out.writeStringArray(this.checked);
        }
    }

    public static interface OnCheckedItemChangeListener {
        public void onCheckedChange(String var1, boolean var2);
    }
}

