/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import th.or.nectec.android.library.R;

public class ArrayFormatSpinner
extends Spinner {
    String[] mArray;

    public ArrayFormatSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setArray(int stringArrayId) {
        this.setArray(this.getResources().getStringArray(stringArrayId));
    }

    public void setArray(String[] array, int layoutId) {
        this.mArray = array;
        ArrayList<String> list = new ArrayList<String>();
        for (String item : this.mArray) {
            if (!item.matches(".*:.{1,}")) {
                throw new InvalidParameterException("Array Item invalid format");
            }
            list.add(item.substring(item.indexOf(":") + 1));
        }
        ArrayAdapter adapter = new ArrayAdapter(this.getContext(), layoutId, list);
        this.setAdapter((SpinnerAdapter)adapter);
    }

    public void setArray(String[] array) {
        this.setArray(array, R.layout.default_spinner_item);
    }

    public void setSelection(String id2) {
        if (!TextUtils.isEmpty((CharSequence)id2)) {
            for (int i = 0; i < this.mArray.length; ++i) {
                String item = this.mArray[i];
                String k = item.substring(0, item.indexOf(":"));
                if (!k.equals(id2)) continue;
                this.setSelection(i, true);
                break;
            }
        }
    }

    public String getSelectionId() {
        String id2 = null;
        String item = this.mArray[this.getSelectedItemPosition()];
        id2 = item.substring(0, item.indexOf(":"));
        if (TextUtils.isEmpty((CharSequence)id2)) {
            return null;
        }
        return id2;
    }
}

