/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.util.lazylist;

import android.content.Context;
import android.os.Environment;
import java.io.File;

public class FileCache {
    private File cacheDir;

    public FileCache(Context context) {
        this.cacheDir = Environment.getExternalStorageState().equals("mounted") ? context.getExternalCacheDir() : context.getCacheDir();
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
    }

    public File getFile(String url) {
        String filename = url.substring(url.lastIndexOf("/") + 1);
        File f = new File(this.cacheDir, filename);
        return f;
    }

    public void clear() {
        File[] files = this.cacheDir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            f.delete();
        }
    }
}

