/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.util;

import android.app.Activity;
import android.database.Cursor;
import android.text.TextUtils;
import android.util.Log;
import android.widget.TextView;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CursorHelper {
    public static final String tag = "cursor-helper";

    public static String getString(Cursor c, String columnName) {
        return c.getString(c.getColumnIndex(columnName));
    }

    public static int getInt(Cursor c, String columnName) {
        return c.getInt(c.getColumnIndex(columnName));
    }

    public static double getDouble(Cursor c, String columnName) {
        return c.getDouble(c.getColumnIndex(columnName));
    }

    public static long getLong(Cursor c, String columnName) {
        return c.getLong(c.getColumnIndex(columnName));
    }

    public static void setText(Activity activity, Cursor c, String columnName, int textViewId) {
        String str = CursorHelper.getString(c, columnName);
        if (!TextUtils.isEmpty((CharSequence)str)) {
            TextView txt = (TextView)activity.findViewById(textViewId);
            txt.setText((CharSequence)str);
        }
    }

    public static JSONArray cursorToJsonArray(Cursor c, String[] column) {
        int colLength = column.length;
        if (c.moveToFirst()) {
            JSONArray jsonArray = new JSONArray();
            do {
                JSONObject record = new JSONObject();
                for (int i = 0; i < colLength; ++i) {
                    try {
                        record.put(column[i], (Object)c.getString(i));
                        continue;
                    }
                    catch (JSONException jex) {
                        jex.printStackTrace();
                    }
                }
                Log.d((String)"cursorToJsonArray", (String)record.toString());
                jsonArray.put((Object)record);
            } while (c.moveToNext());
            return jsonArray;
        }
        return null;
    }

    public static void logData(Cursor c) {
        if (!c.moveToFirst()) {
            Log.d((String)tag, (String)"not found any data");
            return;
        }
        Log.d((String)tag, (String)c.toString());
        int columnCount = c.getColumnCount();
        do {
            String record = "";
            for (int i = 0; i < columnCount; ++i) {
                String data = c.getString(i);
                if (TextUtils.isEmpty((CharSequence)data)) {
                    data = "IS NULL";
                }
                String tmp = c.getColumnName(i) + "=" + data;
                if (i != columnCount - 1) {
                    tmp = tmp + ", ";
                }
                record = record + tmp;
            }
            Log.d((String)tag, (String)record);
        } while (c.moveToNext());
    }
}

