/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.util;

import th.or.nectec.android.library.util.DateTime;
import th.or.nectec.android.library.util.LeapDay;

public class AgeCalculator {
    public static final int max_year = 12;
    private int[] mDayOfMonth;
    private DateTime current;
    private DateTime born;
    private DateTime age;

    public AgeCalculator(DateTime current, DateTime born) {
        int february = LeapDay.february(current.year);
        this.mDayOfMonth = new int[]{31, february, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        this.current = current;
        this.born = born;
    }

    public DateTime calulate() {
        if (this.born == null || this.current == null) {
            throw new NullPointerException("Born or Current is Null");
        }
        this.age = new DateTime();
        if (!(this.born.year > this.current.year || this.born.year == this.current.year && this.born.month > this.current.month || this.born.year == this.current.year && this.born.month > this.current.month && this.born.day > this.current.day)) {
            if (this.current.month == this.born.month && this.current.day == this.born.day) {
                this.age.year = this.current.year - this.born.year;
                this.age.month = 0;
                this.age.day = 0;
            } else if (this.current.month == this.born.month && this.current.day > this.born.day) {
                this.age.year = this.current.year - this.born.year;
                this.age.month = 0;
                this.age.day = this.current.day - this.born.day;
            } else if (this.current.month == this.born.month && this.current.day < this.born.day) {
                this.age.year = this.current.year - this.born.year - 1;
                this.age.month = 12 - (this.current.month - this.born.month) - 1;
                this.age.day = this.mDayOfMonth[this.current.month - 1] - (this.born.day - this.current.day);
            } else if (this.current.month > this.born.month && this.current.day == this.born.day) {
                this.age.year = this.current.year - this.born.year;
                this.age.month = this.current.month - this.born.month;
                this.age.day = 0;
            } else if (this.current.month > this.born.month && this.current.day > this.born.day) {
                this.age.year = this.current.year - this.born.year;
                this.age.month = this.current.month - this.born.month;
                this.age.day = this.current.day - this.born.day;
            } else if (this.current.month > this.born.month && this.current.day < this.born.day) {
                this.age.year = this.current.year - this.born.year;
                this.age.month = (this.current.month - this.born.month - 1) % this.mDayOfMonth.length;
                this.age.day = this.mDayOfMonth[this.current.month - 1] - (this.born.day - this.current.day);
            } else if (this.current.month < this.born.month && this.current.day == this.born.day) {
                this.age.year = this.current.year - this.born.year - 1;
                this.age.month = 12 - (this.born.month - this.current.month);
                this.age.day = 0;
            } else if (this.current.month < this.born.month && this.current.day > this.born.day) {
                this.age.year = this.current.year - this.born.year - 1;
                this.age.month = 12 - (this.born.month - this.current.month);
                this.age.day = this.current.day - this.born.day;
            } else if (this.current.month < this.born.month && this.current.day < this.born.day) {
                this.age.year = this.current.year - this.born.year - 1;
                this.age.month = 12 - (this.born.month - this.current.month) - 1;
                this.age.day = this.mDayOfMonth[this.current.month - 1] - (this.born.day - this.current.day);
            }
        }
        return this.age;
    }

    public String toString() {
        return this.age.year + "  " + this.age.month + " " + this.age.day + " ";
    }

    public static String toAgeFormat(DateTime date) {
        return date.year + " year " + date.month + " month " + date.day + " day";
    }
}

