/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.security;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;

public class TrackingFragmentActivity
extends FragmentActivity {
    private static String TAG = "UserTrackingActivity";
    private static final String KEY_LEAVE = "Leave";
    private static final String KEY_LEAVE_TIME = "LeaveTime";
    private static final String KEY_SYSTEM_INTERRUPT = "sysInterrupt";
    private boolean mLeave = false;
    private long mLeaveTime = 0L;
    private boolean mSystemInterrupt = false;
    private boolean mStartActivity = false;
    private boolean mUserLeaveHint = false;
    private boolean mCreateDescription = false;
    private boolean mScreenReceiverRegisted = false;
    private BroadcastReceiver mScreenReceiver;
    private Bundle mSaveState;

    protected void onCreate(Bundle savedInstanceState) {
        Log.d((String)TAG, (String)"OnCreate()");
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mLeave = savedInstanceState.getBoolean(KEY_LEAVE);
            this.mLeaveTime = savedInstanceState.getLong(KEY_LEAVE_TIME, 0L);
            this.mSystemInterrupt = savedInstanceState.getBoolean(KEY_SYSTEM_INTERRUPT, false);
        }
    }

    protected void onStart() {
        Log.d((String)TAG, (String)"Onstart()");
        if (!this.mScreenReceiverRegisted) {
            this.mScreenReceiverRegisted = true;
            IntentFilter mScreenActionfilter = new IntentFilter();
            mScreenActionfilter.addAction("android.intent.action.SCREEN_ON");
            mScreenActionfilter.addAction("android.intent.action.SCREEN_OFF");
            this.mScreenReceiver = new ScreenActionReceiver();
            this.registerReceiver(this.mScreenReceiver, mScreenActionfilter);
        }
        super.onStart();
    }

    protected void onResume() {
        Log.d((String)TAG, (String)"OnResume()");
        this.mStartActivity = false;
        this.mUserLeaveHint = false;
        this.mCreateDescription = false;
        super.onResume();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        Log.d((String)TAG, (String)"onWindowFocusChanged()");
        if (hasFocus && this.mLeave) {
            this.onUserBack(this.mLeaveTime, this.mSystemInterrupt);
            this.mLeave = false;
        }
        super.onWindowFocusChanged(hasFocus);
    }

    protected void onPause() {
        Log.d((String)TAG, (String)"OnPause()");
        super.onPause();
    }

    protected void onUserLeaveHint() {
        Log.d((String)TAG, (String)"OnUserLeaveHint()");
        this.mUserLeaveHint = true;
        super.onUserLeaveHint();
    }

    protected void onSaveInstanceState(Bundle outState) {
        Log.d((String)TAG, (String)"onSaveInstanceState()");
        super.onSaveInstanceState(outState);
        this.mSaveState = outState;
        this.mSaveState.putBoolean(KEY_LEAVE, this.mLeave);
        this.mSaveState.putBoolean(KEY_SYSTEM_INTERRUPT, this.mSystemInterrupt);
        this.mSaveState.putLong(KEY_LEAVE_TIME, this.mLeaveTime);
    }

    public CharSequence onCreateDescription() {
        Log.d((String)TAG, (String)"onCreateDescription()");
        this.mCreateDescription = true;
        return super.onCreateDescription();
    }

    protected void onStop() {
        Log.d((String)TAG, (String)"OnStop()");
        if (!this.mStartActivity && this.mCreateDescription) {
            this.mLeave = true;
            if (this.mSaveState != null) {
                this.mSaveState.putBoolean(KEY_LEAVE, this.mLeave);
                this.mSaveState.putBoolean(KEY_SYSTEM_INTERRUPT, !this.mUserLeaveHint);
            }
            if (!this.mUserLeaveHint) {
                this.mSystemInterrupt = true;
                this.onSystemInterrupt();
            }
            this.onUserLeave(!this.mUserLeaveHint);
        } else {
            this.unregisterReceiver(this.mScreenReceiver);
            this.mScreenReceiverRegisted = false;
            Log.w((String)TAG, (String)"UTA : Unregistered ScreenReceiver!");
        }
        super.onStop();
    }

    protected void onDestroy() {
        Log.d((String)TAG, (String)"OnDestroy()");
        if (this.mScreenReceiverRegisted) {
            this.unregisterReceiver(this.mScreenReceiver);
        }
        this.mSaveState = null;
        this.mScreenReceiver = null;
        super.onDestroy();
    }

    public void startActivity(Intent intent) {
        this.mStartActivity = true;
        super.startActivity(intent);
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        this.mStartActivity = true;
        super.startActivityForResult(intent, requestCode);
    }

    public void startActivityFromChild(Activity child, Intent intent, int requestCode) {
        this.mStartActivity = true;
        super.startActivityFromChild(child, intent, requestCode);
    }

    protected void onScreenOff() {
        this.onUserLeave(false);
    }

    protected void onScreenOn() {
    }

    protected void onUserLeave(boolean systemInterrupt) {
        this.mLeaveTime = System.currentTimeMillis();
        if (this.mSaveState != null) {
            this.mSaveState.putLong(KEY_LEAVE_TIME, this.mLeaveTime);
        }
    }

    protected void onSystemInterrupt() {
    }

    protected void onUserBack(long leaveTime, boolean isSystemInterrupt) {
    }

    private class ScreenActionReceiver
    extends BroadcastReceiver {
        private ScreenActionReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                TrackingFragmentActivity.this.mLeave = true;
                TrackingFragmentActivity.this.onScreenOff();
            } else if (intent.getAction().equals("android.intent.action.SCREEN_ON")) {
                TrackingFragmentActivity.this.onScreenOn();
            }
        }
    }
}

