/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.security;

import android.content.Context;
import java.io.File;
import java.io.IOException;

public class SecureDatabaseCreator {
    static boolean writable = true;
    static boolean readable = true;
    static boolean ownerOnly = true;

    public static File CreateSecureDatabase(Context context, String name) {
        File db = new File(SecureDatabaseCreator.makeDatabseDir(context).getAbsolutePath(), name);
        try {
            if (!db.exists()) {
                db.createNewFile();
            }
            db.setWritable(writable, ownerOnly);
            db.setReadable(readable, ownerOnly);
            return db;
        }
        catch (IOException io) {
            io.printStackTrace();
            return null;
        }
    }

    public static File CreateSecureDatabasGroup(Context context, String name) {
        try {
            context.openFileOutput(name, 0).close();
            File db = new File(context.getFilesDir().getPath() + "/files/", name);
            File ndb = new File(SecureDatabaseCreator.makeDatabseDir(context).getAbsolutePath(), name);
            if (ndb.exists()) {
                ndb.delete();
            }
            db.renameTo(ndb);
            return ndb;
        }
        catch (IOException io) {
            io.printStackTrace();
            return null;
        }
    }

    private static File makeDatabseDir(Context context) {
        File dir = new File(context.getFilesDir().getPath() + "/databases/");
        if (!dir.exists()) {
            context.openOrCreateDatabase("temp.db", 0, null);
        }
        return dir;
    }
}

