/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.phototaker;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import th.or.nectec.android.library.phototaker.MediaUriFinder;

public class PhotoTaker {
    public static final String CODE_VERSION = "1.0";
    public static final String ACTION_CROP_IMAGE = "com.android.camera.action.CROP";
    public static final String TEMP_PREFIX = "tmp_";
    public static final int IMAGE_CAPTURE = 10000;
    public static final int CROP_IMAGE = 10001;
    public static final int PICK_FROM_FILE = 10002;
    public static final String TAG = "PhotoTaker";
    public int outputX = 300;
    public int outputY = 360;
    public int aspectX = 10;
    public int aspectY = 12;
    public boolean return_data = true;
    public boolean scale = true;
    public boolean faceDetection = true;
    protected String mOutput;
    protected String mTemp;
    protected File mDirectory;
    private Activity mActivity;
    private OnCropFinishListener mOnFinishListener;
    private OnNotFoundCropIntentListener mNotFoundCropIntentListener;
    private Uri mCropUri;
    private MediaUriFinder.MediaScannedListener mScanner = new MediaUriFinder.MediaScannedListener(){

        @Override
        public boolean OnScanned(Uri uri) {
            if (!PhotoTaker.this.doCropImage(uri) && PhotoTaker.this.mNotFoundCropIntentListener != null) {
                PhotoTaker.this.mNotFoundCropIntentListener.OnNotFoundCropIntent(PhotoTaker.this.mDirectory.getAbsolutePath(), PhotoTaker.this.mCropUri);
            }
            return false;
        }
    };

    public PhotoTaker(Activity activity) {
        this(activity, "/sdcard/", "PhotoTaker.jpg");
    }

    public PhotoTaker(Activity activity, String path, String name) {
        this.mActivity = activity;
        this.setOutput(path, name);
    }

    public PhotoTaker(Activity activity, String path, String name, OnCropFinishListener listener) {
        this(activity, path, name);
        this.mOnFinishListener = listener;
    }

    public PhotoTaker(Activity activity, OnCropFinishListener listener) {
        this(activity);
        this.mOnFinishListener = listener;
    }

    public void setOutput(String path, String name) {
        this.mDirectory = this.createDirectory(path);
        this.mOutput = name;
        this.mTemp = TEMP_PREFIX.concat(name);
    }

    public void setOutput(String name) {
        this.mOutput = name;
        this.mTemp = TEMP_PREFIX.concat(name);
    }

    public void setOutputSize(int x, int y) {
        this.outputX = x;
        this.outputY = y;
    }

    public void setOutputSize(int x, int y, int aspectX, int aspectY) {
        this.setOutputSize(x, y);
        this.aspectX = aspectX;
        this.aspectY = aspectY;
    }

    public void setCropfinishListener(OnCropFinishListener listener) {
        this.mOnFinishListener = listener;
    }

    public void setNotFoundCropIntentListener(OnNotFoundCropIntentListener listener) {
        this.mNotFoundCropIntentListener = listener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 10000: {
                    Log.e((String)TAG, (String)"blayzupe IMAGE_CAPTURE");
                    File tempFile = this.getFile(this.mDirectory, this.mTemp);
                    Log.d((String)TAG, (String)("blayzupe tempfile=" + tempFile.getAbsolutePath()));
                    MediaUriFinder.create(this.mActivity, tempFile.getAbsolutePath(), this.mScanner);
                    return;
                }
                case 10002: {
                    Log.e((String)TAG, (String)"blayzupe PICK_IMAGE");
                    Uri dataUri = data.getData();
                    if (dataUri != null) {
                        if (dataUri.getScheme().trim().equalsIgnoreCase("content")) {
                            this.doCropImage(data.getData());
                            return;
                        }
                        if (!dataUri.getScheme().trim().equalsIgnoreCase("file")) return;
                        Log.d((String)TAG, (String)("blayzupe search for Media Content of path=" + dataUri.getPath()));
                        MediaUriFinder.create(this.mActivity, dataUri.getPath(), this.mScanner);
                        return;
                    }
                    Log.e((String)TAG, (String)"blayzupe DATA IS NULL");
                    return;
                }
                case 10001: {
                    File output;
                    Bitmap croppedImg;
                    boolean writed;
                    Log.e((String)TAG, (String)"blayzupe CROP_IMAGE");
                    this.getFile(this.mDirectory, this.mTemp).delete();
                    Bundle extras = data.getExtras();
                    if (extras == null || !(writed = this.writeBitmapToFile(croppedImg = (Bitmap)extras.getParcelable("data"), output = this.getFile(this.mDirectory, this.mOutput))) || this.mOnFinishListener == null) return;
                    this.mOnFinishListener.OnCropFinsh(output.getAbsolutePath(), this.mCropUri);
                    return;
                }
                default: {
                    Log.e((String)TAG, (String)"blayzupe Result some thing");
                }
            }
            return;
        } else {
            Log.e((String)TAG, (String)"blayzupe Result Not OK!!!");
        }
    }

    public boolean doCropImage(Uri uri) {
        try {
            if (uri.getScheme().trim().equalsIgnoreCase("file")) {
                Log.e((String)TAG, (String)"blayzupe doCropImage(Uri) Support only 'Content' Scheme URI");
                return false;
            }
            this.mCropUri = uri;
            Log.w((String)TAG, (String)("blayzupe Start doCropImage(Uri uri) uri=" + uri.toString()));
            Intent intent = new Intent(ACTION_CROP_IMAGE);
            intent.setType("image/*");
            intent.setData(uri);
            List list = this.mActivity.getPackageManager().queryIntentActivities(intent, 0);
            int size = list.size();
            if (size > 0) {
                Log.w((String)TAG, (String)"blayzupe Found Crop Intent");
                intent.putExtra("noFaceDetection", !this.faceDetection);
                intent.putExtra("aspectX", this.aspectX);
                intent.putExtra("aspectY", this.aspectY);
                intent.putExtra("outputX", this.outputX);
                intent.putExtra("outputY", this.outputY);
                intent.putExtra("scale", this.scale);
                intent.putExtra("return-data", this.return_data);
                this.mActivity.startActivityForResult(intent, 10001);
                return true;
            }
            Log.e((String)TAG, (String)"blayzupe doCropImage(Uri) Not Found Support Crop Activity");
            Log.e((String)TAG, (String)("URI : " + uri.toString()));
            this.getFile(this.mDirectory, this.mTemp).delete();
            return false;
        }
        catch (ActivityNotFoundException anfe) {
            Log.e((String)TAG, (String)"blayzupe doCropImage(Uri) Not Found Support Crop Activity");
            anfe.printStackTrace();
            return false;
        }
    }

    public boolean doImageCapture() {
        try {
            File temp = this.getFile(this.mDirectory, this.mTemp);
            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
            intent.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString());
            intent.putExtra("return-data", true);
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)temp));
            this.mActivity.startActivityForResult(intent, 10000);
            return true;
        }
        catch (ActivityNotFoundException anfe) {
            anfe.printStackTrace();
            return false;
        }
    }

    public boolean doPickImage() {
        try {
            Log.d((String)TAG, (String)"blayzupe doPickImage() START");
            Intent intent = new Intent("android.intent.action.GET_CONTENT", null);
            intent.setType("image/*");
            if (this.findCropActivity()) {
                Log.d((String)TAG, (String)"blayzupe doPickImage() Found");
                intent.putExtra("return-data", this.return_data);
                this.mActivity.startActivityForResult(intent, 10002);
            } else {
                Log.d((String)TAG, (String)"blayzupe doPickImage() Not found crop activity");
                intent.putExtra("crop", "true");
                intent.putExtra("noFaceDetection", !this.faceDetection);
                intent.putExtra("aspectX", this.aspectX);
                intent.putExtra("aspectY", this.aspectY);
                intent.putExtra("outputX", this.outputX);
                intent.putExtra("outputY", this.outputY);
                intent.putExtra("scale", this.scale);
                intent.putExtra("return-data", this.return_data);
                this.mActivity.startActivityForResult(intent, 10001);
            }
            return true;
        }
        catch (ActivityNotFoundException anfe) {
            anfe.printStackTrace();
            return false;
        }
    }

    public void doShowDialog() {
        CharSequence[] items = new CharSequence[]{"Take from Camera", "Select from Gallery"};
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mActivity);
        builder.setItems(items, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int item) {
                switch (item) {
                    case 0: {
                        PhotoTaker.this.doImageCapture();
                        break;
                    }
                    case 1: {
                        PhotoTaker.this.doPickImage();
                    }
                }
            }
        });
        AlertDialog alert = builder.create();
        alert.show();
    }

    private boolean findCropActivity() {
        Intent intent = new Intent(ACTION_CROP_IMAGE);
        intent.setType("image/*");
        List list = this.mActivity.getPackageManager().queryIntentActivities(intent, 0);
        return list.size() > 0;
    }

    private File createDirectory(String path) {
        File directory = new File(path);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    private File getFile(File dir, String name) {
        File output = new File(dir, name);
        if (!output.exists()) {
            try {
                output.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    private boolean writeBitmapToFile(Bitmap bitmap, File file) {
        try {
            FileOutputStream fops = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fops);
            fops.flush();
            fops.close();
            fops = null;
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void finalize() throws Throwable {
        this.mActivity = null;
        this.mCropUri = null;
        this.mOnFinishListener = null;
        this.mNotFoundCropIntentListener = null;
        super.finalize();
    }

    public static interface OnNotFoundCropIntentListener {
        public boolean OnNotFoundCropIntent(String var1, Uri var2);
    }

    public static interface OnCropFinishListener {
        public boolean OnCropFinsh(String var1, Uri var2);
    }
}

