/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.phototaker;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ImageResizer {
    public static final String TAG = "ImageResizer";
    protected int outputX = 100;
    protected int outputQuality = 90;

    public ImageResizer(int minLenght) {
        this.outputX = minLenght;
    }

    public ImageResizer() {
        this.outputX = 100;
    }

    public void setQuality(int qPercentage) {
        this.outputQuality = qPercentage > 100 ? 100 : (qPercentage < 0 ? 0 : qPercentage);
    }

    public boolean doResizeImage(File input, File output, boolean deleteInput) {
        if (!input.exists()) {
            return false;
        }
        try {
            float scaleWidth;
            Bitmap bitmap = BitmapFactory.decodeFile((String)input.getAbsolutePath());
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            int least = width < height ? width : height;
            int newWidth = this.outputX;
            float scaleHeight = scaleWidth = (float)newWidth / (float)least;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            resizedBitmap.compress(Bitmap.CompressFormat.JPEG, this.outputQuality, (OutputStream)baos);
            this.intoJPEGfile(baos.toByteArray(), output);
            if (deleteInput) {
                input.delete();
            }
            return true;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Delete temp file cause by can't ResizeImage");
            return false;
        }
    }

    private void intoJPEGfile(byte[] imageData, File output) {
        try {
            if (!output.exists()) {
                output.createNewFile();
            }
            FileOutputStream buf = new FileOutputStream(output);
            buf.write(imageData);
            buf.flush();
            buf.close();
        }
        catch (Exception e) {
            Log.v((String)TAG, (String)"error while write picture to file");
            e.printStackTrace();
        }
    }

    public boolean doResizeImage(File input, File output) {
        return this.doResizeImage(input, output, true);
    }
}

