/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.network;

import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HttpPostTask
extends AsyncTask<Parameter, Response, ArrayList<Response>> {
    public static final String TAG = "PostTask";
    private TaskCallBack mCallback;

    public HttpPostTask(TaskCallBack callback) {
        this.mCallback = callback;
    }

    protected ArrayList<Response> doInBackground(Parameter ... params) {
        Log.e((String)TAG, (String)"POST TASK START");
        ArrayList<Response> resList = new ArrayList<Response>();
        for (Parameter p : params) {
            Response res = new Response();
            try {
                Log.e((String)TAG, (String)"POST TASK START");
                HttpPostTask.post(p.url, p.post, res);
                resList.add(res);
                this.publishProgress(new Response[]{res});
            }
            catch (IOException io) {
                Log.e((String)TAG, (String)"IO error on PostTask", (Throwable)io);
                io.printStackTrace();
                res.status = 10;
                this.publishProgress(new Response[]{res});
            }
        }
        return resList;
    }

    private static String post(String endpoint, Map<String, String> params, Response res) throws IOException {
        String line;
        String message;
        URL url;
        try {
            url = new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid url: " + endpoint);
        }
        StringBuilder bodyBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> param = iterator.next();
            bodyBuilder.append(param.getKey()).append('=').append(param.getValue());
            if (!iterator.hasNext()) continue;
            bodyBuilder.append('&');
        }
        String body = bodyBuilder.toString();
        Log.v((String)TAG, (String)("Posting '" + body + "' to " + url));
        byte[] bytes = body.getBytes();
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        OutputStream out = conn.getOutputStream();
        out.write(bytes);
        out.close();
        int status = conn.getResponseCode();
        res.msg = message = conn.getResponseMessage();
        res.status = status;
        if (status != 200) {
            throw new IOException("Post failed with error code=" + status + ", msg=" + conn.getResponseMessage());
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            if (TextUtils.isEmpty((CharSequence)(line = line.trim()))) continue;
            res.data = !TextUtils.isEmpty((CharSequence)res.data) ? res.data + line : line;
            Log.i((String)TAG, (String)("RES Message: " + line));
        }
        rd.close();
        conn.disconnect();
        res.url = endpoint;
        return line;
    }

    protected void onProgressUpdate(Response ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.mCallback != null) {
            Log.d((String)TAG, (String)"on Progress Update");
            if (values[0].status == 10) {
                this.mCallback.onIOException();
                Log.d((String)TAG, (String)"IOException called");
            } else {
                this.mCallback.onProgressUpdate(values);
            }
        }
    }

    protected void onPostExecute(ArrayList<Response> result) {
        super.onPostExecute(result);
        if (this.mCallback != null) {
            this.mCallback.onPostExecute(result);
        }
    }

    public static class Response {
        public String url;
        public int status = 404;
        public String msg;
        public String data;

        public String toString() {
            return "Response [url=" + this.url + ", status=" + this.status + ", msg=" + this.msg + ", data=" + this.data + "]";
        }
    }

    public static class Parameter {
        public String url;
        public Map<String, String> post = new HashMap<String, String>();

        public void putPost(String key, String value) {
            if (this.post == null) {
                this.post = new HashMap<String, String>();
            }
            this.post.put(key, value);
        }
    }

    public static interface TaskCallBack {
        public void onProgressUpdate(Response ... var1);

        public void onPostExecute(ArrayList<Response> var1);

        public void onIOException();
    }
}

