/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.network;

import android.content.Context;
import android.database.sqlite.SQLiteOpenHelper;
import android.widget.ProgressBar;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;
import th.or.nectec.android.library.network.HttpPostTask;
import th.or.nectec.android.library.util.JSONInsertOrUpdateTask;

public abstract class DataFetcher {
    public static final int FETCH_NOTHING = -1;
    Context mContext;
    ProgressBar mProgressBar;
    SQLiteOpenHelper mOpenHelper;
    OnFetchFinishListener mFinishListener;
    private int mCallingId = -1;
    HttpPostTask.Parameter[] mParams;
    HttpPostTask mPostTask;
    private HttpPostTask.TaskCallBack mPostCallback = new HttpPostTask.TaskCallBack(){

        @Override
        public void onProgressUpdate(HttpPostTask.Response ... values) {
            HttpPostTask.Response res = values[0];
            if (res.status != 200) {
                return;
            }
            try {
                JSONObject response = new JSONObject(res.data);
                if (!response.getString("status").equals("success")) {
                    DataFetcher.this.onStatusFail(DataFetcher.this.mCallingId, response.getString("message"));
                    return;
                }
                final JSONObject returnData = response.optJSONObject("result");
                if (returnData != null) {
                    JSONInsertOrUpdateTask updateTask = new JSONInsertOrUpdateTask(DataFetcher.this.mContext, DataFetcher.this.mOpenHelper, returnData, DataFetcher.this.mProgressBar, new JSONInsertOrUpdateTask.OnFinishListener(){

                        @Override
                        public void onTaskFinish(String result) {
                            boolean conti = returnData.optBoolean("continue");
                            int page = returnData.optInt("page");
                            if (conti) {
                                DataFetcher.this.onFectchNextPage(DataFetcher.this.mCallingId, returnData, page, page + 1);
                                if (DataFetcher.this.mFinishListener != null) {
                                    DataFetcher.this.mFinishListener.onFetchNextPage(DataFetcher.this.mCallingId, returnData, page, page + 1);
                                }
                            } else {
                                DataFetcher.this.onUpdateFinish(DataFetcher.this.mCallingId, result);
                                if (DataFetcher.this.mFinishListener != null) {
                                    DataFetcher.this.mFinishListener.onFetchFinish(DataFetcher.this.mCallingId, returnData, result);
                                }
                            }
                        }
                    });
                    updateTask.execute(new JSONInsertOrUpdateTask.Params[]{DataFetcher.this.getJsonParam(DataFetcher.this.mCallingId)});
                }
            }
            catch (JSONException e) {
                DataFetcher.this.onInvalidJsonFormat(DataFetcher.this.mCallingId, res.data);
                e.printStackTrace();
            }
        }

        @Override
        public void onPostExecute(ArrayList<HttpPostTask.Response> result) {
        }

        @Override
        public void onIOException() {
            DataFetcher.this.onFetchIOException(DataFetcher.this.mCallingId, DataFetcher.this.mPostTask, DataFetcher.this.mParams);
        }
    };

    public DataFetcher(Context context) {
        this.mContext = context;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setOnFetchFinishListener(OnFetchFinishListener mFinishListener) {
        this.mFinishListener = mFinishListener;
    }

    public void setmProgressBar(ProgressBar mProgressBar) {
        this.mProgressBar = mProgressBar;
    }

    public void setmOpenHelper(SQLiteOpenHelper mOpenHelper) {
        this.mOpenHelper = mOpenHelper;
    }

    public int getLastFetchId() {
        return this.mCallingId;
    }

    protected void fetch(int id2, HttpPostTask.Parameter ... params) {
        this.mParams = params;
        this.mPostTask = new HttpPostTask(this.mPostCallback);
        this.mPostTask.execute(params);
        this.mCallingId = id2;
    }

    protected abstract JSONInsertOrUpdateTask.Params getJsonParam(int var1);

    protected void onStatusFail(int id2, String message) {
    }

    protected void onInvalidJsonFormat(int id2, String json) {
    }

    protected void onUpdateFinish(int id2, String result) {
    }

    protected void onFectchNextPage(int id2, JSONObject returnData, int currentPage, int nextPage) {
    }

    protected abstract void onFetchIOException(int var1, HttpPostTask var2, HttpPostTask.Parameter ... var3);

    public static interface OnFetchFinishListener {
        public void onFetchFinish(int var1, JSONObject var2, String var3);

        public void onFetchNextPage(int var1, JSONObject var2, int var3, int var4);
    }
}

