/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.fragment;

import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.GridLayout;
import android.widget.ImageView;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import th.or.nectec.android.library.R;
import th.or.nectec.android.library.phototaker.ImageResizer;

public class ImageTaker
extends Fragment
implements View.OnClickListener,
View.OnLongClickListener {
    public static final String ARGS_MODE = "mode";
    public static final int MODE_EDIT = 0;
    public static final int MODE_VIEW = 1;
    public static final int DEFAULT_ITEM_SIZE = 256;
    private static final int IMAGE_ALPHA = 193;
    public static final String ARGS_LAYOUT_ID = "layout_id";
    public static final String ARGS_ITEM_LAYOUT_ID = "item_id";
    public static final String ARGS_ITEM_IMAGE_ID = "item_img_id";
    public static final String ARGS_ITEM_SIZE = "item_size";
    public static final String ARGS_CONTAINER_ID = "container_id";
    public static final String ARGS_RESTORE_IMAGE = "restore_image";
    public static final String ARGS_ITEM_COLUMN_COUNT = "columns_count";
    private static final int REQUEST_DOC_CAPTURE = 3021;
    protected int mItemColumnCount = 3;
    private int mImageCounter = 1;
    private String shootImageName;
    private ViewGroup mContainer;
    protected int mItemLayout;
    protected int mItemImageId;
    protected int mItemSize = 256;
    private int mMode;
    OnDeleteRequestListener mDeleteListener;
    private ArrayList<String> mImageList = null;
    private ArrayList<String> mAddList = new ArrayList();
    private ArrayList<String> mDeletedList = new ArrayList();
    public static final int THUMB_SIZE = 256;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int layout2 = R.layout.image_taker;
        int containerId = R.id.container;
        Bundle args = this.getArguments();
        if (args != null) {
            layout2 = args.getInt(ARGS_LAYOUT_ID, R.layout.image_taker);
            containerId = args.getInt(ARGS_CONTAINER_ID, R.id.container);
        }
        View v = inflater.inflate(layout2, container, false);
        this.mContainer = (ViewGroup)v.findViewById(containerId);
        return v;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mItemLayout = args.getInt(ARGS_ITEM_LAYOUT_ID, R.layout.image_item);
            this.mItemImageId = args.getInt(ARGS_ITEM_IMAGE_ID, R.id.image);
            this.mItemSize = args.getInt(ARGS_ITEM_SIZE, 256);
            this.mItemColumnCount = args.getInt(ARGS_ITEM_COLUMN_COUNT, this.mItemColumnCount);
        }
        boolean initailed = false;
        if (savedInstanceState != null) {
            this.mImageList = savedInstanceState.getStringArrayList("pic");
            this.mAddList = savedInstanceState.getStringArrayList("add");
            this.mDeletedList = savedInstanceState.getStringArrayList("delete");
            this.shootImageName = savedInstanceState.getString("shootname");
            this.mImageCounter = savedInstanceState.getInt("count", 1);
            initailed = savedInstanceState.getBoolean("initialed");
        }
        if (!initailed) {
            this.mImageList = args.getStringArrayList(ARGS_RESTORE_IMAGE);
        }
        if (this.mImageList == null) {
            this.mImageList = new ArrayList();
        }
        this.addEmptyItem();
        if (this.mImageList.size() > 0) {
            this.restoreImage();
        }
    }

    public void setItemSize(int width) {
        this.mItemSize = width;
        this.getArguments().putInt(ARGS_ITEM_SIZE, width);
        this.mContainer.removeAllViews();
        this.addEmptyItem();
        if (this.mImageList.size() > 0) {
            this.restoreImage();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putStringArrayList("pic", this.mImageList);
        outState.putString("shootname", this.shootImageName);
        outState.putInt("count", this.mImageCounter);
        outState.putBoolean("initialed", true);
        outState.putStringArrayList("add", this.mAddList);
        outState.putStringArrayList("delete", this.mDeletedList);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 3021) {
            if (resultCode == -1) {
                File cache = this.getActivity().getExternalCacheDir();
                File imgi = new File(cache, this.shootImageName);
                if (!imgi.exists()) {
                    this.shootImageName = null;
                    return;
                }
                ImageResizer ir = new ImageResizer(256);
                File sd = new File(cache, "thumb_" + this.shootImageName);
                ir.doResizeImage(imgi, sd, false);
                ImageView img = this.onCreateImageItem(sd.getAbsolutePath(), imgi.getAbsolutePath());
                this.mContainer.addView((View)img, 1, this.onCreateLayoutParam());
                this.mImageList.add(imgi.getAbsolutePath());
                this.mAddList.add(imgi.getAbsolutePath());
            }
        } else {
            this.shootImageName = null;
        }
    }

    protected ImageView onCreateImageItem(String srcPath, String tag) {
        View item = LayoutInflater.from((Context)this.getActivity()).inflate(this.mItemLayout, null);
        ImageView img = (ImageView)item.findViewById(this.mItemImageId);
        if (!TextUtils.isEmpty((CharSequence)srcPath)) {
            img.setImageDrawable(Drawable.createFromPath((String)srcPath));
        }
        img.setTag((Object)tag);
        img.setOnClickListener((View.OnClickListener)this);
        img.setOnLongClickListener((View.OnLongClickListener)this);
        int currentapiVersion = Build.VERSION.SDK_INT;
        if (currentapiVersion >= 16) {
            img.setImageAlpha(193);
        } else {
            img.setAlpha(0.75f);
        }
        return img;
    }

    protected ViewGroup.LayoutParams onCreateLayoutParam() {
        int width;
        int itemSize = this.mItemSize;
        if (this.mContainer instanceof GridLayout && (width = (int)((double)this.mContainer.getMeasuredWidth() * 0.99)) > 0) {
            itemSize = width / this.mItemColumnCount;
        }
        return new ViewGroup.LayoutParams(itemSize, itemSize);
    }

    public void setRestoreImageList(ArrayList<String> restoreList) {
        if (this.mImageList.size() == 0) {
            this.mImageList = new ArrayList<String>(restoreList);
        } else {
            this.mImageList.addAll(this.mImageList.size() - 1, restoreList);
        }
        this.mContainer.removeAllViews();
        this.addEmptyItem();
        if (this.mImageList.size() > 0) {
            this.restoreImage();
        }
    }

    private void restoreImage() {
        int addPostion = this.mContainer.getChildCount() >= 1 ? 1 : 0;
        ViewGroup.LayoutParams itemParam = this.onCreateLayoutParam();
        for (int i = 0; i < this.mImageList.size(); ++i) {
            File file = new File(this.mImageList.get(i));
            String absolutePath = file.getAbsolutePath();
            String filePath = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator));
            File thumb = new File(filePath, "thumb_" + file.getName());
            if (!thumb.exists()) {
                ImageResizer ir = new ImageResizer();
                ir.doResizeImage(file, thumb, false);
            }
            ImageView img = this.onCreateImageItem(thumb.getAbsolutePath(), this.mImageList.get(i));
            this.mContainer.addView((View)img, addPostion, itemParam);
        }
    }

    private void addEmptyItem() {
        this.mMode = this.getArguments().getInt(ARGS_MODE, 0);
        if (this.mMode == 1) {
            return;
        }
        ImageView img = this.onCreateImageItem(null, "new");
        this.mContainer.addView((View)img, this.onCreateLayoutParam());
    }

    public final void onClick(View v) {
        String tag = (String)v.getTag();
        if (!tag.equals("new")) {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            File file = new File(tag);
            intent.setDataAndType(Uri.fromFile((File)file), "image/jpeg");
            this.startActivity(intent);
        } else {
            Date today = new Date();
            SimpleDateFormat f_id = new SimpleDateFormat("yyMMddkkmmssSSS", Locale.US);
            String name = f_id.format(today);
            File image = new File(this.getActivity().getExternalCacheDir(), String.format("imgtaker_%s.jpg", name));
            Intent camera = new Intent("android.media.action.IMAGE_CAPTURE");
            camera.putExtra("output", (Parcelable)Uri.fromFile((File)image));
            camera.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString());
            camera.putExtra("return-data", true);
            this.shootImageName = image.getName();
            this.startActivityForResult(camera, 3021);
        }
    }

    public final boolean onLongClick(View v) {
        String tag = (String)v.getTag();
        if (!tag.equals("new")) {
            int mode = this.getArguments().getInt(ARGS_MODE, 0);
            if (mode == 1) {
                return false;
            }
            if (this.mDeleteListener != null && this.mDeleteListener.onDeleteRequest(v, tag)) {
                return true;
            }
            this.removeItem(v, tag);
            return true;
        }
        return false;
    }

    public void setOnDeleteRequestListener(OnDeleteRequestListener listener) {
        this.mDeleteListener = listener;
    }

    public void removeItem(View v, String path) {
        this.mContainer.removeView(v);
        this.mImageList.remove(path);
        if (!this.mAddList.remove(path)) {
            Log.d((String)"dd", (String)("removed path=" + path));
            this.mDeletedList.add(path);
        } else {
            File f = new File(path);
            f.delete();
        }
    }

    public ArrayList<String> getImageList() {
        return this.mImageList;
    }

    public ArrayList<String> getAddedImageList() {
        return this.mAddList;
    }

    public ArrayList<String> getDeleteImageList() {
        return this.mDeletedList;
    }

    public static ImageTaker getNewInstance(int imageItemLayout, int imageItemId, ArrayList<String> restoreFileName, int mode) {
        Bundle args = new Bundle();
        args.putInt(ARGS_LAYOUT_ID, R.layout.image_taker);
        args.putInt(ARGS_CONTAINER_ID, R.id.container);
        args.putInt(ARGS_ITEM_LAYOUT_ID, imageItemLayout);
        args.putInt(ARGS_ITEM_IMAGE_ID, imageItemId);
        args.putStringArrayList(ARGS_RESTORE_IMAGE, restoreFileName);
        args.putInt(ARGS_MODE, mode);
        ImageTaker it = new ImageTaker();
        it.setArguments(args);
        return it;
    }

    public static ImageTaker getNewInstance(int imageItemLayout, int imageItemId, ArrayList<String> restoreFileName) {
        return ImageTaker.getNewInstance(imageItemLayout, imageItemId, restoreFileName, 0);
    }

    public static ImageTaker getNewInstance(int imageItemLayout, int imageItemId) {
        return ImageTaker.getNewInstance(imageItemLayout, imageItemId, null);
    }

    public static ImageTaker getNewInstance(ArrayList<String> restoreFileName) {
        restoreFileName = restoreFileName == null ? new ArrayList<String>() : restoreFileName;
        return ImageTaker.getNewInstance(R.layout.image_item, R.id.image, restoreFileName);
    }

    public static ImageTaker getNewInstanceViewMode(ArrayList<String> restoreFileName) {
        restoreFileName = restoreFileName == null ? new ArrayList<String>() : restoreFileName;
        return ImageTaker.getNewInstance(R.layout.image_item, R.id.image, restoreFileName, 1);
    }

    public static interface OnDeleteRequestListener {
        public boolean onDeleteRequest(View var1, String var2);
    }
}

