/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.form.validator;

import android.text.TextUtils;
import th.or.nectec.android.library.form.validator.AbstractValidator;
import th.or.nectec.android.library.form.validator.ValidatorException;

public class NumbericCompareValidator
extends AbstractValidator {
    public static final int EQUAL = 0;
    public static final int LESS_THAN = 1;
    public static final int LESS_THAN_EQUAL = 2;
    public static final int GREATER_THAN = 3;
    public static final int GREATER_THAN_EQUAL = 4;
    public static final int NOT_EQUAL = 5;
    int mCompareMode;
    Double mValue1;
    Double mCompareValue;
    String mErrMessage;

    public NumbericCompareValidator(int mode, Double compareValue) {
        this(mode, compareValue, null);
    }

    public NumbericCompareValidator(int mode, Double compareValue, String errorMessage) {
        super(null);
        this.mCompareMode = mode;
        this.mCompareValue = compareValue;
        this.mErrMessage = errorMessage;
    }

    public NumbericCompareValidator(int mode, int compareValue, String errorMessage) {
        this(mode, Double.valueOf(compareValue), errorMessage);
    }

    @Override
    public boolean isValid(String value) throws ValidatorException {
        double val = Double.valueOf(value);
        switch (this.mCompareMode) {
            case 0: {
                return val == this.mCompareValue;
            }
            case 1: {
                return val < this.mCompareValue;
            }
            case 2: {
                return val <= this.mCompareValue;
            }
            case 3: {
                return val > this.mCompareValue;
            }
            case 4: {
                return val >= this.mCompareValue;
            }
            case 5: {
                return val != this.mCompareValue;
            }
        }
        return true;
    }

    @Override
    public String getMessage() {
        if (!TextUtils.isEmpty((CharSequence)this.mErrMessage)) {
            return this.mErrMessage;
        }
        switch (this.mCompareMode) {
            case 0: {
                return "\u0e04\u0e48\u0e32\u0e17\u0e35\u0e48\u0e40\u0e1b\u0e23\u0e35\u0e22\u0e1a\u0e40\u0e17\u0e35\u0e22\u0e1a\u0e15\u0e49\u0e2d\u0e07\u0e40\u0e17\u0e48\u0e32\u0e01\u0e31\u0e1a " + this.mCompareValue;
            }
            case 1: {
                return "\u0e04\u0e48\u0e32\u0e17\u0e35\u0e48\u0e40\u0e1b\u0e23\u0e35\u0e22\u0e1a\u0e40\u0e17\u0e35\u0e22\u0e1a\u0e15\u0e49\u0e2d\u0e07\u0e19\u0e49\u0e2d\u0e22\u0e01\u0e27\u0e48\u0e32 " + this.mCompareValue;
            }
            case 2: {
                return "\u0e04\u0e48\u0e32\u0e17\u0e35\u0e48\u0e40\u0e1b\u0e23\u0e35\u0e22\u0e1a\u0e40\u0e17\u0e35\u0e22\u0e1a\u0e15\u0e49\u0e2d\u0e07\u0e19\u0e49\u0e2d\u0e22\u0e01\u0e27\u0e48\u0e32\u0e2b\u0e23\u0e37\u0e2d\u0e40\u0e17\u0e48\u0e32\u0e01\u0e31\u0e1a " + this.mCompareValue;
            }
            case 3: {
                return "\u0e04\u0e48\u0e32\u0e17\u0e35\u0e48\u0e40\u0e1b\u0e23\u0e35\u0e22\u0e1a\u0e40\u0e17\u0e35\u0e22\u0e1a\u0e15\u0e49\u0e2d\u0e07\u0e21\u0e32\u0e01\u0e01\u0e27\u0e48\u0e32 " + this.mCompareValue;
            }
            case 4: {
                return "\u0e04\u0e48\u0e32\u0e17\u0e35\u0e48\u0e40\u0e1b\u0e23\u0e35\u0e22\u0e1a\u0e40\u0e17\u0e35\u0e22\u0e1a\u0e15\u0e49\u0e2d\u0e07\u0e21\u0e32\u0e01\u0e01\u0e27\u0e48\u0e32\u0e2b\u0e23\u0e37\u0e2d\u0e40\u0e17\u0e48\u0e32\u0e01\u0e31\u0e1a " + this.mCompareValue;
            }
            case 5: {
                return "\u0e04\u0e48\u0e32\u0e17\u0e35\u0e48\u0e40\u0e1b\u0e23\u0e35\u0e22\u0e1a\u0e40\u0e17\u0e35\u0e22\u0e1a\u0e15\u0e49\u0e2d\u0e07\u0e44\u0e21\u0e48\u0e40\u0e17\u0e48\u0e32\u0e01\u0e31\u0e1a " + this.mCompareValue;
            }
        }
        return "\u0e44\u0e21\u0e48\u0e17\u0e23\u0e32\u0e1a";
    }
}

