/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.form.generate;

import android.database.Cursor;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import th.or.nectec.android.library.form.generate.Value;
import th.or.nectec.android.library.util.CursorHelper;

public class Field {
    String column;
    String[] columns;
    long id;
    Value[] values;
    String defualtValue;
    String type;
    String label;
    Boolean mandatory;
    HashMap<String, String> option;

    public String getColumnName() {
        return this.column;
    }

    public String[] getColumnsName() {
        return this.columns;
    }

    public Value[] getValues() {
        return this.values;
    }

    public String getDefualtValue() {
        return this.defualtValue;
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public HashMap<String, String> getOption() {
        return this.option;
    }

    public Boolean isMandatory() {
        return this.mandatory;
    }

    public Boolean isMultiColumn() {
        if (this.columns != null && this.columns.length > 1) {
            return true;
        }
        return false;
    }

    public static Field createByCursor(Cursor c) {
        String columns;
        int colsIndex;
        Field f = new Field();
        f.id = CursorHelper.getLong(c, "id");
        int colIndex = c.getColumnIndex("column");
        if (colIndex >= 0) {
            f.column = CursorHelper.getString(c, "column");
        }
        if ((colsIndex = c.getColumnIndex("columns")) >= 0 && !TextUtils.isEmpty((CharSequence)(columns = CursorHelper.getString(c, "columns")))) {
            try {
                JSONArray columnsJSON = new JSONArray(columns);
                f.columns = new String[columnsJSON.length()];
                for (int i = 0; i < columnsJSON.length(); ++i) {
                    f.columns[i] = columnsJSON.optString(i);
                }
            }
            catch (JSONException jex) {
                jex.toString();
            }
        }
        if (f.column == null && f.columns == null) {
            f.column = String.valueOf(f.id);
        }
        f.type = CursorHelper.getString(c, "type");
        f.label = CursorHelper.getString(c, "label");
        f.mandatory = CursorHelper.getString(c, "mandatory").equals("yes");
        String value = c.getString(c.getColumnIndex("value"));
        if (!TextUtils.isEmpty((CharSequence)value)) {
            f.values = Value.parseValueArray(value);
        }
        return f;
    }

    private static HashMap<String, String> parseHashMap(JSONObject json) {
        HashMap<String, String> hash = new HashMap<String, String>();
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                hash.put(key, json.getString(key));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return hash;
    }

    private static HashMap<String, String> parseHashMap(String json) {
        try {
            return Field.parseHashMap(new JSONObject(json));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

