/*
 * Decompiled with CFR 0.152.
 */
package th.co.sic.module.nfc.sic43nt;

import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.util.Log;
import th.co.sic.module.nfc.SicChip;
import th.co.sic.module.nfc.cmds.Eeprom;
import th.co.sic.module.nfc.sic43nt.UserConfiguration;
import th.co.sic.module.utils.PackageUtils;

public class Sic43nt
extends SicChip {
    private static final String TAG = Sic43nt.class.getSimpleName();
    private static Sic43nt instance;
    private UserConfiguration mUserConfiguration;

    public static Sic43nt getInstance() {
        if (instance == null) {
            instance = new Sic43nt();
        }
        return instance;
    }

    protected void setPeripheral() {
        this.mUserConfiguration = UserConfiguration.getInstance(this);
    }

    public boolean checkedUid() {
        byte[] uid = this.mNfcA.getTag().getId();
        return uid != null && uid.length >= 4 && uid[1] == 73;
    }

    public NdefRecord[] readNdefRecord() {
        if (this.mNdef == null || this.mNdef.getCachedNdefMessage() == null) {
            return null;
        }
        return this.mNdef.getCachedNdefMessage().getRecords();
    }

    public UserConfiguration config() {
        return this.mUserConfiguration;
    }

    public byte[] readTamper() {
        return this.autoTransceive(new byte[]{-81, 0});
    }

    public boolean write(NdefRecord record) {
        NdefMessage message = new NdefMessage(record, new NdefRecord[0]);
        int size = message.toByteArray().length;
        try {
            if (this.mNdef != null) {
                if (this.mNfcA.isConnected()) {
                    this.mNfcA.close();
                }
                if (!this.mNdef.isWritable()) {
                    Log.i((String)TAG, (String)"NDEF is not writable");
                    return false;
                }
                if (this.mNdef.getMaxSize() < size) {
                    Log.i((String)TAG, (String)"size is mismatch");
                    return false;
                }
                if (!this.mNdef.isConnected()) {
                    this.mNdef.connect();
                }
                this.mNdef.writeNdefMessage(message);
                this.mNdef.close();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public boolean directlyWrite(NdefRecord record) {
        NdefMessage message = new NdefMessage(record, new NdefRecord[0]);
        int size = message.toByteArray().length;
        byte[] data = PackageUtils.getInstance().concat((byte[][])new byte[][]{{3, (byte)size}, message.toByteArray(), {-2, 0, 0, 0}});
        try {
            if (!this.mNdef.isConnected()) {
                this.mNdef.close();
            }
            size = data.length / 4;
            byte[][] chunk = new byte[size][];
            size = chunk.length;
            for (int i = 0; i < size; ++i) {
                byte[] tmp = new byte[4];
                System.arraycopy(data, i * 4, tmp, 0, 4);
                chunk[i] = Eeprom.getPackage_Write((int)(i + 4), (byte[])tmp);
            }
            this.setTimeout(3000);
            byte[] re = this.autoTransceive(chunk);
            return re != null && this.isSendCompleted();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

