/*
 * Decompiled with CFR 0.152.
 */
package th.co.sic.module.nfc.sic4310;

import th.co.sic.module.nfc.SicChip;
import th.co.sic.module.nfc.providers.GpioProvider;
import th.co.sic.module.nfc.sic4310.Sic4310;

public class Gpio
extends GpioProvider {
    public static final int Direction_Input = 0;
    public static final int Direction_Output = 1;
    public static final int NoPull = 0;
    public static final int PullUp = 1;
    public static final int Mode_Gpio = 0;
    public static final int Mode_Functional = 1;
    private static final String TAG = Gpio.class.getName();
    public static int Pin_UART_CTS;
    public static int Pin_UART_TXD;
    public static int Pin_UART_RXD;
    public static int Pin_UART_RTS;
    private static Gpio instance;

    private Gpio(Sic4310 sic4310) {
        super((SicChip)sic4310);
    }

    public static Gpio getInstance(Sic4310 sic4310) {
        if (instance == null) {
            instance = new Gpio(sic4310);
        }
        return instance;
    }

    protected void setRegisterAddress() {
        GpioProvider.ADDRESS_GPIO_MODE_0 = (byte)8;
        GpioProvider.ADDRESS_GPIO_MODE_1 = (byte)9;
        GpioProvider.ADDRESS_GPIO_OUT = (byte)10;
        GpioProvider.ADDRESS_GPIO_IN = (byte)11;
        GpioProvider.ADDRESS_GPIO_MODE_2 = (byte)12;
    }

    protected void setDefaultBit() {
        Pin_UART_CTS = GpioProvider.Pin_0;
        Pin_UART_TXD = GpioProvider.Pin_1;
        Pin_UART_RXD = GpioProvider.Pin_2;
        Pin_UART_RTS = GpioProvider.Pin_3;
        GpioProvider.Pin_Power_Ready = GpioProvider.Pin_4;
        GpioProvider.Pin_RF_Busy = GpioProvider.Pin_5;
        GpioProvider.Pin_RF_Detected = GpioProvider.Pin_6;
    }

    @Deprecated
    public Byte getMode(int number) {
        return super.getMode(1);
    }

    @Deprecated
    public void setMode(int number, int GPIO_Mode) {
        super.setMode(1, GPIO_Mode);
    }

    @Deprecated
    public void setModeBit(int number, int GPIO_Pin, int GPIO_Mode) {
        super.setModeBit(1, GPIO_Pin, GPIO_Mode);
    }

    public byte getDirection() {
        return super.getMode(0);
    }

    public void setDirection(int GPIO_Direction) {
        super.setMode(0, GPIO_Direction);
    }

    public void setDirectionBit(int GPIO_Pin, int GPIO_Direction) {
        super.setModeBit(0, GPIO_Pin, GPIO_Direction);
    }

    public Byte getMode() {
        return super.getMode(1);
    }

    public void setMode(int GPIO_Mode) {
        super.setMode(1, GPIO_Mode);
    }

    public void setModeBit(int GPIO_Pin, int GPIO_Mode) {
        super.setModeBit(1, GPIO_Pin, GPIO_Mode);
    }

    public Byte getPullUp() {
        return super.getMode(2);
    }

    public void setPullUp(int GPIO_PullUp) {
        super.setMode(2, GPIO_PullUp);
    }

    public void setBitPullup(int GPIO_Pin, int GPIO_PullUp) {
        super.setModeBit(2, GPIO_Pin, GPIO_PullUp);
    }

    public void setGPIOModeInputDirection(int GPIO_Pin) {
        byte direction = (byte)(this.mRegister.readBuffer((int)GpioProvider.ADDRESS_GPIO_MODE_0) & ~GPIO_Pin);
        byte mode = (byte)(this.mRegister.readBuffer((int)GpioProvider.ADDRESS_GPIO_MODE_1) & ~GPIO_Pin);
        this.mRegister.write((byte[][])new byte[][]{{GpioProvider.ADDRESS_GPIO_MODE_0, direction}, {GpioProvider.ADDRESS_GPIO_MODE_1, mode}});
    }

    public void setGPIOModeOutputDirection(int GPIO_Pin) {
        byte direction = (byte)(this.mRegister.readBuffer((int)GpioProvider.ADDRESS_GPIO_MODE_0) | GPIO_Pin);
        byte mode = (byte)(this.mRegister.readBuffer((int)GpioProvider.ADDRESS_GPIO_MODE_1) & ~GPIO_Pin);
        this.mRegister.write((byte[][])new byte[][]{{GpioProvider.ADDRESS_GPIO_MODE_0, direction}, {GpioProvider.ADDRESS_GPIO_MODE_1, mode}});
    }

    public void setFunctionModeInputDirection(int GPIO_Pin) {
        byte direction = (byte)(this.mRegister.readBuffer((int)GpioProvider.ADDRESS_GPIO_MODE_0) & ~GPIO_Pin);
        byte mode = (byte)(this.mRegister.readBuffer((int)GpioProvider.ADDRESS_GPIO_MODE_1) | GPIO_Pin);
        this.mRegister.write((byte[][])new byte[][]{{GpioProvider.ADDRESS_GPIO_MODE_0, direction}, {GpioProvider.ADDRESS_GPIO_MODE_1, mode}});
    }

    public void setFunctionModeOutputDirection(int GPIO_Pin) {
        byte direction = (byte)(this.mRegister.readBuffer((int)GpioProvider.ADDRESS_GPIO_MODE_0) | GPIO_Pin);
        byte mode = (byte)(this.mRegister.readBuffer((int)GpioProvider.ADDRESS_GPIO_MODE_1) | GPIO_Pin);
        this.mRegister.write((byte[][])new byte[][]{{GpioProvider.ADDRESS_GPIO_MODE_0, direction}, {GpioProvider.ADDRESS_GPIO_MODE_1, mode}});
    }
}

