/*
 * Decompiled with CFR 0.152.
 */
package th.co.sic.module.nfc.sic4310;

import th.co.sic.module.nfc.SicChip;
import th.co.sic.module.nfc.providers.RegisterProvider;

public class Register
extends RegisterProvider {
    public static final int REGISTER_PAGE = 16;
    public static final byte UART_STATUS = 0;
    public static final byte POWER_STATUS = 1;
    public static final byte TRXRU_RESPONSE_TIME = 3;
    public static final byte UART_BYTE_CONFIGURATION = 4;
    public static final byte UART_DIVISOR_M = 5;
    public static final byte UART_DIVISOR_N = 6;
    public static final byte OSC_TUNING = 7;
    public static final byte GPIO_DIRECTION = 8;
    public static final byte GPIO_MODE = 9;
    public static final byte GPIO_OUT = 10;
    public static final byte GPIO_IN = 11;
    public static final byte GPIO_PU = 12;
    public static final byte PERIPHERAL_CONFIG = 13;
    public static final byte PERIPHERAL_ADJUSTMENT = 14;
    private static final String TAG = Register.class.getSimpleName();
    private static Register instance;

    private Register(SicChip chip) {
        super(chip);
    }

    public static Register getInstance(SicChip chip) {
        if (instance == null) {
            instance = new Register(chip);
        }
        return instance;
    }

    public static String getName(int address) {
        switch (address) {
            case 0: {
                return "UartProvider StatusProvider";
            }
            case 1: {
                return "Power StatusProvider";
            }
            case 3: {
                return "TRxRU Response Time";
            }
            case 4: {
                return "UartProvider Byte Configuration";
            }
            case 5: {
                return "UartProvider Divisor M";
            }
            case 6: {
                return "UartProvider Divisor N";
            }
            case 7: {
                return "OSC Tuning";
            }
            case 8: {
                return "GpioProvider Direction";
            }
            case 9: {
                return "GpioProvider Mode";
            }
            case 10: {
                return "GpioProvider Output";
            }
            case 11: {
                return "GpioProvider Input";
            }
            case 12: {
                return "GpioProvider Pull-up";
            }
            case 13: {
                return "Provider Config";
            }
            case 14: {
                return "Provider Adjustment";
            }
        }
        return "RFU";
    }

    public static RegisterProvider.RegisterType getRegisterType(int address) {
        switch (address) {
            case 0: 
            case 1: 
            case 11: {
                return RegisterProvider.RegisterType.READ_ONLY_STATUS;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                return RegisterProvider.RegisterType.READ_WRITE_CONFIG;
            }
            case 7: {
                return RegisterProvider.RegisterType.READ_WRITE;
            }
        }
        return RegisterProvider.RegisterType.RFU;
    }

    protected int getRegisterPage() {
        return 16;
    }
}

