/*
 * Decompiled with CFR 0.152.
 */
package th.co.geniustree.springdata.jpa.repository.support;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.ManyToOne;
import javax.persistence.NoResultException;
import javax.persistence.OneToOne;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.repository.query.MyResultProcessor;
import org.springframework.data.repository.query.ReturnTypeWarpper;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.TupleConverter;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import th.co.geniustree.springdata.jpa.repository.JpaSpecificationExecutorWithProjection;
import th.co.geniustree.springdata.jpa.repository.support.DefaultQueryHints;
import th.co.geniustree.springdata.jpa.repository.support.QueryHints;

public class JpaSpecificationExecutorWithProjectionImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements JpaSpecificationExecutorWithProjection<T, ID> {
    private static final Logger log = LoggerFactory.getLogger(JpaSpecificationExecutorWithProjectionImpl.class);
    private static final Map<Attribute.PersistentAttributeType, Class<? extends Annotation>> ASSOCIATION_TYPES;
    private final EntityManager entityManager;
    private final ProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
    private final JpaEntityInformation entityInformation;

    public JpaSpecificationExecutorWithProjectionImpl(JpaEntityInformation entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
        this.entityInformation = entityInformation;
    }

    @Override
    public <R> Optional<R> findById(ID id, Class<R> projectionType) {
        ArrayList<Selection> selections;
        ReturnedType returnedType = ReturnTypeWarpper.of(projectionType, this.getDomainClass(), this.projectionFactory);
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery q = builder.createQuery(Tuple.class);
        Root root = q.from(this.getDomainClass());
        q.where((Expression)builder.equal((Expression)root.get(this.entityInformation.getIdAttribute()), id));
        if (returnedType.needsCustomConstruction()) {
            selections = new ArrayList<Selection>();
            for (String property : returnedType.getInputProperties()) {
                PropertyPath path = PropertyPath.from((String)property, (Class)returnedType.getReturnedType());
                selections.add(JpaSpecificationExecutorWithProjectionImpl.toExpressionRecursively(root, path, true).alias(property));
            }
        } else {
            throw new IllegalArgumentException("only except projection");
        }
        q.multiselect(selections);
        TypedQuery query = this.applyRepositoryMethodMetadata(this.entityManager.createQuery(q));
        try {
            MyResultProcessor resultProcessor = new MyResultProcessor(this.projectionFactory, returnedType);
            Object singleResult = resultProcessor.processResult(query.getSingleResult(), new TupleConverter(returnedType));
            return Optional.ofNullable(singleResult);
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    @Override
    public <R> Optional<R> findOne(Specification<T> spec, Class<R> projectionType) {
        ReturnedType returnedType = ReturnTypeWarpper.of(projectionType, this.getDomainClass(), this.projectionFactory);
        TypedQuery<Tuple> query = this.getTupleQuery(spec, Sort.unsorted(), returnedType);
        try {
            MyResultProcessor resultProcessor = new MyResultProcessor(this.projectionFactory, returnedType);
            Object singleResult = resultProcessor.processResult(query.getSingleResult(), new TupleConverter(returnedType));
            return Optional.ofNullable(singleResult);
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    @Override
    public <R> Page<R> findAll(Specification<T> spec, Class<R> projectionType, Pageable pageable) {
        ReturnedType returnedType = ReturnTypeWarpper.of(projectionType, this.getDomainClass(), this.projectionFactory);
        TypedQuery<Tuple> query = this.getTupleQuery(spec, pageable.getSort() != null && pageable.getSort().isSorted() ? pageable.getSort() : Sort.unsorted(), returnedType);
        MyResultProcessor resultProcessor = new MyResultProcessor(this.projectionFactory, returnedType);
        if (pageable.isPaged()) {
            query.setFirstResult((int)pageable.getOffset());
            query.setMaxResults(pageable.getPageSize());
        }
        List resultList = (List)resultProcessor.processResult(query.getResultList(), new TupleConverter(returnedType));
        Page page = PageableExecutionUtils.getPage((List)resultList, (Pageable)pageable, () -> JpaSpecificationExecutorWithProjectionImpl.executeCountQuery((TypedQuery<Long>)this.getCountQuery(spec, this.getDomainClass())));
        return pageable.isUnpaged() ? new PageImpl(resultList) : page;
    }

    static Long executeCountQuery(TypedQuery<Long> query) {
        Assert.notNull(query, (String)"TypedQuery must not be null!");
        List totals = query.getResultList();
        Long total = 0L;
        for (Long element : totals) {
            total = total + (element == null ? 0L : element);
        }
        return total;
    }

    @Override
    public <R> Page<R> findAll(Specification<T> spec, Class<R> projectionType, String namedEntityGraph, EntityGraph.EntityGraphType type, Pageable pageable) {
        return this.findAll(spec, projectionType, pageable);
    }

    @Override
    public <R> Page<R> findAll(Specification<T> spec, Class<R> projectionType, JpaEntityGraph dynamicEntityGraph, Pageable pageable) {
        return this.findAll(spec, projectionType, pageable);
    }

    protected TypedQuery<Tuple> getTupleQuery(@Nullable Specification spec, Sort sort, ReturnedType returnedType) {
        ArrayList<Selection> selections;
        if (!returnedType.needsCustomConstruction()) {
            return this.getQuery(spec, sort);
        }
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Tuple.class);
        Root root = this.applySpecificationToCriteria(spec, this.getDomainClass(), query, builder);
        if (returnedType.needsCustomConstruction()) {
            selections = new ArrayList<Selection>();
            for (String property : returnedType.getInputProperties()) {
                PropertyPath path = PropertyPath.from((String)property, (Class)returnedType.getReturnedType());
                selections.add(JpaSpecificationExecutorWithProjectionImpl.toExpressionRecursively(root, path, true).alias(property));
            }
        } else {
            throw new IllegalArgumentException("only except projection");
        }
        query.multiselect(selections);
        if (sort.isSorted()) {
            query.orderBy(QueryUtils.toOrders((Sort)sort, root, (CriteriaBuilder)builder));
        }
        return this.applyRepositoryMethodMetadata(this.entityManager.createQuery(query));
    }

    private <S, U extends T> Root<U> applySpecificationToCriteria(@Nullable Specification<U> spec, Class<U> domainClass, CriteriaQuery<S> query, CriteriaBuilder builder) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        Assert.notNull(query, (String)"CriteriaQuery must not be null!");
        Root root = query.from(domainClass);
        if (spec == null) {
            return root;
        }
        Predicate predicate = spec.toPredicate(root, query, builder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        return root;
    }

    private <S> TypedQuery<S> applyRepositoryMethodMetadata(TypedQuery<S> query) {
        if (this.getRepositoryMethodMetadata() == null) {
            return query;
        }
        LockModeType type = this.getRepositoryMethodMetadata().getLockModeType();
        TypedQuery toReturn = type == null ? query : query.setLockMode(type);
        this.applyQueryHints((Query)toReturn);
        return toReturn;
    }

    private void applyQueryHints(Query query) {
        QueryHints queryHints = DefaultQueryHints.of(this.entityInformation, this.getRepositoryMethodMetadata());
        if (queryHints == null) {
            queryHints = QueryHints.NoHints.INSTANCE;
        }
        for (Map.Entry hint : queryHints.withFetchGraphs(this.entityManager)) {
            query.setHint((String)hint.getKey(), hint.getValue());
        }
    }

    static Expression<Object> toExpressionRecursively(Path<Object> path, PropertyPath property) {
        Expression<Object> result = path.get(property.getSegment());
        return property.hasNext() ? JpaSpecificationExecutorWithProjectionImpl.toExpressionRecursively((Path<Object>)result, property.next()) : result;
    }

    static <T> Expression<T> toExpressionRecursively(From<?, ?> from, PropertyPath property, boolean isForSelection) {
        Bindable model = from.getModel();
        String segment = property.getSegment();
        Bindable propertyPathModel = model instanceof ManagedType ? (Bindable)((ManagedType)model).getAttribute(segment) : from.get(segment).getModel();
        if (JpaSpecificationExecutorWithProjectionImpl.requiresJoin(propertyPathModel, model instanceof PluralAttribute, !property.hasNext(), isForSelection) && !JpaSpecificationExecutorWithProjectionImpl.isAlreadyFetched(from, segment)) {
            Join<?, ?> join = JpaSpecificationExecutorWithProjectionImpl.getOrCreateJoin(from, segment);
            return property.hasNext() ? JpaSpecificationExecutorWithProjectionImpl.toExpressionRecursively(join, property.next(), isForSelection) : join;
        }
        Expression<Object> path = from.get(segment);
        return property.hasNext() ? JpaSpecificationExecutorWithProjectionImpl.toExpressionRecursively((Path<Object>)path, property.next()) : path;
    }

    private static boolean requiresJoin(@Nullable Bindable<?> propertyPathModel, boolean isPluralAttribute, boolean isLeafProperty, boolean isForSelection) {
        if (propertyPathModel == null && isPluralAttribute) {
            return true;
        }
        if (!(propertyPathModel instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)propertyPathModel;
        if (!ASSOCIATION_TYPES.containsKey(attribute.getPersistentAttributeType())) {
            return false;
        }
        if (isLeafProperty && !isForSelection && !attribute.isCollection()) {
            return false;
        }
        Class<? extends Annotation> associationAnnotation = ASSOCIATION_TYPES.get(attribute.getPersistentAttributeType());
        if (associationAnnotation == null) {
            return true;
        }
        Member member = attribute.getJavaMember();
        if (!(member instanceof AnnotatedElement)) {
            return true;
        }
        Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)((AnnotatedElement)((Object)member)), associationAnnotation);
        return annotation == null ? true : (Boolean)AnnotationUtils.getValue((Annotation)annotation, (String)"optional");
    }

    private static Join<?, ?> getOrCreateJoin(From<?, ?> from, String attribute) {
        for (Join join : from.getJoins()) {
            boolean sameName = join.getAttribute().getName().equals(attribute);
            if (!sameName || !join.getJoinType().equals((Object)JoinType.LEFT)) continue;
            return join;
        }
        return from.join(attribute, JoinType.LEFT);
    }

    private static boolean isAlreadyFetched(From<?, ?> from, String attribute) {
        for (Fetch fetch : from.getFetches()) {
            boolean sameName = fetch.getAttribute().getName().equals(attribute);
            if (!sameName || !fetch.getJoinType().equals((Object)JoinType.LEFT)) continue;
            return true;
        }
        return false;
    }

    static {
        HashMap<Attribute.PersistentAttributeType, Class> persistentAttributeTypes = new HashMap<Attribute.PersistentAttributeType, Class>();
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ONE_TO_ONE, OneToOne.class);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ONE_TO_MANY, null);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.MANY_TO_ONE, ManyToOne.class);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.MANY_TO_MANY, null);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ELEMENT_COLLECTION, null);
        ASSOCIATION_TYPES = Collections.unmodifiableMap(persistentAttributeTypes);
    }
}

