/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class TupleConverter
implements Converter<Object, Object> {
    private final ReturnedType type;

    public TupleConverter(ReturnedType type) {
        Assert.notNull((Object)type, (String)"Returned type must not be null!");
        this.type = type;
    }

    public Object convert(Object source) {
        Object value;
        if (!(source instanceof Tuple)) {
            return source;
        }
        Tuple tuple = (Tuple)source;
        List elements = tuple.getElements();
        if (elements.size() == 1 && (this.type.isInstance(value = tuple.get((TupleElement)elements.get(0))) || value == null)) {
            return value;
        }
        return new TupleBackedMap(tuple);
    }

    private static class TupleBackedMap
    implements Map<String, Object> {
        private static final String UNMODIFIABLE_MESSAGE = "A TupleBackedMap cannot be modified.";
        private final Tuple tuple;

        TupleBackedMap(Tuple tuple) {
            this.tuple = tuple;
        }

        @Override
        public int size() {
            return this.tuple.getElements().size();
        }

        @Override
        public boolean isEmpty() {
            return this.tuple.getElements().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            try {
                this.tuple.get((String)key);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        @Override
        public boolean containsValue(Object value) {
            return Arrays.asList(this.tuple.toArray()).contains(value);
        }

        @Override
        @Nullable
        public Object get(Object key) {
            if (!(key instanceof String)) {
                return null;
            }
            try {
                return this.tuple.get((String)key);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
        }

        @Override
        public Set<String> keySet() {
            return this.tuple.getElements().stream().map(TupleElement::getAlias).collect(Collectors.toSet());
        }

        @Override
        public Collection<Object> values() {
            return Arrays.asList(this.tuple.toArray());
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.tuple.getElements().stream().map(e -> new AbstractMap.SimpleEntry<String, Object>(e.getAlias(), this.tuple.get(e))).collect(Collectors.toSet());
        }
    }
}

