/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.auth;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIKeyClient;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.auth.BitbarCredentials;
import com.testdroid.jenkins.auth.IBitbarCredentials;
import com.testdroid.jenkins.remotesupport.MachineIndependentTask;
import com.testdroid.jenkins.utils.ApiClientAdapter;
import com.testdroid.jenkins.utils.BitbarCredentialsUtils;
import hudson.Extension;
import hudson.util.Secret;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;

@Extension
public class TestdroidApiUtil {
    private static ApiClientAdapter apiClientAdapter;

    public static ApiClientAdapter getGlobalApiClient() {
        if (apiClientAdapter == null) {
            TestdroidApiUtil.refreshApiClient(new TestdroidCloudSettings.DescriptorImpl());
        }
        return apiClientAdapter;
    }

    public static void refreshApiClient(TestdroidCloudSettings.DescriptorImpl settings) {
        apiClientAdapter = TestdroidApiUtil.createApiClientAdapter(settings);
    }

    public static ApiClientAdapter createApiClientAdapter(TestdroidCloudSettings.DescriptorImpl settings) {
        return TestdroidApiUtil.createApiClientAdapter(settings.getCloudUrl(), settings.getCredentialsId(), settings.getNoCheckCertificate(), settings.getIsProxy(), settings.getProxyHost(), settings.getProxyPort(), settings.getProxyUser(), settings.getProxyPassword(), null);
    }

    public static ApiClientAdapter createApiClientAdapter(MachineIndependentTask mit) {
        return TestdroidApiUtil.createApiClientAdapter(mit.cloudUrl, mit.credentialsId, mit.noCheckCertificate, mit.isProxy, mit.proxyHost, mit.proxyPort, mit.proxyUser, mit.proxyPassword, mit.credentials);
    }

    private static ApiClientAdapter createApiClientAdapter(String cloudURL, String credentialsId, Boolean skipCertCheck, Boolean isProxy, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, IBitbarCredentials credentialsWrapper) {
        APIKeyClient apiClient;
        BitbarCredentials credentials = credentialsWrapper == null ? BitbarCredentialsUtils.getBitbarCredentials(credentialsId) : credentialsWrapper.getCredentials();
        if (Boolean.TRUE.equals(isProxy)) {
            HttpHost proxy;
            HttpHost httpHost = proxy = proxyPort != null ? new HttpHost(proxyHost, proxyPort.intValue(), "http") : new HttpHost(proxyHost);
            apiClient = StringUtils.isNotBlank((CharSequence)proxyUser) ? new APIKeyClient(cloudURL, Secret.toString((Secret)credentials.getApiKey()), proxy, proxyUser, proxyPassword, skipCertCheck.booleanValue()) : new APIKeyClient(cloudURL, Secret.toString((Secret)credentials.getApiKey()), proxy, skipCertCheck.booleanValue());
        } else {
            apiClient = new APIKeyClient(cloudURL, Secret.toString((Secret)credentials.getApiKey()), skipCertCheck.booleanValue());
        }
        return new ApiClientAdapter((APIClient)apiClient);
    }
}

