/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.auth;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIKeyClient;
import com.testdroid.api.DefaultAPIClient;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.auth.BitbarCredentials;
import com.testdroid.jenkins.remotesupport.MachineIndependentTask;
import com.testdroid.jenkins.utils.ApiClientAdapter;
import com.testdroid.jenkins.utils.BitbarCredentialsUtils;
import hudson.Extension;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;

@Extension
public class TestdroidApiUtil {
    private static ApiClientAdapter apiClientAdapter;

    public static ApiClientAdapter getGlobalApiClient() {
        if (apiClientAdapter == null) {
            TestdroidApiUtil.refreshApiClient(new TestdroidCloudSettings.DescriptorImpl());
        }
        return apiClientAdapter;
    }

    public static void refreshApiClient(TestdroidCloudSettings.DescriptorImpl settings) {
        apiClientAdapter = TestdroidApiUtil.createApiClientHelper(settings);
    }

    public static ApiClientAdapter createApiClient(TestdroidCloudSettings.DescriptorImpl settings) {
        return TestdroidApiUtil.createApiClientHelper(settings);
    }

    public static ApiClientAdapter createNewApiClient(MachineIndependentTask mit) {
        return TestdroidApiUtil.createAdapter(mit.cloudUrl, mit.credentialsId, mit.noCheckCertificate, mit.isProxy, mit.proxyHost, mit.proxyPort, mit.proxyUser, mit.proxyPassword);
    }

    private static ApiClientAdapter createApiClientHelper(TestdroidCloudSettings.DescriptorImpl settings) {
        return TestdroidApiUtil.createAdapter(settings.getCloudUrl(), settings.getCredentialsId(), settings.getNoCheckCertificate(), settings.getIsProxy(), settings.getProxyHost(), settings.getProxyPort(), settings.getProxyUser(), settings.getProxyPassword());
    }

    private static ApiClientAdapter createAdapter(String cloudURL, String credentialsId, Boolean skipCertCheck, Boolean isProxy, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) {
        Object apiClient;
        BitbarCredentials credentials = BitbarCredentialsUtils.getBitbarCredentials(credentialsId);
        if (Boolean.TRUE.equals(isProxy)) {
            HttpHost proxy;
            HttpHost httpHost = proxy = proxyPort != null ? new HttpHost(proxyHost, proxyPort.intValue(), "http") : new HttpHost(proxyHost);
            apiClient = StringUtils.isNotBlank((CharSequence)proxyUser) ? (credentials.usesApiKey() ? new APIKeyClient(cloudURL, BitbarCredentialsUtils.getSecretText(credentials.getApiKey()), proxy, proxyUser, proxyPassword, skipCertCheck.booleanValue()) : new DefaultAPIClient(cloudURL, credentials.getEmail(), BitbarCredentialsUtils.getSecretText(credentials.getPassword()), proxy, proxyUser, proxyPassword, skipCertCheck.booleanValue())) : (credentials.usesApiKey() ? new APIKeyClient(cloudURL, BitbarCredentialsUtils.getSecretText(credentials.getApiKey()), proxy, skipCertCheck.booleanValue()) : new DefaultAPIClient(cloudURL, credentials.getEmail(), BitbarCredentialsUtils.getSecretText(credentials.getPassword()), proxy, skipCertCheck.booleanValue()));
        } else {
            apiClient = credentials.usesApiKey() ? new APIKeyClient(cloudURL, BitbarCredentialsUtils.getSecretText(credentials.getApiKey()), skipCertCheck.booleanValue()) : new DefaultAPIClient(cloudURL, credentials.getEmail(), BitbarCredentialsUtils.getSecretText(credentials.getPassword()));
        }
        return new ApiClientAdapter((APIClient)apiClient);
    }
}

