/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.auth;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.auth.BitbarCredentials;
import com.testdroid.jenkins.auth.BitbarPassword;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import org.kohsuke.stapler.DataBoundConstructor;

public class BitbarPasswordImpl
extends BaseStandardCredentials
implements BitbarPassword {
    private final String email;
    private final Secret password;

    @DataBoundConstructor
    public BitbarPasswordImpl(CredentialsScope scope, String id, String description, String email, Secret password) {
        super(scope, id, description);
        this.email = email;
        this.password = password;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public BitbarCredentials getCredentials() {
        return new BitbarCredentials(this.email, this.password);
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.BITBAR_PASSWORD();
        }
    }
}

