/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.testdroid.api.APIException;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.auth.IBitbarCredentials;
import com.testdroid.jenkins.auth.TestdroidApiUtil;
import com.testdroid.jenkins.remotesupport.MachineIndependentTask;
import com.testdroid.jenkins.utils.BitbarCredentialsUtils;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class TestdroidCloudSettings
implements Describable<TestdroidCloudSettings> {
    private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());

    public Descriptor<TestdroidCloudSettings> getDescriptor() {
        return Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TestdroidCloudSettings> {
        private static final String DEFAULT_CLOUD_URL = "https://cloud.bitbar.com";
        String cloudUrl;
        String credentialsId;
        boolean isProxy;
        boolean noCheckCertificate;
        String proxyHost;
        String proxyPassword;
        Integer proxyPort;
        String proxyUser;

        public DescriptorImpl() {
            this.load();
        }

        public DescriptorImpl(MachineIndependentTask task) {
            this.cloudUrl = task.cloudUrl;
            this.credentialsId = task.credentialsId;
            this.isProxy = task.isProxy;
            this.noCheckCertificate = task.noCheckCertificate;
            this.proxyHost = task.proxyHost;
            this.proxyPassword = task.proxyPassword;
            this.proxyPort = task.proxyPort;
            this.proxyUser = task.proxyUser;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.PLUGIN_NAME();
        }

        public void save() {
            this.proxyPassword = Secret.fromString((String)this.proxyPassword).getEncryptedValue();
            TestdroidApiUtil.refreshApiClient(this);
            super.save();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindParameters((Object)this);
            super.configure(req, json);
            this.save();
            return true;
        }

        @POST
        public FormValidation doAuthorize(@QueryParameter String credentialsId, @QueryParameter String cloudUrl, @QueryParameter boolean noCheckCertificate, @QueryParameter boolean isProxy, @QueryParameter String proxyHost, @QueryParameter Integer proxyPort, @QueryParameter String proxyUser, @QueryParameter String proxyPassword) {
            Objects.requireNonNull(Jenkins.getInstanceOrNull()).checkPermission(Jenkins.ADMINISTER);
            this.credentialsId = credentialsId;
            this.cloudUrl = cloudUrl;
            this.noCheckCertificate = noCheckCertificate;
            this.isProxy = isProxy;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
            try {
                this.validateForm(this);
                TestdroidApiUtil.createApiClient(this).tryValidateConfig();
                this.save();
                return FormValidation.ok((String)Messages.AUTHORIZATION_OK());
            }
            catch (APIException | IllegalStateException e) {
                this.load();
                String message = e.getLocalizedMessage();
                LOGGER.log(Level.WARNING, message);
                return FormValidation.error((String)message);
            }
        }

        public ListBoxModel doFillCredentialsIdItems() {
            ListBoxModel credentials = new ListBoxModel();
            credentials.add((Object)new ListBoxModel.Option("", ""));
            CredentialsProvider.lookupCredentials(IBitbarCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()).forEach(c -> credentials.add(CredentialsNameProvider.name((Credentials)c), c.getId()));
            return credentials;
        }

        private void validateForm(DescriptorImpl settings) throws IllegalStateException {
            if (BitbarCredentialsUtils.getBitbarCredentials(settings.credentialsId).isEmpty()) {
                throw new IllegalStateException(Messages.NO_SELECTED_CREDENTIALS());
            }
            try {
                new URL(settings.cloudUrl).toURI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IllegalStateException(Messages.MALFORMED_URL());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            DescriptorImpl that = (DescriptorImpl)((Object)o);
            return this.isProxy == that.isProxy && this.noCheckCertificate == that.noCheckCertificate && Objects.equals(this.cloudUrl, that.cloudUrl) && Objects.equals(this.credentialsId, that.credentialsId) && Objects.equals(this.proxyHost, that.proxyHost) && Objects.equals(this.proxyPassword, that.proxyPassword) && Objects.equals(this.proxyPort, that.proxyPort) && Objects.equals(this.proxyUser, that.proxyUser);
        }

        public int hashCode() {
            return Objects.hash(this.cloudUrl, this.credentialsId, this.isProxy, this.noCheckCertificate, this.proxyHost, this.proxyPassword, this.proxyPort, this.proxyUser);
        }

        public String getCloudUrl() {
            if (StringUtils.isBlank((CharSequence)this.cloudUrl)) {
                this.cloudUrl = DEFAULT_CLOUD_URL;
            }
            return this.cloudUrl;
        }

        public void setCloudUrl(String cloudUrl) {
            this.cloudUrl = cloudUrl;
        }

        public Boolean getNoCheckCertificate() {
            return this.noCheckCertificate;
        }

        public void setNoCheckCertificate(Boolean noCheckCertificate) {
            this.noCheckCertificate = noCheckCertificate;
        }

        public Boolean getIsProxy() {
            return this.isProxy;
        }

        public void setIsProxy(Boolean isProxy) {
            this.isProxy = isProxy;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public Integer getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
        }

        public String getProxyUser() {
            return this.proxyUser;
        }

        public void setProxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
        }

        public String getProxyPassword() {
            return Secret.fromString((String)this.proxyPassword).getPlainText();
        }

        public void setProxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
        }

        public String getCredentialsId() {
            return this.credentialsId;
        }

        public void setCredentialsId(String credentialsId) {
            this.credentialsId = credentialsId;
        }
    }
}

