/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.testdroid.api.APIException;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIFileConfig;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APITestRunParameter;
import com.testdroid.api.model.APIUser;
import com.testdroid.jenkins.AbstractBuilder;
import com.testdroid.jenkins.CloudLink;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.RunInCloudDescriptorHelper;
import com.testdroid.jenkins.RunInCloudEnvInject;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.WaitForResultsBlock;
import com.testdroid.jenkins.remotesupport.MachineIndependentFileUploader;
import com.testdroid.jenkins.remotesupport.MachineIndependentResultsDownloader;
import com.testdroid.jenkins.scheduler.TestRunFinishCheckScheduler;
import com.testdroid.jenkins.scheduler.TestRunFinishCheckSchedulerFactory;
import com.testdroid.jenkins.utils.ApiClientAdapter;
import com.testdroid.jenkins.utils.LocaleUtil;
import com.testdroid.jenkins.utils.TestdroidApiUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class RunInCloudBuilder
extends AbstractBuilder {
    private static final Logger LOGGER = Logger.getLogger(RunInCloudBuilder.class.getSimpleName());
    private static final String POST_HOOK_URL = "/plugin/testdroid-run-in-cloud/api/json/cloud-webhook";
    private static final Semaphore semaphore = new Semaphore(1);
    private String appPath;
    private String clusterId;
    private String deviceGroupId;
    private String dataPath;
    private boolean failBuildIfThisStepFailed;
    private String keyValuePairs;
    private String language;
    private String projectId;
    private String scheduler;
    private String screenshotsDirectory;
    private String testCasesSelect;
    private String testCasesValue;
    private String testPath;
    private String testRunName;
    private String testRunner;
    private WaitForResultsBlock waitForResultsBlock;
    private String withAnnotation;
    private String withoutAnnotation;
    private String testTimeout;
    private String credentialsId;
    private String cloudUrl;
    private Long frameworkId;
    private APIDevice.OsType osType;
    private String cloudUIUrl;

    public String getCloudUIUrl() {
        return this.cloudUIUrl;
    }

    public void setCloudUIUrl(String cloudUIUrl) {
        this.cloudUIUrl = cloudUIUrl;
    }

    @DataBoundConstructor
    public RunInCloudBuilder(String projectId, String appPath, String testPath, String dataPath, String testRunName, String scheduler, String testRunner, String deviceGroupId, String language, String screenshotsDirectory, String keyValuePairs, String withAnnotation, String withoutAnnotation, String testCasesSelect, String testCasesValue, Boolean failBuildIfThisStepFailed, WaitForResultsBlock waitForResultsBlock, String testTimeout, String credentialsId, String cloudUrl, String cloudUIUrl, Long frameworkId, APIDevice.OsType osType) {
        this.projectId = projectId;
        this.appPath = appPath;
        this.dataPath = dataPath;
        this.testPath = testPath;
        this.testRunName = testRunName;
        this.scheduler = scheduler;
        this.testRunner = testRunner;
        this.screenshotsDirectory = screenshotsDirectory;
        this.keyValuePairs = keyValuePairs;
        this.withAnnotation = withAnnotation;
        this.withoutAnnotation = withoutAnnotation;
        this.testCasesSelect = testCasesSelect;
        this.testCasesValue = testCasesValue;
        this.deviceGroupId = deviceGroupId;
        this.language = language;
        this.failBuildIfThisStepFailed = failBuildIfThisStepFailed;
        this.testTimeout = testTimeout;
        this.credentialsId = credentialsId;
        this.cloudUrl = cloudUrl;
        this.frameworkId = frameworkId;
        this.osType = osType;
        this.waitForResultsBlock = waitForResultsBlock;
        this.cloudUIUrl = cloudUIUrl;
    }

    public String getTestRunName() {
        return this.testRunName;
    }

    public void setTestRunName(String testRunName) {
        this.testRunName = testRunName;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public String getTestPath() {
        return this.testPath;
    }

    public void setTestPath(String testPath) {
        this.testPath = testPath;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDeviceGroupId() {
        if (StringUtils.isBlank((CharSequence)this.deviceGroupId) && StringUtils.isNotBlank((CharSequence)this.clusterId)) {
            return this.clusterId;
        }
        return this.deviceGroupId;
    }

    public void setDeviceGroupId(String deviceGroupId) {
        this.deviceGroupId = deviceGroupId;
    }

    public String getTestRunner() {
        return this.testRunner;
    }

    public void setTestRunner(String testRunner) {
        this.testRunner = testRunner;
    }

    public String getScreenshotsDirectory() {
        return this.screenshotsDirectory;
    }

    public void setScreenshotsDirectory(String screenshotsDirectory) {
        this.screenshotsDirectory = screenshotsDirectory;
    }

    public String getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public void setKeyValuePairs(String keyValuePairs) {
        this.keyValuePairs = keyValuePairs;
    }

    public String getWithAnnotation() {
        return this.withAnnotation;
    }

    public void setWithAnnotation(String withAnnotation) {
        this.withAnnotation = withAnnotation;
    }

    public String getWithoutAnnotation() {
        return this.withoutAnnotation;
    }

    public void setWithoutAnnotation(String withoutAnnotation) {
        this.withoutAnnotation = withoutAnnotation;
    }

    public String getTestCasesSelect() {
        if (StringUtils.isBlank((CharSequence)this.testCasesSelect)) {
            return APITestRunConfig.LimitationType.PACKAGE.name();
        }
        return this.testCasesSelect;
    }

    public void setTestCasesSelect(String testCasesSelect) {
        this.testCasesSelect = testCasesSelect;
    }

    public String getTestCasesValue() {
        return this.testCasesValue;
    }

    public void setTestCasesValue(String testCasesValue) {
        this.testCasesValue = testCasesValue;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public String getLanguage() {
        if (StringUtils.isBlank((CharSequence)this.language)) {
            this.language = LocaleUtil.formatLangCode(Locale.US);
        }
        if (this.language.contains("-")) {
            this.language = this.language.replace('-', '_');
        }
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getScheduler() {
        if (StringUtils.isBlank((CharSequence)this.scheduler)) {
            this.scheduler = APITestRunConfig.Scheduler.PARALLEL.name();
        }
        return this.scheduler;
    }

    public void setScheduler(String scheduler) {
        this.scheduler = scheduler.toLowerCase();
    }

    public String getTestTimeout() {
        return this.testTimeout;
    }

    public void setTestTimeout(String testTimeout) {
        this.testTimeout = testTimeout;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getCloudUrl() {
        return this.cloudUrl;
    }

    public void setCloudUrl(String cloudUrl) {
        this.cloudUrl = cloudUrl;
    }

    public WaitForResultsBlock getWaitForResultsBlock() {
        return this.waitForResultsBlock;
    }

    public void setWaitForResultsBlock(WaitForResultsBlock waitForResultsBlock) {
        this.waitForResultsBlock = waitForResultsBlock;
    }

    public boolean isFailBuildIfThisStepFailed() {
        return this.failBuildIfThisStepFailed;
    }

    public void setFailBuildIfThisStepFailed(boolean failBuildIfThisStepFailed) {
        this.failBuildIfThisStepFailed = failBuildIfThisStepFailed;
    }

    public boolean isFullTest() {
        return StringUtils.isNotBlank((CharSequence)this.testPath);
    }

    public boolean isDataFile() {
        return StringUtils.isNotBlank((CharSequence)this.dataPath);
    }

    public boolean isWaitForResults() {
        return this.waitForResultsBlock != null;
    }

    public Long getFrameworkId() {
        return this.frameworkId;
    }

    public void setFrameworkId(Long frameworkId) {
        this.frameworkId = frameworkId;
    }

    public APIDevice.OsType getOsType() {
        if (this.osType == null) {
            this.osType = APIDevice.OsType.UNDEFINED;
        }
        return this.osType;
    }

    public void setOsType(APIDevice.OsType osType) {
        this.osType = osType;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private String evaluateHookUrl() {
        return this.isWaitForResults() ? (StringUtils.isNotBlank((CharSequence)this.waitForResultsBlock.getHookURL()) ? this.waitForResultsBlock.getHookURL() : String.format("%s%s", Jenkins.getInstance().getRootUrl(), POST_HOOK_URL)) : null;
    }

    private String evaluateResultsPath(FilePath workspace) {
        if (this.isWaitForResults()) {
            String resultsPath = this.waitForResultsBlock.getResultsPath();
            if (StringUtils.isNotBlank((CharSequence)resultsPath)) {
                try {
                    return this.getAbsolutePath(workspace, resultsPath);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Couldn't get absolute path for results. Using workspace...");
                }
            }
            return workspace.getRemote();
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        return this.completeRun((Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener);
    }

    public boolean completeRun(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        listener.getLogger().println(Messages.RUN_TEST_IN_CLOUD_STARTED());
        boolean result = this.runTest(build, workspace, launcher, listener);
        if (result) {
            listener.getLogger().println(Messages.RUN_TEST_IN_CLOUD_SUCCEEDED());
        } else {
            listener.getLogger().println(Messages.RUN_TEST_IN_CLOUD_FAILED());
        }
        return result || !this.failBuildIfThisStepFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTest(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        String appPathFinal = RunInCloudBuilder.applyMacro(build, listener, this.appPath);
        String testPathFinal = RunInCloudBuilder.applyMacro(build, listener, this.testPath);
        String dataPathFinal = RunInCloudBuilder.applyMacro(build, listener, this.dataPath);
        String withAnnotationFinal = RunInCloudBuilder.applyMacro(build, listener, this.withAnnotation);
        String testRunnerFinal = RunInCloudBuilder.applyMacro(build, listener, this.testRunner);
        String withoutAnnotationFinal = RunInCloudBuilder.applyMacro(build, listener, this.withoutAnnotation);
        String testTimeoutFinal = RunInCloudBuilder.applyMacro(build, listener, this.testTimeout);
        TestdroidCloudSettings.DescriptorImpl cloudSettings = new TestdroidCloudSettings.DescriptorImpl();
        if (StringUtils.isNotBlank((CharSequence)this.getCredentialsId())) {
            StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)this.getCredentialsId(), StandardUsernamePasswordCredentials.class, build, Collections.emptyList());
            if (credentials != null) {
                listener.getLogger().println(Messages.BUILD_STEP_USING_CREDENTIALS());
                cloudSettings = new TestdroidCloudSettings.DescriptorImpl(credentials.getUsername(), credentials.getPassword().getPlainText());
                if (StringUtils.isNotBlank((CharSequence)this.getCloudUrl())) {
                    cloudSettings.setCloudUrl(this.getCloudUrl());
                    if (StringUtils.isNotBlank((CharSequence)this.getCloudUIUrl())) {
                        cloudSettings.setNewCloudUrl(this.getCloudUIUrl());
                    }
                }
            } else {
                listener.getLogger().println(String.format(Messages.COULDNT_FIND_CREDENTIALS(), this.getCredentialsId()));
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.cloudUrl)) {
            listener.getLogger().println(String.format(Messages.CLOUD_URL_SET_BUT_NO_CREDENTIALS(), this.cloudUrl, cloudSettings.getCloudUrl()));
        }
        boolean releaseDone = false;
        try {
            String absolutePath;
            Optional<Long> optionalProjectId;
            semaphore.acquire();
            ApiClientAdapter api = TestdroidApiUtil.createApiClient(cloudSettings);
            if (!api.isAuthenticated()) {
                listener.getLogger().println("Couldn't connect to the cloud!");
                boolean bl = false;
                return bl;
            }
            APIUser user = api.getUser();
            String cloudVersion = api.getCloudVersion();
            APITestRunConfig config = new APITestRunConfig();
            if (StringUtils.isNotBlank((CharSequence)this.getProjectId()) && (optionalProjectId = this.parseLong("projectId", this.getProjectId(), Boolean.TRUE, listener)).isPresent()) {
                config.setProjectId(optionalProjectId.get());
                config = user.validateTestRunConfig(config);
            }
            config.setDeviceLanguageCode(this.getLanguage());
            config.setScheduler(APITestRunConfig.Scheduler.valueOf((String)this.getScheduler().toUpperCase()));
            config.setDeviceGroupId(this.parseLong("deviceGroupId", this.getDeviceGroupId(), Boolean.TRUE, listener).orElseGet(() -> {
                listener.error("Set deviceGroupId to null");
                return null;
            }));
            config.setDeviceIds(null);
            config.setHookURL(this.evaluateHookUrl());
            config.setScreenshotDir(this.getScreenshotsDirectory());
            config.setInstrumentationRunner(testRunnerFinal);
            config.setWithoutAnnotation(withoutAnnotationFinal);
            config.setWithAnnotation(withAnnotationFinal);
            config.setFrameworkId(Optional.ofNullable(this.frameworkId).orElse(config.getFrameworkId()));
            config.setOsType(Optional.ofNullable(this.osType).orElse(config.getOsType()));
            config.getFiles().clear();
            if (ApiClientAdapter.isPaidUser(user)) {
                this.parseLong("testTimeout", testTimeoutFinal, StringUtils.isNotEmpty((CharSequence)testTimeoutFinal), listener).ifPresent(arg_0 -> ((APITestRunConfig)config).setTimeout(arg_0));
            } else {
                listener.getLogger().println(String.format(Messages.FREE_USERS_CLOUD_TIMEOUT(), user.getEmail()));
            }
            this.setLimitations(build, listener, config);
            this.createProvidedParameters(config);
            config = user.validateTestRunConfig(config);
            this.getDescriptor().save();
            ArrayList<APIFileConfig> files = new ArrayList<APIFileConfig>();
            if (StringUtils.isNotBlank((CharSequence)appPathFinal)) {
                absolutePath = this.getAbsolutePath(workspace, appPathFinal);
                FilePath appFile = new FilePath(launcher.getChannel(), absolutePath);
                listener.getLogger().println(String.format(Messages.UPLOADING_NEW_APPLICATION_S(), absolutePath));
                Long appFileId = (Long)appFile.act((FilePath.FileCallable)new MachineIndependentFileUploader(cloudSettings, listener));
                if (appFileId == null) {
                    boolean bl = false;
                    return bl;
                }
                files.add(new APIFileConfig(appFileId, APIFileConfig.Action.INSTALL));
            } else {
                listener.getLogger().println("App path was blank. Using latest app in project.");
            }
            if (this.isFullTest()) {
                absolutePath = this.getAbsolutePath(workspace, testPathFinal);
                FilePath testFile = new FilePath(launcher.getChannel(), absolutePath);
                listener.getLogger().println(String.format(Messages.UPLOADING_NEW_INSTRUMENTATION_S(), absolutePath));
                Long testFileId = (Long)testFile.act((FilePath.FileCallable)new MachineIndependentFileUploader(cloudSettings, listener));
                if (testFileId == null) {
                    boolean bl = false;
                    return bl;
                }
                files.add(new APIFileConfig(testFileId, APIFileConfig.Action.RUN_TEST));
            }
            if (this.isDataFile()) {
                absolutePath = this.getAbsolutePath(workspace, dataPathFinal);
                FilePath dataFile = new FilePath(launcher.getChannel(), absolutePath);
                listener.getLogger().println(String.format(Messages.UPLOADING_DATA_FILE_S(), absolutePath));
                Long dataFileId = (Long)dataFile.act((FilePath.FileCallable)new MachineIndependentFileUploader(cloudSettings, listener));
                if (dataFileId == null) {
                    boolean bl = false;
                    return bl;
                }
                files.add(new APIFileConfig(dataFileId, APIFileConfig.Action.COPY_TO_DEVICE));
            }
            listener.getLogger().println(Messages.RUNNING_TESTS());
            String finalTestRunName = RunInCloudBuilder.applyMacro(build, listener, this.getTestRunName());
            if (StringUtils.isBlank((CharSequence)finalTestRunName) || finalTestRunName.trim().startsWith("$")) {
                finalTestRunName = null;
            }
            config.setFiles(files);
            config.setTestRunName(finalTestRunName);
            this.printTestRunConfig(config, cloudSettings, cloudVersion, listener);
            APITestRun testRun = user.startTestRun(config);
            this.printTestRun(testRun, listener);
            CloudLink cloudLinkAction = new CloudLink(testRun.getUiLink());
            build.addAction((Action)cloudLinkAction);
            RunInCloudEnvInject variable = new RunInCloudEnvInject("CLOUD_LINK", cloudLinkAction.getUrlName());
            build.addAction((Action)variable);
            semaphore.release();
            releaseDone = true;
            boolean bl = this.waitForResults(testRun, workspace, launcher, listener, cloudSettings);
            return bl;
        }
        catch (APIException e) {
            listener.getLogger().println(String.format("%s: %s", Messages.ERROR_API(), e.getMessage()));
            LOGGER.log(Level.WARNING, Messages.ERROR_API(), e);
        }
        catch (IOException e) {
            listener.getLogger().println(String.format("%s: %s", Messages.ERROR_CONNECTION(), e.getLocalizedMessage()));
            LOGGER.log(Level.WARNING, Messages.ERROR_CONNECTION(), e);
        }
        catch (InterruptedException e) {
            listener.getLogger().println(String.format("%s: %s", Messages.ERROR_TESTDROID(), e.getLocalizedMessage()));
            LOGGER.log(Level.WARNING, Messages.ERROR_TESTDROID(), e);
        }
        finally {
            if (!releaseDone) {
                semaphore.release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private boolean waitForResults(APITestRun testRun, FilePath workspace, Launcher launcher, TaskListener listener, TestdroidCloudSettings.DescriptorImpl cloudSettings) {
        if (this.isWaitForResults()) {
            boolean isDownloadOk = false;
            TestRunFinishCheckScheduler scheduler = TestRunFinishCheckSchedulerFactory.createTestRunFinishScheduler(this.waitForResultsBlock.getTestRunStateCheckMethod(), listener);
            try {
                String msg;
                boolean testRunToAbort = false;
                Integer ricTimeout = this.waitForResultsBlock.getWaitForResultsTimeout();
                listener.getLogger().println(ricTimeout > 0 ? Messages.WAITING_SEC_FOR_THE_RESULTS(ricTimeout) : Messages.WAITING_FOR_THE_RESULTS());
                scheduler.schedule((Object)this, testRun);
                try {
                    RunInCloudBuilder runInCloudBuilder = this;
                    synchronized (runInCloudBuilder) {
                        ((Object)((Object)this)).wait(ricTimeout * 1000);
                    }
                    scheduler.cancel(testRun);
                    testRun.refresh();
                    if (testRun.getState() == APITestRun.State.FINISHED) {
                        isDownloadOk = (Boolean)launcher.getChannel().call((Callable)new MachineIndependentResultsDownloader(cloudSettings, listener, testRun.getProjectId(), testRun.getId(), this.evaluateResultsPath(workspace), this.waitForResultsBlock.isDownloadScreenshots()));
                        if (!isDownloadOk) {
                            listener.getLogger().println(Messages.DOWNLOAD_RESULTS_FAILED());
                            LOGGER.log(Level.WARNING, Messages.DOWNLOAD_RESULTS_FAILED());
                        }
                    } else {
                        testRunToAbort = true;
                        msg = String.format(Messages.DOWNLOAD_RESULTS_FAILED_WITH_REASON_S(), "Test run is not finished yet!");
                        listener.getLogger().println(msg);
                        LOGGER.log(Level.WARNING, msg);
                    }
                }
                catch (InterruptedException e) {
                    testRunToAbort = true;
                    listener.getLogger().println(e.getMessage());
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
                if (testRunToAbort && this.waitForResultsBlock.isForceFinishAfterBreak()) {
                    msg = "Force finish test in Cloud";
                    listener.getLogger().println(msg);
                    LOGGER.log(Level.WARNING, msg);
                    testRun.abort();
                }
            }
            catch (APIException e) {
                listener.getLogger().println(String.format("%s: %s", Messages.ERROR_API(), e.getMessage()));
                LOGGER.log(Level.WARNING, Messages.ERROR_API(), e);
            }
            catch (IOException e) {
                listener.getLogger().println(String.format("%s: %s", Messages.ERROR_CONNECTION(), e.getLocalizedMessage()));
                LOGGER.log(Level.WARNING, Messages.ERROR_CONNECTION(), e);
            }
            finally {
                scheduler.cancel(testRun);
            }
            return isDownloadOk;
        }
        return true;
    }

    private void setLimitations(Run<?, ?> build, TaskListener listener, APITestRunConfig config) {
        if (StringUtils.isNotBlank((CharSequence)this.getTestCasesValue())) {
            config.setLimitationType(APITestRunConfig.LimitationType.valueOf((String)this.getTestCasesSelect().toUpperCase()));
            config.setLimitationValue(RunInCloudBuilder.applyMacro(build, listener, this.getTestCasesValue()));
        } else {
            config.setLimitationType(null);
            config.setLimitationValue("");
        }
    }

    private void createProvidedParameters(APITestRunConfig config) {
        ArrayList apiTestRunParameters = new ArrayList();
        if (this.keyValuePairs != null) {
            String[] splitKeyValuePairs = this.keyValuePairs.split(";");
            apiTestRunParameters.addAll(Arrays.stream(splitKeyValuePairs).filter(StringUtils::isNotEmpty).map(s -> {
                String[] pair = s.split(":");
                return pair.length == 2 ? new APITestRunParameter(pair[0], pair[1]) : null;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        config.setTestRunParameters(apiTestRunParameters);
    }

    private void printTestRunConfig(APITestRunConfig config, TestdroidCloudSettings.DescriptorImpl cloudSettings, String cloudVersion, TaskListener listener) {
        listener.getLogger().println(Messages.TEST_RUN_CONFIGURATION());
        listener.getLogger().println(Messages.CLOUD_INFO(cloudSettings.getCloudUrl(), cloudVersion));
        listener.getLogger().println(Messages.USER_EMAIL_VALUE(cloudSettings.getEmail()));
        listener.getLogger().println(Messages.DEVICE_GROUP_INFO(config.getUsedDeviceGroupName(), config.getDeviceGroupId()));
        listener.getLogger().println(Messages.OS_TYPE_VALUE(config.getOsType()));
        listener.getLogger().println(Messages.FRAMEWORK_INFO(config.getFrameworkId()));
        listener.getLogger().println(Messages.LOCALE_VALUE(config.getDeviceLanguageCode()));
        listener.getLogger().println(Messages.SCHEDULER_VALUE(config.getScheduler()));
        listener.getLogger().println(Messages.TIMEOUT_VALUE(config.getTimeout()));
    }

    private void printTestRun(APITestRun testRun, TaskListener listener) {
        listener.getLogger().println(Messages.TEST_RUN_INFO(testRun.getUiLink(), testRun.getId()));
        listener.getLogger().println(Messages.PROJECT_INFO(testRun.getProjectName(), testRun.getProjectId()));
    }

    private String getAbsolutePath(FilePath workspace, String path) throws IOException, InterruptedException {
        if (StringUtils.isBlank((CharSequence)path)) {
            return "";
        }
        String trimmed = StringUtils.trim((String)path);
        if (trimmed.startsWith(File.separator)) {
            return trimmed;
        }
        URI workspaceURI = workspace.toURI();
        return workspaceURI.getPath() + trimmed;
    }

    private Optional<Long> parseLong(String name, String strValue, Boolean showError, TaskListener listener) {
        Optional<Long> result;
        block2: {
            result = Optional.empty();
            try {
                result = Optional.of(Long.parseLong(StringUtils.trim((String)strValue)));
            }
            catch (NumberFormatException exc) {
                if (!showError.booleanValue()) break block2;
                listener.error("Can't parse %s = %s", new Object[]{name, strValue});
            }
        }
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder>
    implements Serializable,
    RunInCloudDescriptorHelper {
        private static final long serialVersionUID = 1L;

        public DescriptorImpl() {
            super(RunInCloudBuilder.class);
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.TESTDROID_RUN_TESTS_IN_CLOUD();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }
    }
}

