/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.dto.Context;
import com.testdroid.api.dto.Operand;
import com.testdroid.api.filter.BooleanFilterEntry;
import com.testdroid.api.filter.FilterEntry;
import com.testdroid.api.filter.StringFilterEntry;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceGroup;
import com.testdroid.api.model.APIFramework;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APIUser;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.model.TestRunStateCheckMethod;
import com.testdroid.jenkins.utils.AndroidLocale;
import com.testdroid.jenkins.utils.LocaleUtil;
import com.testdroid.jenkins.utils.TestdroidApiUtil;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public interface RunInCloudDescriptorHelper {
    public static final Logger LOGGER = Logger.getLogger(RunInCloudDescriptorHelper.class.getSimpleName());
    public static final List<String> PAID_ROLES = Collections.unmodifiableList(Arrays.asList("PRIORITY_SILVER", "PRIORITY_GOLD", "PRIORITY_PLATINUM"));
    public static final String DEFAULT_SCHEDULER = APITestRunConfig.Scheduler.PARALLEL.name();
    public static final String DEFAULT_TEST_CASES_SELECT = APITestRunConfig.LimitationType.PACKAGE.name();
    public static final String DEFAULT_LANGUAGE = LocaleUtil.formatLangCode(Locale.US);
    public static final ListBoxModel.Option EMPTY_OPTION = new ListBoxModel.Option("", "");

    default public boolean isAuthenticated() {
        return TestdroidApiUtil.getGlobalApiClient().isAuthenticated();
    }

    default public boolean isPaidUser() {
        boolean result = false;
        if (this.isAuthenticated()) {
            try {
                Date now = new Date();
                result = Arrays.stream(TestdroidApiUtil.getGlobalApiClient().getUser().getRoles()).anyMatch(r -> PAID_ROLES.contains(r.getName()) && (r.getExpireTime() == null || r.getExpireTime().after(now)));
            }
            catch (APIException e) {
                LOGGER.log(Level.WARNING, Messages.ERROR_API());
            }
        }
        return result;
    }

    default public ListBoxModel doFillProjectIdItems() {
        ListBoxModel projects = new ListBoxModel();
        projects.add((Object)EMPTY_OPTION);
        try {
            APIUser user = TestdroidApiUtil.getGlobalApiClient().getUser();
            Context context = new Context(APIProject.class, 0, Integer.MAX_VALUE, "", "");
            context.addFilter((FilterEntry)new BooleanFilterEntry("readOnly", Operand.EQ, Boolean.FALSE));
            APIListResource projectResource = user.getProjectsResource(context);
            for (APIProject project : projectResource.getEntity().getData()) {
                projects.add(project.getName(), project.getId().toString());
            }
        }
        catch (APIException e) {
            LOGGER.log(Level.WARNING, Messages.ERROR_API());
        }
        return projects;
    }

    default public ListBoxModel doFillOsTypeItems() {
        ListBoxModel osTypes = new ListBoxModel();
        osTypes.addAll((Collection)Arrays.stream(APIDevice.OsType.values()).map(t -> new ListBoxModel.Option(t.getDisplayName(), t.name())).collect(Collectors.toList()));
        return osTypes;
    }

    @POST
    default public FormValidation doCheckOsType(@QueryParameter APIDevice.OsType value) {
        return value == APIDevice.OsType.UNDEFINED ? FormValidation.error((String)Messages.DEFINE_OS_TYPE()) : FormValidation.ok();
    }

    default public ListBoxModel doFillSchedulerItems() {
        ListBoxModel schedulers = new ListBoxModel();
        schedulers.add(Messages.SCHEDULER_PARALLEL(), APITestRunConfig.Scheduler.PARALLEL.name());
        schedulers.add(Messages.SCHEDULER_SERIAL(), APITestRunConfig.Scheduler.SERIAL.name());
        schedulers.add(Messages.SCHEDULER_SINGLE(), APITestRunConfig.Scheduler.SINGLE.name());
        return schedulers;
    }

    default public ListBoxModel doFillDeviceGroupIdItems() {
        ListBoxModel deviceGroups = new ListBoxModel();
        try {
            APIUser user = TestdroidApiUtil.getGlobalApiClient().getUser();
            Context context = new Context(APIDeviceGroup.class, 0, Integer.MAX_VALUE, "", "");
            context.setExtraParams(Collections.singletonMap("withPublic", Boolean.TRUE));
            APIListResource deviceGroupResource = user.getDeviceGroupsResource(context);
            for (APIDeviceGroup deviceGroup : deviceGroupResource.getEntity().getData()) {
                deviceGroups.add(String.format("%s (%d device(s))", deviceGroup.getDisplayName(), deviceGroup.getDeviceCount()), deviceGroup.getId().toString());
            }
        }
        catch (APIException e) {
            LOGGER.log(Level.WARNING, Messages.ERROR_API());
        }
        return deviceGroups;
    }

    default public ListBoxModel doFillLanguageItems() {
        ListBoxModel language = new ListBoxModel();
        for (Locale locale : AndroidLocale.LOCALES) {
            String langDisplay = String.format("%s (%s)", locale.getDisplayLanguage(), locale.getDisplayCountry());
            String langCode = LocaleUtil.formatLangCode(locale);
            language.add(langDisplay, langCode);
        }
        return language;
    }

    default public ListBoxModel doFillTestCasesSelectItems() {
        ListBoxModel testCases = new ListBoxModel();
        for (APITestRunConfig.LimitationType limitationType : APITestRunConfig.LimitationType.values()) {
            String value = limitationType.name();
            testCases.add(value.toLowerCase(), value);
        }
        return testCases;
    }

    default public ListBoxModel doFillTestRunStateCheckMethodItems() {
        ListBoxModel items = new ListBoxModel();
        for (TestRunStateCheckMethod method : TestRunStateCheckMethod.values()) {
            items.add(method.name(), method.name());
        }
        return items;
    }

    default public ListBoxModel doFillFrameworkIdItems(@QueryParameter APIDevice.OsType osType) {
        ListBoxModel frameworks = new ListBoxModel();
        frameworks.add((Object)EMPTY_OPTION);
        if (osType != APIDevice.OsType.UNDEFINED) {
            try {
                APIUser user = TestdroidApiUtil.getGlobalApiClient().getUser();
                Context context = new Context(APIFramework.class, 0, Integer.MAX_VALUE, "", "");
                context.addFilter((FilterEntry)new StringFilterEntry("osType", Operand.EQ, osType.name()));
                context.addFilter((FilterEntry)new BooleanFilterEntry("forProjects", Operand.EQ, Boolean.TRUE));
                context.addFilter((FilterEntry)new BooleanFilterEntry("canRunFromUI", Operand.EQ, Boolean.TRUE));
                APIListResource availableFrameworksResource = user.getAvailableFrameworksResource(context);
                frameworks.addAll((Collection)availableFrameworksResource.getEntity().getData().stream().map(f -> new ListBoxModel.Option(f.getName(), f.getId().toString())).collect(Collectors.toList()));
            }
            catch (APIException e) {
                LOGGER.log(Level.WARNING, Messages.ERROR_API());
            }
        }
        return frameworks;
    }

    @POST
    default public FormValidation doCheckFrameworkId(@QueryParameter String value) {
        return this.parseLong(value).isPresent() ? FormValidation.ok() : FormValidation.error((String)Messages.DEFINE_FRAMEWORK());
    }

    default public Optional<Long> parseLong(String value) {
        try {
            return Optional.of(Long.parseLong(value));
        }
        catch (NumberFormatException nfe) {
            return Optional.empty();
        }
    }
}

