/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import com.testdroid.api.APIException;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.remotesupport.MachineIndependentTask;
import com.testdroid.jenkins.utils.TestdroidApiUtil;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TestdroidCloudSettings
implements Describable<TestdroidCloudSettings> {
    private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());

    public Descriptor<TestdroidCloudSettings> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TestdroidCloudSettings> {
        private static final String DEFAULT_CLOUD_URL = "https://cloud.bitbar.com";
        String cloudUrl;
        String newCloudUrl;
        String email;
        String password;
        boolean isProxy;
        boolean noCheckCertificate;
        String proxyHost;
        String proxyPassword;
        Integer proxyPort;
        String proxyUser;

        public DescriptorImpl() {
            this.load();
        }

        DescriptorImpl(String email, String password) {
            this();
            this.email = email;
            this.password = password;
        }

        public DescriptorImpl(MachineIndependentTask task) {
            this.cloudUrl = task.cloudUrl;
            this.email = task.user;
            this.password = task.password;
            this.isProxy = task.isProxy;
            this.noCheckCertificate = task.noCheckCertificate;
            this.proxyHost = task.proxyHost;
            this.proxyPassword = task.proxyPassword;
            this.proxyPort = task.proxyPort;
            this.proxyUser = task.proxyUser;
        }

        public String getDisplayName() {
            return Messages.PLUGIN_NAME();
        }

        public void save() {
            this.password = Secret.fromString((String)this.password).getEncryptedValue();
            this.proxyPassword = Secret.fromString((String)this.proxyPassword).getEncryptedValue();
            TestdroidApiUtil.createGlobalApiClient(this);
            super.save();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindParameters((Object)this);
            super.configure(req, json);
            this.save();
            return true;
        }

        public FormValidation doAuthorize(@QueryParameter String email, @QueryParameter String password, @QueryParameter String cloudUrl, @QueryParameter boolean noCheckCertificate, @QueryParameter boolean isProxy, @QueryParameter String proxyHost, @QueryParameter Integer proxyPort, @QueryParameter String proxyUser, @QueryParameter String proxyPassword) {
            this.email = email;
            this.password = password;
            this.cloudUrl = cloudUrl;
            this.noCheckCertificate = noCheckCertificate;
            this.isProxy = isProxy;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
            try {
                TestdroidApiUtil.createApiClient(this).tryValidateConfig();
                this.save();
                return FormValidation.ok((String)Messages.AUTHORIZATION_OK());
            }
            catch (APIException e) {
                this.password = null;
                this.load();
                LOGGER.log(Level.WARNING, Messages.ERROR_API());
                return FormValidation.error((String)e.getLocalizedMessage());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            DescriptorImpl that = (DescriptorImpl)((Object)o);
            return this.isProxy == that.isProxy && this.noCheckCertificate == that.noCheckCertificate && Objects.equals(this.cloudUrl, that.cloudUrl) && Objects.equals(this.newCloudUrl, that.newCloudUrl) && Objects.equals(this.email, that.email) && Objects.equals(this.password, that.password) && Objects.equals(this.proxyHost, that.proxyHost) && Objects.equals(this.proxyPassword, that.proxyPassword) && Objects.equals(this.proxyPort, that.proxyPort) && Objects.equals(this.proxyUser, that.proxyUser);
        }

        public int hashCode() {
            return Objects.hash(this.cloudUrl, this.newCloudUrl, this.email, this.password, this.isProxy, this.noCheckCertificate, this.proxyHost, this.proxyPassword, this.proxyPort, this.proxyUser);
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getPassword() {
            return Secret.fromString((String)this.password).getPlainText();
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String resolveCloudUiUrl() {
            if (StringUtils.isNotBlank((String)this.newCloudUrl)) {
                return this.newCloudUrl;
            }
            return this.cloudUrl;
        }

        public String getCloudUrl() {
            if (StringUtils.isBlank((String)this.cloudUrl)) {
                this.cloudUrl = DEFAULT_CLOUD_URL;
            }
            return this.cloudUrl;
        }

        public void setCloudUrl(String cloudUrl) {
            this.cloudUrl = cloudUrl;
        }

        public String getNewCloudUrl() {
            return this.newCloudUrl;
        }

        public void setNewCloudUrl(String newCloudUrl) {
            this.newCloudUrl = newCloudUrl;
        }

        public Boolean getNoCheckCertificate() {
            return this.noCheckCertificate;
        }

        public void setNoCheckCertificate(Boolean noCheckCertificate) {
            this.noCheckCertificate = noCheckCertificate;
        }

        public Boolean getIsProxy() {
            return this.isProxy;
        }

        public void setIsProxy(Boolean isProxy) {
            this.isProxy = isProxy;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public Integer getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
        }

        public String getProxyUser() {
            return this.proxyUser;
        }

        public void setProxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
        }

        public String getProxyPassword() {
            return Secret.fromString((String)this.proxyPassword).getPlainText();
        }

        public void setProxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
        }
    }
}

