/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import com.testdroid.jenkins.model.TestRunStateCheckMethod;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class WaitForResultsBlock
implements Describable<WaitForResultsBlock> {
    boolean downloadScreenshots;
    boolean forceFinishAfterBreak;
    String hookURL;
    String resultsPath;
    TestRunStateCheckMethod testRunStateCheckMethod;
    Integer waitForResultsTimeout;

    public Descriptor<WaitForResultsBlock> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptorOrDie(this.getClass());
    }

    @DataBoundConstructor
    public WaitForResultsBlock(String testRunStateCheckMethod, String hookURL, String waitForResultsTimeout, String resultsPath, boolean downloadScreenshots, boolean forceFinishAfterBreak) {
        this.testRunStateCheckMethod = StringUtils.isBlank((String)testRunStateCheckMethod) ? TestRunStateCheckMethod.HOOK_URL : TestRunStateCheckMethod.valueOf(testRunStateCheckMethod.toUpperCase());
        this.hookURL = hookURL;
        this.resultsPath = resultsPath;
        this.downloadScreenshots = downloadScreenshots;
        this.forceFinishAfterBreak = forceFinishAfterBreak;
        this.waitForResultsTimeout = NumberUtils.toInt((String)waitForResultsTimeout);
    }

    public String getHookURL() {
        return this.hookURL;
    }

    public void setHookURL(String hookURL) {
        this.hookURL = hookURL;
    }

    public Integer getWaitForResultsTimeout() {
        if (this.waitForResultsTimeout == null) {
            this.waitForResultsTimeout = 0;
        }
        return this.waitForResultsTimeout;
    }

    public void setWaitForResultsTimeout(Integer waitForResultsTimeout) {
        this.waitForResultsTimeout = waitForResultsTimeout;
    }

    public String getResultsPath() {
        return this.resultsPath;
    }

    public void setResultsPath(String resultsPath) {
        this.resultsPath = resultsPath;
    }

    public boolean isDownloadScreenshots() {
        return this.downloadScreenshots;
    }

    public void setDownloadScreenshots(boolean downloadScreenshots) {
        this.downloadScreenshots = downloadScreenshots;
    }

    public TestRunStateCheckMethod getTestRunStateCheckMethod() {
        if (this.testRunStateCheckMethod == null) {
            this.testRunStateCheckMethod = TestRunStateCheckMethod.HOOK_URL;
        }
        return this.testRunStateCheckMethod;
    }

    public void setTestRunStateCheckMethod(TestRunStateCheckMethod testRunStateCheckMethod) {
        this.testRunStateCheckMethod = testRunStateCheckMethod;
    }

    public boolean isForceFinishAfterBreak() {
        return this.forceFinishAfterBreak;
    }

    public void setForceFinishAfterBreak(boolean forceFinishAfterBreak) {
        this.forceFinishAfterBreak = forceFinishAfterBreak;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<WaitForResultsBlock> {
        public DescriptorImpl() {
            super(WaitForResultsBlock.class);
        }

        public String getDisplayName() {
            return "Wait for Bitbar Cloud results";
        }
    }
}

