/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.utils;

import com.testdroid.api.APIClient;
import com.testdroid.api.DefaultAPIClient;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.utils.ApiClientAdapter;
import hudson.Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;

@Extension
public class TestdroidApiUtil {
    private static final Logger LOGGER = Logger.getLogger(TestdroidApiUtil.class.getName());
    private static final List<String> PAID_ROLES = new ArrayList<String>();
    private ApiClientAdapter apiClientAdapter;

    public static TestdroidApiUtil getInstance() {
        return (TestdroidApiUtil)Jenkins.getActiveInstance().getExtensionList(TestdroidApiUtil.class).stream().findFirst().get();
    }

    public static ApiClientAdapter getGlobalApiClient() {
        if (TestdroidApiUtil.getInstance().apiClientAdapter == null) {
            TestdroidApiUtil.createGlobalApiClient(new TestdroidCloudSettings.DescriptorImpl());
        }
        return TestdroidApiUtil.getInstance().apiClientAdapter;
    }

    public static ApiClientAdapter createGlobalApiClient(TestdroidCloudSettings.DescriptorImpl settings) {
        TestdroidApiUtil.getInstance().apiClientAdapter = TestdroidApiUtil.getInstance().createApiClientHelper(settings);
        return TestdroidApiUtil.getInstance().apiClientAdapter;
    }

    public static ApiClientAdapter createApiClient(TestdroidCloudSettings.DescriptorImpl settings) {
        return TestdroidApiUtil.getInstance().createApiClientHelper(settings);
    }

    private ApiClientAdapter createApiClientHelper(TestdroidCloudSettings.DescriptorImpl settings) {
        DefaultAPIClient apiClient;
        String cloudURL = settings.getActiveCloudUrl();
        String email = settings.getEmail();
        String password = settings.getPassword();
        boolean dontCheckCert = settings.getNoCheckCertificate();
        if (settings.getIsProxy().booleanValue()) {
            HttpHost proxy = settings.getProxyPort() != null ? new HttpHost(settings.getProxyHost(), settings.getProxyPort().intValue(), "http") : new HttpHost(settings.getProxyHost());
            apiClient = StringUtils.isBlank((String)settings.getProxyUser()) ? new DefaultAPIClient(cloudURL, email, password, proxy, dontCheckCert) : new DefaultAPIClient(cloudURL, email, password, proxy, settings.getProxyUser(), settings.getProxyPassword(), dontCheckCert);
        } else {
            apiClient = new DefaultAPIClient(cloudURL, email, password, dontCheckCert);
        }
        return new ApiClientAdapter((APIClient)apiClient, settings);
    }

    static {
        PAID_ROLES.add("PRIORITY_SILVER");
        PAID_ROLES.add("PRIORITY_GOLD");
        PAID_ROLES.add("PRIORITY_PLATINUM");
        PAID_ROLES.add("PAID_RUN");
    }
}

