/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.scheduler;

import com.testdroid.api.APIException;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APIUser;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.scheduler.TestRunFinishCheckScheduler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class APIDrivenTestFinishCheckScheduler
implements TestRunFinishCheckScheduler {
    private static final Logger LOGGER = Logger.getLogger(APIDrivenTestFinishCheckScheduler.class.getName());
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> taskHandle;

    @Override
    public void schedule(Object object, APIUser user, Long projectId, Long testRunId) {
        Runnable beeper = () -> {
            LOGGER.info(Messages.CHECK_FOR_TESTRUN_STATE(testRunId));
            if (this.checkResult(user, projectId, testRunId)) {
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
            }
        };
        this.taskHandle = this.scheduler.scheduleAtFixedRate(beeper, 60L, 60L, TimeUnit.SECONDS);
    }

    @Override
    public void cancel(Long projectId, Long testRunId) {
        if (this.taskHandle != null) {
            this.taskHandle.cancel(true);
        }
    }

    private boolean checkResult(APIUser user, Long projectId, Long testRunId) {
        boolean result = false;
        try {
            APITestRun testRun = user.getProject(projectId).getTestRun(testRunId);
            if (testRun.getState() == APITestRun.State.FINISHED) {
                result = true;
            }
        }
        catch (APIException exc) {
            LOGGER.log(Level.SEVERE, Messages.API_GET_TESTRUN_ERROR(testRunId), exc);
        }
        return result;
    }
}

