/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import com.testdroid.api.APIException;
import com.testdroid.api.model.notification.APINotificationScope;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.remotesupport.MachineIndependentTask;
import com.testdroid.jenkins.utils.TestdroidApiUtil;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TestdroidCloudSettings
implements Describable<TestdroidCloudSettings> {
    private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());

    public Descriptor<TestdroidCloudSettings> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TestdroidCloudSettings> {
        private static final String DEFAULT_CLOUD_URL = "https://cloud.bitbar.com";
        String cloudUrl;
        String newCloudUrl;
        String email;
        String password;
        boolean isProxy;
        boolean noCheckCertificate;
        String notificationEmail = "";
        String notificationEmailType = "";
        boolean privateInstanceState;
        String proxyHost;
        String proxyPassword;
        Integer proxyPort;
        String proxyUser;

        public DescriptorImpl() {
            this.load();
        }

        DescriptorImpl(String email, String password) {
            this();
            this.email = email;
            this.password = password;
        }

        DescriptorImpl(String cloudUrl, String email, String password) {
            this(email, password);
            this.cloudUrl = cloudUrl;
        }

        public DescriptorImpl(MachineIndependentTask task) {
            this.cloudUrl = task.cloudUrl;
            this.email = task.user;
            this.password = task.password;
            this.isProxy = task.isProxy;
            this.noCheckCertificate = task.noCheckCertificate;
            this.privateInstanceState = task.privateInstance;
            this.proxyHost = task.proxyHost;
            this.proxyPassword = task.proxyPassword;
            this.proxyPort = task.proxyPort;
            this.proxyUser = task.proxyUser;
        }

        public String getDisplayName() {
            return Messages.PLUGIN_NAME();
        }

        public void save() {
            this.password = Secret.fromString((String)this.password).getEncryptedValue();
            this.proxyPassword = Secret.fromString((String)this.proxyPassword).getEncryptedValue();
            TestdroidApiUtil.createGlobalApiClient(this);
            super.save();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindParameters((Object)this);
            super.configure(req, json);
            this.save();
            return true;
        }

        public FormValidation doAuthorize(@QueryParameter String email, @QueryParameter String password, @QueryParameter String cloudUrl, @QueryParameter boolean privateInstanceState, @QueryParameter boolean noCheckCertificate, @QueryParameter boolean isProxy, @QueryParameter String proxyHost, @QueryParameter Integer proxyPort, @QueryParameter String proxyUser, @QueryParameter String proxyPassword) {
            this.email = email;
            this.password = password;
            this.cloudUrl = cloudUrl;
            this.privateInstanceState = privateInstanceState;
            this.noCheckCertificate = noCheckCertificate;
            this.isProxy = isProxy;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
            try {
                TestdroidApiUtil.createApiClient(this).tryValidateConfig();
                this.save();
                return FormValidation.ok((String)Messages.AUTHORIZATION_OK());
            }
            catch (APIException e) {
                this.password = null;
                this.load();
                LOGGER.log(Level.WARNING, Messages.ERROR_API());
                return FormValidation.error((String)e.getLocalizedMessage());
            }
        }

        public ListBoxModel doFillNotificationEmailTypeItems() {
            ListBoxModel emailNotificationTypes = new ListBoxModel();
            emailNotificationTypes.add(Messages.ALWAYS(), APINotificationScope.TEST_RUN.name());
            emailNotificationTypes.add(Messages.ON_FAILURE_ONLY(), APINotificationScope.TEST_RUN_FAILURE.name());
            emailNotificationTypes.add(Messages.ON_SUCCESS_ONLY(), APINotificationScope.TEST_RUN_SUCCEEDED.name());
            return emailNotificationTypes;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DescriptorImpl)) {
                return false;
            }
            DescriptorImpl other = (DescriptorImpl)((Object)obj);
            boolean stringParamsMatch = StringUtils.equals((String)this.cloudUrl, (String)other.cloudUrl) && StringUtils.equals((String)this.newCloudUrl, (String)other.newCloudUrl) && StringUtils.equals((String)this.email, (String)other.email) && StringUtils.equals((String)this.password, (String)other.password) && StringUtils.equals((String)this.notificationEmail, (String)other.notificationEmail) && StringUtils.equals((String)this.notificationEmailType, (String)other.notificationEmailType) && StringUtils.equals((String)this.proxyHost, (String)other.proxyHost) && StringUtils.equals((String)this.proxyPassword, (String)other.proxyPassword) && StringUtils.equals((String)this.proxyUser, (String)other.proxyUser);
            return stringParamsMatch && this.isProxy == other.isProxy && this.proxyPort == other.proxyPort && this.noCheckCertificate == other.noCheckCertificate && this.privateInstanceState == other.privateInstanceState;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getPassword() {
            return Secret.fromString((String)this.password).getPlainText();
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean getPrivateInstanceState() {
            return this.privateInstanceState;
        }

        public void setPrivateInstanceState(boolean privateInstanceState) {
            this.privateInstanceState = privateInstanceState;
        }

        public String getActiveCloudUrl() {
            if (this.privateInstanceState && StringUtils.isNotBlank((String)this.newCloudUrl)) {
                return this.newCloudUrl;
            }
            if (this.privateInstanceState && StringUtils.isNotBlank((String)this.cloudUrl)) {
                return this.cloudUrl;
            }
            return DEFAULT_CLOUD_URL;
        }

        public String getCloudUrl() {
            return this.cloudUrl;
        }

        public void setCloudUrl(String cloudUrl) {
            this.cloudUrl = cloudUrl;
        }

        public String getNewCloudUrl() {
            return this.newCloudUrl;
        }

        public void setNewCloudUrl(String newCloudUrl) {
            this.newCloudUrl = newCloudUrl;
        }

        public Boolean getNoCheckCertificate() {
            return this.noCheckCertificate;
        }

        public void setNoCheckCertificate(Boolean noCheckCertificate) {
            this.noCheckCertificate = noCheckCertificate;
        }

        public Boolean getIsProxy() {
            return this.isProxy;
        }

        public void setIsProxy(Boolean isProxy) {
            this.isProxy = isProxy;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public Integer getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
        }

        public String getProxyUser() {
            return this.proxyUser;
        }

        public void setProxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
        }

        public String getProxyPassword() {
            return Secret.fromString((String)this.proxyPassword).getPlainText();
        }

        public void setProxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
        }

        public String getNotificationEmail() {
            return this.notificationEmail;
        }

        public void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        public String getNotificationEmailType() {
            if (StringUtils.isNotBlank((String)this.notificationEmailType)) {
                return DescriptorImpl.migrateNotificationEmailType(this.notificationEmailType);
            }
            return this.notificationEmailType;
        }

        public static String migrateNotificationEmailType(String notificationEmailType) {
            switch (notificationEmailType) {
                case "ON_FAILURE": {
                    return APINotificationScope.TEST_RUN_FAILURE.name();
                }
            }
            return APINotificationScope.TEST_RUN.name();
        }

        public void setNotificationEmailType(String notificationEmailType) {
            this.notificationEmailType = notificationEmailType;
        }
    }
}

