/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractBuilder
extends Builder {
    private static final Logger LOGGER = Logger.getLogger(AbstractBuilder.class.getName());

    public static String applyMacro(Run<?, ?> build, TaskListener listener, String macro) {
        if (build instanceof AbstractBuild) {
            try {
                EnvVars envVars = new EnvVars(Computer.currentComputer().getEnvironment());
                envVars.putAll((Map)build.getEnvironment(listener));
                envVars.putAll(((AbstractBuild)build).getBuildVariables());
                return Util.replaceMacro((String)macro, (Map)envVars);
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.SEVERE, "Failed to apply macro " + AbstractBuilder.safe(macro), e);
            }
        }
        return macro;
    }

    private static String safe(String value) {
        return value.replaceAll("[\\n\\r]", "_");
    }
}

