/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.utils;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIException;
import com.testdroid.api.DefaultAPIClient;
import com.testdroid.api.model.APIUser;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;

public class TestdroidApiUtil {
    private static final String CLOUD_ENDPOINT = "https://cloud.testdroid.com";
    private static final Logger LOGGER = Logger.getLogger(TestdroidApiUtil.class.getName());
    private static TestdroidApiUtil instance;
    private APIClient client;
    private String cloudUrl;
    private String email;
    private boolean isProxy;
    private boolean noCheckCertificate;
    private String password;
    private String proxyHost;
    private String proxyPassword;
    private Integer proxyPort;
    private String proxyUser;

    private TestdroidApiUtil(String email, String password, String cloudUrl, boolean privateInstanceState, boolean noCheckCertificate, boolean isProxy, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) {
        this.email = email;
        this.password = password;
        this.cloudUrl = !privateInstanceState || StringUtils.isEmpty((String)cloudUrl) ? CLOUD_ENDPOINT : cloudUrl;
        this.noCheckCertificate = noCheckCertificate;
        this.isProxy = isProxy;
        if (isProxy) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
        }
    }

    public static TestdroidApiUtil init(String email, String password, String cloudUrl, boolean privateInstanceState, boolean noCheckCertificate, boolean isProxy, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) {
        if (instance == null) {
            instance = new TestdroidApiUtil(email, password, cloudUrl, privateInstanceState, noCheckCertificate, isProxy, proxyHost, proxyPort, proxyUser, proxyPassword);
        }
        return instance;
    }

    public static void clean() {
        instance = null;
    }

    public static TestdroidApiUtil getInstance() {
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public APIClient getTestdroidAPIClient() {
        if (this.client == null) {
            if (this.isProxy) {
                HttpHost proxy = this.proxyPort != null ? new HttpHost(this.proxyHost, this.proxyPort.intValue(), "http") : new HttpHost(this.proxyHost);
                this.client = StringUtils.isBlank((String)this.proxyUser) ? new DefaultAPIClient(this.cloudUrl, this.email, this.password, proxy, this.noCheckCertificate) : new DefaultAPIClient(this.cloudUrl, this.email, this.password, proxy, this.proxyUser, this.proxyPassword, this.noCheckCertificate);
            } else {
                this.client = new DefaultAPIClient(this.cloudUrl, this.email, this.password, this.noCheckCertificate);
            }
        }
        return this.client;
    }

    public APIUser getUser() throws APIException {
        APIUser user;
        try {
            user = this.getTestdroidAPIClient().me();
        }
        catch (APIException e) {
            LOGGER.log(Level.INFO, "ApiException occurred during get user from client. Client will be recreated");
            this.client = null;
            user = this.getTestdroidAPIClient().me();
        }
        return user;
    }
}

