/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import com.testdroid.api.APIException;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.model.APIDeviceGroup;
import com.testdroid.api.model.APINotificationEmail;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APIRole;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APITestRunParameter;
import com.testdroid.api.model.APIUser;
import com.testdroid.jenkins.AbstractBuilder;
import com.testdroid.jenkins.CloudLink;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.RunInCloudEnvInject;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.model.TestRunStateCheckMethod;
import com.testdroid.jenkins.remotesupport.MachineIndependentFileUploader;
import com.testdroid.jenkins.remotesupport.MachineIndependentResultsDownloader;
import com.testdroid.jenkins.scheduler.TestRunFinishCheckScheduler;
import com.testdroid.jenkins.scheduler.TestRunFinishCheckSchedulerFactory;
import com.testdroid.jenkins.utils.AndroidLocale;
import com.testdroid.jenkins.utils.EmailHelper;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class RunInCloudBuilder
extends AbstractBuilder {
    private static final transient Logger LOGGER = Logger.getLogger(RunInCloudBuilder.class.getSimpleName());
    private static final transient String POST_HOOK_URL = "/plugin/testdroid-run-in-cloud/api/json/cloud-webhook";
    private static final List<String> PAID_ROLES = new ArrayList<String>(){
        {
            this.add("PRIORITY_SILVER");
            this.add("PRIORITY_GOLD");
            this.add("PRIORITY_PLATINUM");
            this.add("PAID_RUN");
        }
    };
    private String appPath;
    private String clusterId;
    private String dataPath;
    private boolean failBuildIfThisStepFailed;
    private String keyValuePairs;
    private String language;
    private String notificationEmail = "";
    private String notificationEmailType = String.valueOf(APINotificationEmail.Type.ALWAYS);
    private String projectId;
    private String scheduler;
    private String screenshotsDirectory;
    private String testCasesSelect;
    private String testCasesValue;
    private String testPath;
    private String testRunName;
    private String testRunner;
    private WaitForResultsBlock waitForResultsBlock;
    private String withAnnotation;
    private String withoutAnnotation;
    private String testTimeout;

    @DataBoundConstructor
    public RunInCloudBuilder(String projectId, String appPath, String testPath, String dataPath, String testRunName, String scheduler, String testRunner, String clusterId, String language, String notificationEmail, String screenshotsDirectory, String keyValuePairs, String withAnnotation, String withoutAnnotation, String testCasesSelect, String testCasesValue, String notificationEmailType, Boolean failBuildIfThisStepFailed, WaitForResultsBlock waitForResultsBlock, String testTimeout) {
        this.projectId = projectId;
        this.appPath = appPath;
        this.dataPath = dataPath;
        this.testPath = testPath;
        this.testRunName = testRunName;
        this.scheduler = scheduler;
        this.testRunner = testRunner;
        this.screenshotsDirectory = screenshotsDirectory;
        this.keyValuePairs = keyValuePairs;
        this.withAnnotation = withAnnotation;
        this.withoutAnnotation = withoutAnnotation;
        this.testCasesSelect = testCasesSelect;
        this.testCasesValue = testCasesValue;
        this.clusterId = clusterId;
        this.language = language;
        this.notificationEmail = notificationEmail;
        this.notificationEmailType = notificationEmailType;
        this.failBuildIfThisStepFailed = failBuildIfThisStepFailed;
        this.waitForResultsBlock = waitForResultsBlock;
        this.testTimeout = testTimeout;
    }

    public String getTestRunName() {
        return this.testRunName;
    }

    public void setTestRunName(String testRunName) {
        this.testRunName = testRunName;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public String getTestPath() {
        return this.testPath;
    }

    public void setTestPath(String testPath) {
        this.testPath = testPath;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getTestRunner() {
        return this.testRunner;
    }

    public void setTestRunner(String testRunner) {
        this.testRunner = testRunner;
    }

    public String getScreenshotsDirectory() {
        return this.screenshotsDirectory;
    }

    public void setScreenshotsDirectory(String screenshotsDirectory) {
        this.screenshotsDirectory = screenshotsDirectory;
    }

    public String getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public void setKeyValuePairs(String keyValuePairs) {
        this.keyValuePairs = keyValuePairs;
    }

    public String getWithAnnotation() {
        return this.withAnnotation;
    }

    public void setWithAnnotation(String withAnnotation) {
        this.withAnnotation = withAnnotation;
    }

    public String getWithoutAnnotation() {
        return this.withoutAnnotation;
    }

    public void setWithoutAnnotation(String withoutAnnotation) {
        this.withoutAnnotation = withoutAnnotation;
    }

    public String getTestCasesSelect() {
        return this.testCasesSelect;
    }

    public void setTestCasesSelect(String testCasesSelect) {
        this.testCasesSelect = testCasesSelect;
    }

    public String getTestCasesValue() {
        return this.testCasesValue;
    }

    public void setTestCasesValue(String testCasesValue) {
        this.testCasesValue = testCasesValue;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public String getLanguage() {
        if (this.language == null) {
            this.language = String.format("%s-%s", Locale.ENGLISH.getLanguage(), Locale.ENGLISH.getCountry());
        }
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = APITestRunConfig.Scheduler.PARALLEL.toString();
        }
        return this.scheduler;
    }

    public void setScheduler(String scheduler) {
        this.scheduler = scheduler.toLowerCase();
    }

    public String getNotificationEmail() {
        return this.notificationEmail;
    }

    public void setNotificationEmail(String notificationEmail) {
        this.notificationEmail = notificationEmail;
    }

    public String getNotificationEmailType() {
        return this.notificationEmailType;
    }

    public void setNotificationEmailType(String notificationEmailType) {
        this.notificationEmailType = notificationEmailType;
    }

    public String getTestTimeout() {
        return this.testTimeout;
    }

    public void setTestTimeout(String testTimeout) {
        this.testTimeout = testTimeout;
    }

    public WaitForResultsBlock getWaitForResultsBlock() {
        return this.waitForResultsBlock;
    }

    public void setWaitForResultsBlock(WaitForResultsBlock waitForResultsBlock) {
        this.waitForResultsBlock = waitForResultsBlock;
    }

    public boolean isFailBuildIfThisStepFailed() {
        return this.failBuildIfThisStepFailed;
    }

    public void setFailBuildIfThisStepFailed(boolean failBuildIfThisStepFailed) {
        this.failBuildIfThisStepFailed = failBuildIfThisStepFailed;
    }

    public boolean isFullTest() {
        return StringUtils.isNotBlank((String)this.testPath);
    }

    public boolean isDataFile() {
        return StringUtils.isNotBlank((String)this.dataPath);
    }

    private boolean verifyParameters(BuildListener listener) {
        boolean result = true;
        if (StringUtils.isBlank((String)this.appPath)) {
            listener.getLogger().println(Messages.ERROR_APP_PATH() + "\n");
            result = false;
        }
        if (StringUtils.isBlank((String)this.projectId)) {
            listener.getLogger().println(Messages.EMPTY_PROJECT() + "\n");
            result = false;
        }
        if (this.isFullTest() && StringUtils.isBlank((String)this.testPath)) {
            listener.getLogger().println(Messages.ERROR_INSTRUMENTATION_PATH());
            result = false;
        }
        return result;
    }

    public boolean isWaitForResults() {
        return this.waitForResultsBlock != null;
    }

    private String evaluateHookUrl() {
        return this.isWaitForResults() ? (StringUtils.isNotBlank((String)this.waitForResultsBlock.getHookURL()) ? this.waitForResultsBlock.getHookURL() : String.format("%s%s", Hudson.getInstance().getRootUrl(), POST_HOOK_URL)) : null;
    }

    private String evaluateResultsPath(AbstractBuild<?, ?> build) {
        return this.isWaitForResults() ? (StringUtils.isNotBlank((String)this.waitForResultsBlock.getResultsPath()) ? this.waitForResultsBlock.getResultsPath() : build.getWorkspace().getRemote()) : null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        listener.getLogger().println(Messages.RUN_TEST_IN_CLOUD_STARTED());
        boolean result = this.runTest(build, launcher, listener);
        if (result) {
            listener.getLogger().println(Messages.RUN_TEST_IN_CLOUD_SUCCEEDED());
        } else {
            listener.getLogger().println(Messages.RUN_TEST_IN_CLOUD_FAILED());
        }
        return result || !this.failBuildIfThisStepFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTest(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        String appPathFinal = RunInCloudBuilder.applyMacro(build, listener, this.appPath);
        String testPathFinal = RunInCloudBuilder.applyMacro(build, listener, this.testPath);
        String dataPathFinal = RunInCloudBuilder.applyMacro(build, listener, this.dataPath);
        String withAnnotationFinal = RunInCloudBuilder.applyMacro(build, listener, this.withAnnotation);
        String testRunnerFinal = RunInCloudBuilder.applyMacro(build, listener, this.testRunner);
        String withoutAnnotationFinal = RunInCloudBuilder.applyMacro(build, listener, this.withoutAnnotation);
        TestdroidCloudSettings.DescriptorImpl descriptor = TestdroidCloudSettings.descriptor();
        TestdroidCloudSettings plugin = TestdroidCloudSettings.getInstance();
        boolean releaseDone = false;
        try {
            plugin.getSemaphore().acquire();
            if (!this.verifyParameters(listener)) {
                boolean bl = false;
                return bl;
            }
            APIUser user = descriptor.getUser();
            APIProject project = user.getProject(Long.valueOf(Long.parseLong(this.projectId.trim())));
            if (project == null) {
                listener.getLogger().println(Messages.CHECK_PROJECT_NAME());
                boolean bl = false;
                return bl;
            }
            this.updateUserEmailNotifications(user, project);
            APITestRunConfig config = project.getTestRunConfig();
            if (!this.isFullTest()) {
                config.setMode(project.getType() == APIProject.Type.ANDROID ? APITestRunConfig.Mode.APP_CRAWLER : APITestRunConfig.Mode.IOS_CRAWLER);
            } else {
                config.setMode(this.projectTypeToConfigMode(project.getType()));
            }
            config.setDeviceLanguageCode(this.language);
            config.setScheduler(APITestRunConfig.Scheduler.valueOf((String)this.scheduler));
            config.setUsedDeviceGroupId(Long.valueOf(Long.parseLong(this.clusterId)));
            config.setHookURL(this.evaluateHookUrl());
            config.setScreenshotDir(this.screenshotsDirectory);
            config.setInstrumentationRunner(testRunnerFinal);
            config.setWithoutAnnotation(withoutAnnotationFinal);
            config.setWithAnnotation(withAnnotationFinal);
            if (this.getDescriptor().isPaidUser()) {
                try {
                    config.setTimeout(Long.valueOf(Long.parseLong(this.testTimeout)));
                }
                catch (NumberFormatException ignored) {
                    listener.getLogger().println(String.format(Messages.TEST_TIMEOUT_NOT_NUMERIC_VALUE(), this.testTimeout));
                    config.setTimeout(Long.valueOf(600L));
                }
            } else {
                config.setTimeout(Long.valueOf(600L));
            }
            this.setLimitations(build, listener, config);
            this.deleteExistingParameters(config);
            this.createProvidedParameters(config);
            config.update();
            this.printTestJob(project, config, listener);
            this.getDescriptor().save();
            FilePath appFile = new FilePath(launcher.getChannel(), this.getAbsolutePath(build, appPathFinal));
            listener.getLogger().println(String.format(Messages.UPLOADING_NEW_APPLICATION_S(), appPathFinal));
            Long testFileId = null;
            Long dataFileId = null;
            Long appFileId = (Long)appFile.act((FilePath.FileCallable)new MachineIndependentFileUploader(descriptor, project.getId(), MachineIndependentFileUploader.FILE_TYPE.APPLICATION, listener));
            if (appFileId == null) {
                boolean bl = false;
                return bl;
            }
            if (this.isFullTest()) {
                FilePath testFile = new FilePath(launcher.getChannel(), this.getAbsolutePath(build, testPathFinal));
                listener.getLogger().println(String.format(Messages.UPLOADING_NEW_INSTRUMENTATION_S(), testPathFinal));
                testFileId = (Long)testFile.act((FilePath.FileCallable)new MachineIndependentFileUploader(descriptor, project.getId(), MachineIndependentFileUploader.FILE_TYPE.TEST, listener));
                if (testFileId == null) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (this.isDataFile()) {
                FilePath dataFile = new FilePath(launcher.getChannel(), this.getAbsolutePath(build, dataPathFinal));
                listener.getLogger().println(String.format(Messages.UPLOADING_DATA_FILE_S(), dataPathFinal));
                dataFileId = (Long)dataFile.act((FilePath.FileCallable)new MachineIndependentFileUploader(descriptor, project.getId(), MachineIndependentFileUploader.FILE_TYPE.DATA, listener));
                if (dataFileId == null) {
                    boolean bl = false;
                    return bl;
                }
            }
            listener.getLogger().println(Messages.RUNNING_TESTS());
            String finalTestRunName = RunInCloudBuilder.applyMacro(build, listener, this.testRunName);
            finalTestRunName = StringUtils.isBlank((String)finalTestRunName) || finalTestRunName.trim().startsWith("$") ? null : finalTestRunName;
            APITestRun testRun = project.runWithConfig(finalTestRunName, null, config, appFileId, testFileId, dataFileId);
            String cloudLinkPrefix = descriptor.getPrivateInstanceState() ? (StringUtils.isNotBlank((String)descriptor.getNewCloudUrl()) ? descriptor.getNewCloudUrl() : descriptor.getCloudUrl()) : "https://cloud.testdroid.com";
            String cloudLink = String.format("%s/#service/testrun/%s/%s", cloudLinkPrefix, testRun.getProjectId(), testRun.getId());
            build.getActions().add(new CloudLink(build, cloudLink));
            RunInCloudEnvInject variable = new RunInCloudEnvInject("CLOUD_LINK", cloudLink);
            build.addAction((Action)variable);
            plugin.getSemaphore().release();
            releaseDone = true;
            boolean bl = this.waitForResults(project, testRun, build, launcher, listener);
            return bl;
        }
        catch (APIException e) {
            listener.getLogger().println(String.format("%s: %s", Messages.ERROR_API(), e.getMessage()));
            LOGGER.log(Level.WARNING, Messages.ERROR_API(), e);
        }
        catch (IOException e) {
            listener.getLogger().println(String.format("%s: %s", Messages.ERROR_CONNECTION(), e.getLocalizedMessage()));
            LOGGER.log(Level.WARNING, Messages.ERROR_CONNECTION(), e);
        }
        catch (InterruptedException e) {
            listener.getLogger().println(String.format("%s: %s", Messages.ERROR_TESTDROID(), e.getLocalizedMessage()));
            LOGGER.log(Level.WARNING, Messages.ERROR_TESTDROID(), e);
        }
        catch (NumberFormatException e) {
            listener.getLogger().println(Messages.NO_DEVICE_GROUP_CHOSEN());
            LOGGER.log(Level.WARNING, Messages.NO_DEVICE_GROUP_CHOSEN());
        }
        finally {
            if (!releaseDone) {
                plugin.getSemaphore().release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForResults(APIProject project, APITestRun testRun, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean isDownloadOk = true;
        if (this.isWaitForResults()) {
            TestRunFinishCheckScheduler scheduler = TestRunFinishCheckSchedulerFactory.createTestRunFinishScheduler(this.waitForResultsBlock.getTestRunStateCheckMethod());
            try {
                String msg;
                boolean testRunToAbort = false;
                listener.getLogger().println("Waiting for results...");
                scheduler.schedule((Object)this, project.getId(), testRun.getId());
                try {
                    RunInCloudBuilder runInCloudBuilder = this;
                    synchronized (runInCloudBuilder) {
                        ((Object)((Object)this)).wait(this.waitForResultsBlock.getWaitForResultsTimeout() * 1000);
                    }
                    scheduler.cancel(project.getId(), testRun.getId());
                    testRun.refresh();
                    if (testRun.getState() == APITestRun.State.FINISHED) {
                        isDownloadOk = (Boolean)launcher.getChannel().call((Callable)new MachineIndependentResultsDownloader(TestdroidCloudSettings.descriptor(), listener, project.getId(), testRun.getId(), this.evaluateResultsPath(build), this.waitForResultsBlock.isDownloadScreenshots()));
                        if (!isDownloadOk) {
                            listener.getLogger().println(Messages.DOWNLOAD_RESULTS_FAILED());
                            LOGGER.log(Level.WARNING, Messages.DOWNLOAD_RESULTS_FAILED());
                        }
                    } else {
                        testRunToAbort = true;
                        isDownloadOk = false;
                        msg = String.format(Messages.DOWNLOAD_RESULTS_FAILED_WITH_REASON_S(), "Test run is not finished yet!");
                        listener.getLogger().println(msg);
                        LOGGER.log(Level.WARNING, msg);
                    }
                }
                catch (InterruptedException e) {
                    testRunToAbort = true;
                    listener.getLogger().println(e.getMessage());
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
                if (testRunToAbort && this.waitForResultsBlock.forceFinishAfterBreak) {
                    msg = "Force finish test in Cloud";
                    listener.getLogger().println(msg);
                    LOGGER.log(Level.WARNING, msg);
                    testRun.abort();
                }
            }
            catch (APIException e) {
                listener.getLogger().println(String.format("%s: %s", Messages.ERROR_API(), e.getMessage()));
                LOGGER.log(Level.WARNING, Messages.ERROR_API(), e);
            }
            catch (IOException e) {
                listener.getLogger().println(String.format("%s: %s", Messages.ERROR_CONNECTION(), e.getLocalizedMessage()));
                LOGGER.log(Level.WARNING, Messages.ERROR_CONNECTION(), e);
            }
            finally {
                scheduler.cancel(project.getId(), testRun.getId());
            }
        }
        return isDownloadOk;
    }

    private void setLimitations(AbstractBuild<?, ?> build, BuildListener listener, APITestRunConfig config) throws APIException {
        if (StringUtils.isNotBlank((String)this.testCasesValue)) {
            config.setLimitationType(APITestRunConfig.LimitationType.valueOf((String)this.testCasesSelect));
            config.setLimitationValue(RunInCloudBuilder.applyMacro(build, listener, this.testCasesValue));
        } else {
            config.setLimitationType(null);
            config.setLimitationValue("");
        }
    }

    private void deleteExistingParameters(APITestRunConfig config) throws APIException {
        if (this.getDescriptor().isAdmin()) {
            List parameters = config.getParameters(new APIQueryBuilder().limit(Integer.MAX_VALUE)).getEntity().getData();
            for (APITestRunParameter parameter : parameters) {
                config.deleteParameter(parameter.getId().longValue());
            }
        }
    }

    private void createProvidedParameters(APITestRunConfig config) throws APIException {
        if (this.getDescriptor().isAdmin() && this.keyValuePairs != null) {
            String[] splitKeyValuePairs;
            for (String splitKeyValuePair : splitKeyValuePairs = this.keyValuePairs.split(";")) {
                String[] splitKeyValue;
                if (!StringUtils.isNotBlank((String)splitKeyValuePair) || (splitKeyValue = splitKeyValuePair.split(":")).length != 2) continue;
                config.createParameter(splitKeyValue[0], splitKeyValue[1]);
            }
        }
    }

    private void printTestJob(APIProject project, APITestRunConfig config, BuildListener listener) {
        listener.getLogger().println(Messages.TEST_RUN_CONFIGURATION());
        listener.getLogger().println(String.format("%s: %s", Messages.PROJECT(), project.getName()));
        listener.getLogger().println(String.format("%s: %s", Messages.LOCALE(), config.getDeviceLanguageCode()));
        listener.getLogger().println(String.format("%s: %s", Messages.SCHEDULER(), config.getScheduler()));
        listener.getLogger().println(String.format("%s: %s", Messages.APP_CRAWLER(), config.getMode() == APITestRunConfig.Mode.APP_CRAWLER || config.getMode() == APITestRunConfig.Mode.IOS_CRAWLER));
        listener.getLogger().println(String.format("%s: %s", Messages.PRICE(), config.getCreditsPrice()));
        listener.getLogger().println(String.format("%s: %s", Messages.TIMEOUT(), config.getTimeout()));
    }

    private String getAbsolutePath(AbstractBuild<?, ?> build, String path) throws IOException, InterruptedException {
        if (StringUtils.isBlank((String)path)) {
            return "";
        }
        String trimmed = StringUtils.trim((String)path);
        if (trimmed.startsWith(File.separator)) {
            return trimmed;
        }
        URI workspaceURI = build.getWorkspace().toURI();
        return workspaceURI.getPath() + trimmed;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private APITestRunConfig.Mode projectTypeToConfigMode(APIProject.Type type) {
        return APITestRunConfig.Mode.valueOf((String)type.toString().replace(APIProject.Type.ANDROID.toString(), APITestRunConfig.Mode.FULL_RUN.toString()));
    }

    private void updateUserEmailNotifications(APIUser user, APIProject project) {
        try {
            APINotificationEmail.Type neType = APINotificationEmail.Type.valueOf((String)TestdroidCloudSettings.descriptor().getNotificationEmailType());
            List<String> emailAddressesToSet = EmailHelper.getEmailAddresses(TestdroidCloudSettings.descriptor().getNotificationEmail());
            List currentEmails = user.getNotificationEmails().getEntity().getData();
            for (APINotificationEmail aPINotificationEmail : currentEmails) {
                if (!emailAddressesToSet.contains(aPINotificationEmail.getEmail())) {
                    aPINotificationEmail.delete();
                    continue;
                }
                if (aPINotificationEmail.getType().equals((Object)neType)) continue;
                aPINotificationEmail.setType(neType);
                aPINotificationEmail.refresh();
            }
            for (String string : emailAddressesToSet) {
                if (this.isNotificationEmailContained(currentEmails, string)) continue;
                user.createNotificationEmail(string, neType);
            }
            neType = APINotificationEmail.Type.valueOf((String)this.notificationEmailType);
            emailAddressesToSet = EmailHelper.getEmailAddresses(this.notificationEmail);
            currentEmails = project.getNotificationEmails().getEntity().getData();
            for (APINotificationEmail aPINotificationEmail : currentEmails) {
                if (!emailAddressesToSet.contains(aPINotificationEmail.getEmail())) {
                    aPINotificationEmail.delete();
                    continue;
                }
                if (aPINotificationEmail.getType().equals((Object)neType)) continue;
                aPINotificationEmail.setType(neType);
                aPINotificationEmail.refresh();
            }
            for (String string : emailAddressesToSet) {
                if (this.isNotificationEmailContained(currentEmails, string)) continue;
                project.createNotificationEmail(string, neType);
            }
        }
        catch (APIException e) {
            LOGGER.log(Level.WARNING, Messages.ERROR_API());
        }
    }

    private boolean isNotificationEmailContained(List<APINotificationEmail> notificationEmails, String searchEmail) {
        for (APINotificationEmail notificationEmail : notificationEmails) {
            if (!notificationEmail.getEmail().equals(searchEmail)) continue;
            return true;
        }
        return false;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public DescriptorImpl() {
            super(RunInCloudBuilder.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.TESTDROID_RUN_TESTS_IN_CLOUD();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public boolean isAuthenticated() {
            try {
                return TestdroidCloudSettings.descriptor().getUser() != null;
            }
            catch (APIException e) {
                LOGGER.log(Level.WARNING, Messages.ERROR_API());
                return false;
            }
        }

        public boolean isAdmin() {
            boolean result = false;
            if (this.isAuthenticated()) {
                try {
                    Date now = new Date();
                    APIUser user = TestdroidCloudSettings.descriptor().getUser();
                    for (APIRole role : user.getRoles()) {
                        if (!"ADMIN".equals(role.getName()) || role.getExpireTime() != null && !role.getExpireTime().after(now)) continue;
                        result = true;
                    }
                }
                catch (APIException e) {
                    LOGGER.log(Level.WARNING, Messages.ERROR_API());
                }
            }
            return result;
        }

        public boolean isPaidUser() {
            boolean result = false;
            if (this.isAuthenticated()) {
                try {
                    Date now = new Date();
                    APIUser user = TestdroidCloudSettings.descriptor().getUser();
                    for (APIRole role : user.getRoles()) {
                        if (!PAID_ROLES.contains(role.getName()) || role.getExpireTime() != null && !role.getExpireTime().after(now)) continue;
                        result = true;
                    }
                }
                catch (APIException e) {
                    LOGGER.log(Level.WARNING, Messages.ERROR_API());
                }
            }
            return result;
        }

        public ListBoxModel doFillProjectIdItems() {
            ListBoxModel projects = new ListBoxModel();
            try {
                APIUser user = TestdroidCloudSettings.descriptor().getUser();
                List list = user.getProjectsResource(new APIQueryBuilder().limit(Integer.MAX_VALUE)).getEntity().getData();
                for (APIProject project : list) {
                    projects.add(project.getName(), project.getId().toString());
                }
            }
            catch (APIException e) {
                LOGGER.log(Level.WARNING, Messages.ERROR_API());
            }
            return projects;
        }

        public ListBoxModel doFillSchedulerItems() {
            ListBoxModel schedulers = new ListBoxModel();
            schedulers.add(Messages.SCHEDULER_PARALLEL(), APITestRunConfig.Scheduler.PARALLEL.toString());
            schedulers.add(Messages.SCHEDULER_SERIAL(), APITestRunConfig.Scheduler.SERIAL.toString());
            schedulers.add(Messages.SCHEDULER_SINGLE(), APITestRunConfig.Scheduler.SINGLE.toString());
            return schedulers;
        }

        public ListBoxModel doFillClusterIdItems() {
            ListBoxModel deviceGroups = new ListBoxModel();
            try {
                APIUser user = TestdroidCloudSettings.descriptor().getUser();
                List list = user.getDeviceGroupsResource(new APIQueryBuilder().limit(Integer.MAX_VALUE)).getEntity().getData();
                for (APIDeviceGroup deviceGroup : list) {
                    deviceGroups.add(String.format("%s (%d device(s))", deviceGroup.getDisplayName(), deviceGroup.getDeviceCount()), deviceGroup.getId().toString());
                }
            }
            catch (APIException e) {
                LOGGER.log(Level.WARNING, Messages.ERROR_API());
            }
            return deviceGroups;
        }

        public ListBoxModel doFillLanguageItems() {
            ListBoxModel language = new ListBoxModel();
            for (Locale locale : AndroidLocale.LOCALES) {
                String langDisplay = String.format("%s (%s)", locale.getDisplayLanguage(), locale.getDisplayCountry());
                String langCode = String.format("%s-%s", locale.getLanguage(), locale.getCountry());
                language.add(langDisplay, langCode);
            }
            return language;
        }

        public ListBoxModel doFillNotificationEmailTypeItems() {
            return TestdroidCloudSettings.descriptor().doFillNotificationEmailTypeItems();
        }

        public ListBoxModel doFillTestCasesSelectItems() {
            ListBoxModel testCases = new ListBoxModel();
            for (APITestRunConfig.LimitationType limitationType : APITestRunConfig.LimitationType.values()) {
                String value = limitationType.name();
                testCases.add(value.toLowerCase(), value);
            }
            return testCases;
        }

        public ListBoxModel doFillTestRunStateCheckMethodItems() {
            ListBoxModel items = new ListBoxModel();
            for (TestRunStateCheckMethod method : TestRunStateCheckMethod.values()) {
                items.add(method.name(), method.name());
            }
            return items;
        }
    }

    public static class WaitForResultsBlock {
        private boolean downloadScreenshots;
        private boolean forceFinishAfterBreak;
        private String hookURL = "";
        private String resultsPath = "";
        private TestRunStateCheckMethod testRunStateCheckMethod;
        private Integer waitForResultsTimeout;

        @DataBoundConstructor
        public WaitForResultsBlock(String testRunStateCheckMethod, String hookURL, String waitForResultsTimeout, String resultsPath, boolean downloadScreenshots, boolean forceFinishAfterBreak) {
            TestRunStateCheckMethod parsedEnum;
            this.testRunStateCheckMethod = parsedEnum = TestRunStateCheckMethod.valueOf(testRunStateCheckMethod);
            this.hookURL = hookURL;
            this.resultsPath = resultsPath;
            this.downloadScreenshots = downloadScreenshots;
            this.forceFinishAfterBreak = forceFinishAfterBreak;
            this.waitForResultsTimeout = NumberUtils.toInt((String)waitForResultsTimeout);
        }

        public String getHookURL() {
            return this.hookURL;
        }

        public void setHookURL(String hookURL) {
            this.hookURL = hookURL;
        }

        public Integer getWaitForResultsTimeout() {
            if (this.waitForResultsTimeout == null) {
                this.waitForResultsTimeout = 0;
            }
            return this.waitForResultsTimeout;
        }

        public void setWaitForResultsTimeout(Integer waitForResultsTimeout) {
            this.waitForResultsTimeout = waitForResultsTimeout;
        }

        public String getResultsPath() {
            return this.resultsPath;
        }

        public void setResultsPath(String resultsPath) {
            this.resultsPath = resultsPath;
        }

        public boolean isDownloadScreenshots() {
            return this.downloadScreenshots;
        }

        public void setDownloadScreenshots(boolean downloadScreenshots) {
            this.downloadScreenshots = downloadScreenshots;
        }

        public TestRunStateCheckMethod getTestRunStateCheckMethod() {
            if (this.testRunStateCheckMethod == null) {
                this.testRunStateCheckMethod = TestRunStateCheckMethod.HOOK_URL;
            }
            return this.testRunStateCheckMethod;
        }

        public void setTestRunStateCheckMethod(TestRunStateCheckMethod testRunStateCheckMethod) {
            this.testRunStateCheckMethod = testRunStateCheckMethod;
        }

        public boolean isForceFinishAfterBreak() {
            return this.forceFinishAfterBreak;
        }

        public void setForceFinishAfterBreak(boolean forceFinishAfterBreak) {
            this.forceFinishAfterBreak = forceFinishAfterBreak;
        }
    }
}

