/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.util;

import android.util.Log;

public class LogUtil {
    private static final String LOG_PREFIX = "tenqube_";
    private static final int LOG_PREFIX_LENGTH = "tenqube_".length();
    private static final int MAX_LOG_TAG_LENGTH = 23;

    public static String makeLogTag(String str) {
        if (str.length() > 23 - LOG_PREFIX_LENGTH) {
            return LOG_PREFIX + str.substring(0, 23 - LOG_PREFIX_LENGTH - 1);
        }
        return LOG_PREFIX + str;
    }

    public static String makeLogTag(Class cls) {
        return LogUtil.makeLogTag(cls.getSimpleName());
    }

    public static void LOGD(String tag, String message) {
        if (Log.isLoggable((String)tag, (int)3)) {
            Log.d((String)tag, (String)message);
        }
    }

    public static void LOGV(String tag, String message) {
    }

    public static void LOGI(String tag, String message) {
    }

    public static void LOGI(String tag, String message, boolean isDebug) {
        if (isDebug) {
            Log.i((String)tag, (String)message);
        }
    }

    public static void LOGE(String tag, String message) {
        Log.e((String)tag, (String)message);
    }

    public static void LOGW(String tag, String message) {
        Log.w((String)tag, (String)message);
    }
}

