/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.text.TextUtils;
import tenqube.parser.core.TransactionTableData;
import tenqube.parser.model.Transaction;
import tenqube.parser.util.Validator;

class ParserMapper {
    ParserMapper() {
    }

    Transaction transform(TransactionTableData transactionTableData) {
        Transaction transaction = new Transaction();
        transaction.identifier = transactionTableData.identifier;
        transaction.cardName = Validator.getValidString(transactionTableData.cardTableData.cardName);
        if (TextUtils.isEmpty((CharSequence)transaction.cardName)) {
            return null;
        }
        transaction.cardNum = Validator.getValidString(transactionTableData.cardTableData.cardNum);
        transaction.cardType = transactionTableData.cardTableData.cardType;
        transaction.cardSubType = transactionTableData.cardTableData.cardSubType;
        transaction.parsedBalance = transactionTableData.parsedBalance;
        transaction.balance = transactionTableData.cardTableData.balance;
        transaction.smsId = transactionTableData.smsId;
        transaction.regId = transactionTableData.regId;
        transaction.sender = Validator.getValidString(transactionTableData.sender);
        if (TextUtils.isEmpty((CharSequence)transaction.sender)) {
            return null;
        }
        transaction.fullSms = Validator.getValidFullSMS(transactionTableData.fullSms);
        transaction.smsDate = transactionTableData.smsDate;
        if (TextUtils.isEmpty((CharSequence)transaction.smsDate)) {
            return null;
        }
        transaction.smsType = transactionTableData.smsType;
        transaction.spentMoney = transactionTableData.spentMoney;
        if (transaction.spentMoney == 0.0) {
            return null;
        }
        transaction.spentDate = transactionTableData.spentDate;
        if (TextUtils.isEmpty((CharSequence)transaction.spentDate)) {
            return null;
        }
        transaction.finishDate = transactionTableData.finishDate;
        if (TextUtils.isEmpty((CharSequence)transaction.finishDate)) {
            return null;
        }
        transaction.keyword = transactionTableData.keyword;
        transaction.installmentCount = transactionTableData.installmentCount;
        transaction.dwType = transactionTableData.dwType;
        transaction.currency = Validator.getValidCurrency(transactionTableData.currency);
        transaction.isOffset = transactionTableData.isOffset;
        transaction.isDuplicate = transactionTableData.isDuplicate;
        transaction.memo = transactionTableData.memo;
        transaction.spentLatitude = transactionTableData.spentLatitude;
        transaction.spentLongitude = transactionTableData.spentLongitude;
        transaction.categoryCode = transactionTableData.categoryCode;
        transaction.isSuccess = transactionTableData.isSuccess;
        transaction.isCurrentTran = transactionTableData.isCurrentTran;
        return transaction;
    }
}

