/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import tel.schich.javacan.CanSocket;
import tel.schich.javacan.NativeException;
import tel.schich.javacan.NativeInterface;

abstract class NativeSocket
implements CanSocket {
    final int sockFD;

    protected NativeSocket(int sock) {
        this.sockFD = sock;
    }

    public final void setBlockingMode(boolean block) throws NativeException {
        if (NativeInterface.setBlockingMode(this.sockFD, block) == -1) {
            throw new NativeException("Unable to set the blocking mode!");
        }
    }

    public final boolean isBlocking() throws NativeException {
        int result = NativeInterface.getBlockingMode(this.sockFD);
        if (result == -1) {
            throw new NativeException("Unable to get blocking mode!");
        }
        return result == 1;
    }

    public short poll(int events, int timeoutMillis) throws NativeException {
        short result = NativeInterface.poll(this.sockFD, events, timeoutMillis);
        if (result == -1) {
            throw new NativeException("Unable to poll");
        }
        return result;
    }

    @Override
    public final void close() throws NativeException {
        if (NativeInterface.close(this.sockFD) == -1) {
            throw new NativeException("Unable to close the socket");
        }
    }
}

