/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import tel.schich.javacan.OSError;

public class NativeException
extends Exception {
    private final OSError error;

    public NativeException(String message) {
        this(message, OSError.getLast());
    }

    public NativeException(String message, OSError error) {
        super(NativeException.makeSuperMessage(message, error));
        this.error = error;
    }

    private static String makeSuperMessage(String message, OSError lastError) {
        if (lastError == null) {
            return message;
        }
        return message + " - " + lastError.toString();
    }

    public boolean mayTryAgain() {
        if (this.error == null) {
            return false;
        }
        return this.error.mayTryAgain();
    }

    public OSError getError() {
        return this.error;
    }
}

