/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import tel.schich.javacan.NativeInterface;

public class JavaCAN {
    private static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            String libName = "JavaCAN";
            String arch = System.getProperty("os.arch").toLowerCase();
            String archSuffix = arch.contains("arm") ? "armv7" : (arch.contains("86") || arch.contains("amd") ? (arch.contains("64") ? "x86_64" : "x86_32") : (arch.contains("aarch64") ? "aarch64" : arch));
            String sourceLibPath = "/native/lib" + libName + "-" + archSuffix + ".so";
            try (InputStream libStream = NativeInterface.class.getResourceAsStream(sourceLibPath);){
                if (libStream == null) {
                    throw new LinkageError("Failed to load the native library: " + sourceLibPath + " not found.");
                }
                Path tempDirectory = Files.createTempDirectory(libName + "-" + archSuffix + "-", new FileAttribute[0]);
                Path libPath = tempDirectory.resolve("lib" + libName + ".so");
                Files.copy(libStream, libPath, StandardCopyOption.REPLACE_EXISTING);
                System.load(libPath.toString());
                libPath.toFile().deleteOnExit();
            }
            catch (IOException e) {
                throw new LinkageError("Unable to load native library!", e);
            }
            initialized = true;
        }
    }
}

