/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.io.ByteArrayOutputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import tel.schich.javacan.NativeException;
import tel.schich.javacan.NativeInterface;
import tel.schich.javacan.NativeSocket;

public class ISOTPSocket
extends NativeSocket {
    private ISOTPSocket(int sock) {
        super(sock);
    }

    public void bind(@NonNull String interfaceName, int incomingMask, int outgoingAddress) throws NativeException {
        long ifindex = NativeInterface.resolveInterfaceName(interfaceName);
        if (ifindex == 0L) {
            throw new NativeException("Unknown interface: " + interfaceName);
        }
        int result = NativeInterface.bindSocket(this.sockFD, ifindex, incomingMask, outgoingAddress);
        if (result == -1) {
            throw new NativeException("Unable to bind!");
        }
    }

    public long write(byte[] buffer, int offset, int length) throws NativeException {
        if (length + offset > buffer.length) {
            throw new ArrayIndexOutOfBoundsException("Tge given offset and length would go beyond the buffer!");
        }
        long bytesWritten = NativeInterface.write(this.sockFD, buffer, offset, length);
        if (bytesWritten == -1L) {
            throw new NativeException("Unable to write to ISOTP socket!");
        }
        return bytesWritten;
    }

    public void writeAll(byte[] buffer) throws NativeException {
        int offset = 0;
        while (offset < buffer.length) {
            offset = (int)((long)offset + this.write(buffer, offset, buffer.length - offset));
        }
    }

    public long read(byte[] buffer, int offset, int length) throws NativeException {
        long bytesRead = NativeInterface.read(this.sockFD, buffer, offset, length);
        if (bytesRead == -1L) {
            throw new NativeException("Unable to read from ISOTP socket!");
        }
        return bytesRead;
    }

    public byte[] readEntirely(int timeout) throws NativeException {
        long read;
        short polled;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[64];
        while ((polled = this.poll(3, timeout)) != 0 && (read = this.read(buf, 0, buf.length)) != 0L) {
            out.write(buf, 0, (int)read);
        }
        return out.toByteArray();
    }

    public static ISOTPSocket create() throws NativeException {
        int fd = NativeInterface.createIsotpSocket();
        if (fd == -1) {
            throw new NativeException("Unable to create socket!");
        }
        return new ISOTPSocket(fd);
    }
}

